/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.power.wireless;

import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.integration.baubles.BaublesUtil;
import crazypants.enderio.base.power.wireless.IWirelessCharger;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="enderio")
public final class WirelessChargerController {
    @Nonnull
    private static final Map<Integer, Collection<BlockPos>> perWorldChargers = new HashMap<Integer, Collection<BlockPos>>();

    public static void registerCharger(@Nonnull IWirelessCharger charger) {
        WirelessChargerController.getChargers(charger.getworld()).add(charger.getLocation().func_185334_h());
    }

    public static void deregisterCharger(@Nonnull IWirelessCharger charger) {
        WirelessChargerController.getChargers(charger.getworld()).remove(charger.getLocation());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT || event.phase != TickEvent.Phase.END || event.player.func_175149_v()) {
            return;
        }
        WirelessChargerController.chargePlayersItems((EntityPlayer)NullHelper.notnullF((Object)event.player, (String)"TickEvent.PlayerTickEvent without player"));
    }

    @Nonnull
    public static Collection<IWirelessCharger> getChargers(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Collection<IWirelessCharger> res) {
        Collection<BlockPos> chargers = WirelessChargerController.getChargers(world);
        Iterator<BlockPos> iterator = chargers.iterator();
        while (iterator.hasNext()) {
            IWirelessCharger charger;
            BlockPos chargerPos = iterator.next();
            IWirelessCharger iWirelessCharger = charger = chargerPos != null ? (IWirelessCharger)BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)chargerPos, IWirelessCharger.class) : null;
            if (charger != null) {
                if (!charger.isActive() || !charger.getRange().contains(pos)) continue;
                res.add(charger);
                continue;
            }
            iterator.remove();
        }
        return res;
    }

    private static void chargePlayersItems(@Nonnull EntityPlayer player) {
        for (IWirelessCharger charger : WirelessChargerController.getChargers(player.field_70170_p, BlockCoord.get((Entity)player), new ArrayList<IWirelessCharger>())) {
            if (charger == null || !WirelessChargerController.chargePlayersItems(player, charger) || !charger.forceSingle()) continue;
            return;
        }
    }

    private static boolean chargePlayersItems(@Nonnull EntityPlayer player, @Nonnull IWirelessCharger charger) {
        IInventory baubles;
        boolean res = charger.chargeItems((NonNullList<ItemStack>)player.field_71071_by.field_70460_b);
        res |= charger.chargeItems((NonNullList<ItemStack>)player.field_71071_by.field_70462_a);
        if (res |= charger.chargeItems((NonNullList<ItemStack>)player.field_71071_by.field_184439_c)) {
            player.field_71069_bz.func_75142_b();
        }
        if ((baubles = BaublesUtil.instance().getBaubles(player)) != null) {
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                ItemStack item = baubles.func_70301_a(i);
                if (!Prep.isValid(item)) continue;
                item = item.func_77946_l();
                if (!charger.chargeItems((NonNullList<ItemStack>)new NNList((Object[])new ItemStack[]{item}))) continue;
                baubles.func_70299_a(i, item);
                res = true;
            }
        }
        return res;
    }

    @Nonnull
    private static Collection<BlockPos> getChargers(@Nonnull World world) {
        return (Collection)NullHelper.notnull((Object)perWorldChargers.computeIfAbsent(world.field_73011_w.getDimension(), dim -> new HashSet()), (String)"computeIfAbsent()");
    }
}

