/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.base.te;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityMachineEntity;
import crazypants.enderio.base.machine.interfaces.IPoweredTask;
import crazypants.enderio.base.machine.task.PoweredTask;
import crazypants.enderio.base.machine.task.PoweredTaskProgress;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class AbstractCapabilityPoweredTaskEntity
extends AbstractCapabilityMachineEntity
implements IProgressTile {
    @Store(value={NBTAction.SAVE, NBTAction.ITEM})
    protected IPoweredTask currentTask = null;
    @Store(value={NBTAction.SAVE, NBTAction.ITEM})
    protected IMachineRecipe lastCompletedRecipe;
    protected IMachineRecipe cachedNextRecipe;
    protected int ticksSinceCheckedRecipe = 0;
    protected boolean startFailed = false;
    private Long theNextSeed = null;

    public AbstractCapabilityPoweredTaskEntity(@Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
    }

    protected AbstractCapabilityPoweredTaskEntity(@Nonnull EnderInventory inv, @Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(inv, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
    }

    @Override
    public boolean isActive() {
        return this.currentTask != null && this.currentTask.getProgress() >= 0.0f && this.hasPower() && this.redstoneCheckPassed;
    }

    public float getProgress() {
        return this.currentTask == null ? -1.0f : this.currentTask.getProgress();
    }

    @Nonnull
    public TileEntity getTileEntity() {
        return this;
    }

    public void setProgress(float progress) {
        this.currentTask = progress < 0.0f ? null : new PoweredTaskProgress(progress);
    }

    public IPoweredTask getCurrentTask() {
        return this.currentTask;
    }

    public float getExperienceForOutput(@Nonnull ItemStack output) {
        if (this.lastCompletedRecipe == null) {
            return 0.0f;
        }
        return this.lastCompletedRecipe.getExperienceForOutput(output);
    }

    public boolean getRedstoneChecksPassed() {
        return this.redstoneCheckPassed;
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        IMachineRecipe nextRecipe;
        if (!redstoneChecksPassed) {
            return false;
        }
        boolean requiresClientSync = false;
        requiresClientSync |= this.checkProgress(redstoneChecksPassed);
        if (this.currentTask != null || !this.hasPower() || !this.hasInputStacks()) {
            return requiresClientSync;
        }
        if (this.startFailed) {
            ++this.ticksSinceCheckedRecipe;
            if (this.ticksSinceCheckedRecipe < 20) {
                return false;
            }
        }
        this.ticksSinceCheckedRecipe = 0;
        if (this.theNextSeed == null) {
            this.theNextSeed = this.field_145850_b.field_73012_v.nextLong();
        }
        if ((nextRecipe = this.canStartNextTask(this.theNextSeed)) != null) {
            boolean started = this.startNextTask(nextRecipe, this.theNextSeed);
            if (started) {
                this.theNextSeed = null;
            }
            this.startFailed = !started;
        } else {
            this.startFailed = true;
        }
        return requiresClientSync;
    }

    protected boolean checkProgress(boolean redstoneChecksPassed) {
        if (this.currentTask == null || !this.hasPower()) {
            return false;
        }
        if (redstoneChecksPassed && !this.currentTask.isComplete()) {
            this.getEnergy().useEnergy();
            if (this.shouldDoubleTick(this.currentTask, this.getEnergy().getMaxUsage())) {
                this.getEnergy().useEnergy();
            }
        }
        if (this.currentTask.isComplete()) {
            this.taskComplete();
            return false;
        }
        return false;
    }

    protected void taskComplete() {
        if (this.currentTask != null) {
            this.lastCompletedRecipe = this.currentTask.getRecipe();
            IMachineRecipe.ResultStack[] output = this.currentTask.getCompletedResult();
            if (output.length > 0) {
                this.mergeResults(output);
            }
        }
        this.getEnergyLogic().damageCapacitor();
        this.func_70296_d();
        this.currentTask = null;
    }

    protected void mergeResults(@Nonnull IMachineRecipe.ResultStack[] results) {
        EnderInventory.View outputSlots = this.getInventory().getView(EnderInventory.Type.OUTPUT);
        int numOutputSlots = outputSlots.getSlots();
        if (numOutputSlots > 0) {
            NNList outputStacks = new NNList(numOutputSlots, (Object)ItemStack.field_190927_a);
            for (int i = 0; i < numOutputSlots; ++i) {
                ItemStack stack = outputSlots.getStackInSlot(i);
                if (!stack.func_190926_b()) {
                    stack = stack.func_77946_l();
                }
                outputStacks.add((Object)stack);
            }
            for (IMachineRecipe.ResultStack result : results) {
                if (Prep.isValid(result.item)) {
                    int numMerged = this.mergeItemResult(result.item, (NNList<ItemStack>)outputStacks);
                    if (numMerged <= 0) continue;
                    result.item.func_190918_g(numMerged);
                    continue;
                }
                if (result.fluid == null) continue;
                this.mergeFluidResult(result);
            }
            int listIndex = 0;
            for (int i = 0; i < numOutputSlots; ++i) {
                ItemStack stack = (ItemStack)outputStacks.get(listIndex);
                if (!stack.func_190926_b()) {
                    stack = stack.func_77946_l();
                }
                outputSlots.getSlot(i).set(stack);
                ++listIndex;
            }
        } else {
            for (IMachineRecipe.ResultStack result : results) {
                if (Prep.isValid(result.item)) {
                    Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)result.item.func_77946_l());
                    result.item.func_190920_e(0);
                    continue;
                }
                if (result.fluid == null) continue;
                this.mergeFluidResult(result);
            }
        }
        this.cachedNextRecipe = null;
    }

    protected void mergeFluidResult(@Nonnull IMachineRecipe.ResultStack result) {
    }

    protected void drainInputFluid(@Nonnull MachineRecipeInput fluid) {
    }

    protected boolean canInsertResultFluid(@Nonnull IMachineRecipe.ResultStack fluid) {
        return false;
    }

    protected int mergeItemResult(@Nonnull ItemStack item, @Nonnull NNList<ItemStack> outputStacks) {
        ItemStack copy = item.func_77946_l();
        if (Prep.isInvalid(copy)) {
            return 0;
        }
        int firstFreeSlot = -1;
        for (int i = 0; i < outputStacks.size(); ++i) {
            ItemStack outStack = (ItemStack)outputStacks.get(i);
            if (Prep.isValid(outStack)) {
                int num = this.getNumCanMerge(outStack, copy);
                outStack.func_190917_f(num);
                copy.func_190918_g(num);
                if (!Prep.isInvalid(copy)) continue;
                return item.func_190916_E();
            }
            if (firstFreeSlot >= 0) continue;
            firstFreeSlot = i;
        }
        if (firstFreeSlot >= 0) {
            outputStacks.set(firstFreeSlot, (Object)copy);
            return item.func_190916_E();
        }
        return 0;
    }

    @Nonnull
    protected NNList<MachineRecipeInput> getRecipeInputs() {
        NNList res = new NNList();
        EnderInventory.View inputSlots = this.getInventory().getView(EnderInventory.Type.INPUT);
        for (int slot = 0; slot < inputSlots.getSlots(); ++slot) {
            ItemStack item = inputSlots.getStackInSlot(slot);
            if (!Prep.isValid(item)) continue;
            res.add((Object)new MachineRecipeInput(slot, item));
        }
        return res;
    }

    @Nullable
    protected IMachineRecipe getNextRecipe() {
        if (this.cachedNextRecipe == null) {
            this.cachedNextRecipe = MachineRecipeRegistry.instance.getRecipeForInputs(this.getMachineLevel(), this.getMachineName(), this.getRecipeInputs());
        }
        return this.cachedNextRecipe;
    }

    @Nullable
    protected IMachineRecipe canStartNextTask(long nextSeed) {
        IMachineRecipe nextRecipe = this.getNextRecipe();
        if (nextRecipe == null) {
            return null;
        }
        return this.canInsertResult(nextSeed, nextRecipe) ? nextRecipe : null;
    }

    protected boolean canInsertResult(long nextSeed, @Nonnull IMachineRecipe nextRecipe) {
        IPoweredTask task = this.createTask(nextRecipe, nextSeed);
        if (task == null) {
            return false;
        }
        IMachineRecipe.ResultStack[] nextResults = task.getCompletedResult();
        NNList outputStacks = null;
        EnderInventory.View outputSlots = this.getInventory().getView(EnderInventory.Type.OUTPUT);
        int numOutputSlots = outputSlots.getSlots();
        if (numOutputSlots > 0) {
            outputStacks = new NNList(numOutputSlots, (Object)ItemStack.field_190927_a);
            boolean allFull = true;
            for (int i = 0; i < numOutputSlots; ++i) {
                ItemStack stack = outputSlots.getStackInSlot(i);
                if (Prep.isValid(stack)) {
                    stack = stack.func_77946_l();
                    if (allFull && stack.func_190916_E() < stack.func_77976_d()) {
                        allFull = false;
                    }
                } else {
                    allFull = false;
                }
                outputStacks.add((Object)stack);
            }
            if (allFull) {
                return false;
            }
        }
        for (IMachineRecipe.ResultStack result : nextResults) {
            if (!(Prep.isValid(result.item) ? outputStacks == null || this.mergeItemResult(result.item, (NNList<ItemStack>)outputStacks) == 0 : result.fluid != null && !this.canInsertResultFluid(result))) continue;
            return false;
        }
        return true;
    }

    protected boolean hasInputStacks() {
        EnderInventory.View inputSlots = this.getInventory().getView(EnderInventory.Type.INPUT);
        for (int i = 0; i < inputSlots.getSlots(); ++i) {
            ItemStack itemStack = inputSlots.getStackInSlot(i);
            if (!Prep.isValid(itemStack)) continue;
            return true;
        }
        return false;
    }

    protected int getNumCanMerge(@Nonnull ItemStack itemStack, @Nonnull ItemStack result) {
        if (!itemStack.func_77969_a(result) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)result)) {
            return 0;
        }
        return Math.min(itemStack.func_77976_d() - itemStack.func_190916_E(), result.func_190916_E());
    }

    protected boolean startNextTask(@Nonnull IMachineRecipe nextRecipe, long nextSeed) {
        if (this.hasPower() && nextRecipe.isRecipe(this.getMachineLevel(), this.getRecipeInputs())) {
            this.currentTask = this.createTask(nextRecipe, nextSeed);
            List<MachineRecipeInput> consumed = nextRecipe.getQuantitiesConsumed(this.getRecipeInputs());
            for (MachineRecipeInput item : consumed) {
                if (item == null) continue;
                if (Prep.isValid(item.item)) {
                    this.getInventory().getStackInSlot(item.slotNumber).func_190918_g(item.item.func_190916_E());
                    continue;
                }
                if (item.fluid == null) continue;
                this.drainInputFluid(item);
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected IPoweredTask createTask(@Nonnull IMachineRecipe nextRecipe, long nextSeed) {
        return new PoweredTask(nextRecipe, nextSeed, this.getRecipeInputs());
    }

    @Override
    protected void onAfterNbtRead() {
        super.onAfterNbtRead();
        this.cachedNextRecipe = null;
    }

    @Override
    @Nonnull
    public abstract String getMachineName();

    protected boolean shouldDoubleTick(@Nonnull IPoweredTask task, int usedEnergy) {
        return false;
    }
}

