/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Fluid;
import crazypants.enderio.base.config.recipes.xml.FluidMultiplier;
import crazypants.enderio.base.config.recipes.xml.Inputgroup;
import crazypants.enderio.base.config.recipes.xml.ItemMultiplier;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeInput;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.base.recipe.ThingsRecipeInput;
import crazypants.enderio.base.recipe.vat.VatRecipeManager;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Fermenting
extends AbstractConditional {
    private int energy;
    private NNList<Inputgroup> inputgroup = new NNList();
    private Optional<FluidMultiplier> inputfluid = this.empty();
    private Optional<Fluid> outputfluid = this.empty();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (this.inputgroup.size() < 1 || this.inputgroup.size() > 2) {
                throw new InvalidRecipeConfigException("Wrong number of <inputgroup>");
            }
            if (this.energy <= 0) {
                throw new InvalidRecipeConfigException("Invalid low value for 'energy'");
            }
            if (!this.inputfluid.isPresent()) {
                throw new InvalidRecipeConfigException("Missing <inputfluid>");
            }
            if (!this.outputfluid.isPresent()) {
                throw new InvalidRecipeConfigException("Missing <outputfluid>");
            }
            this.valid = this.inputfluid.get().isValid() && this.outputfluid.get().isValid();
            for (Inputgroup input : this.inputgroup) {
                this.valid = this.valid && input.isValid();
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <fermenting>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        for (Inputgroup input : this.inputgroup) {
            input.enforceValidity();
        }
        this.inputfluid.get().enforceValidity();
        this.outputfluid.get().enforceValidity();
    }

    @Override
    public void register(@Nonnull String recipeName) {
        if (this.isValid() && this.isActive()) {
            NNList inputStacks = new NNList();
            int slot = 0;
            NNList.NNIterator itr = this.inputgroup.fastIterator();
            while (itr.hasNext()) {
                NNList.NNIterator itr2 = ((Inputgroup)itr.next()).getItems().fastIterator();
                while (itr2.hasNext()) {
                    ItemMultiplier item = (ItemMultiplier)itr2.next();
                    inputStacks.add((Object)new ThingsRecipeInput(item.getThing(), slot, item.multiplier));
                }
                ++slot;
            }
            inputStacks.add((Object)new RecipeInput(this.inputfluid.get().getFluidStack(), this.inputfluid.get().multiplier));
            RecipeOutput recipeOutput = new RecipeOutput(this.outputfluid.get().getFluidStack());
            VatRecipeManager.getInstance().addRecipe(new Recipe(recipeOutput, this.energy, RecipeBonusType.NONE, (IRecipeInput[])inputStacks.toArray((Object[])new IRecipeInput[inputStacks.size()])));
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("energy".equals(name)) {
            this.energy = Integer.parseInt(value);
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("inputgroup".equals(name)) {
            this.inputgroup.add((Object)factory.read(new Inputgroup(), startElement));
            return true;
        }
        if ("inputfluid".equals(name) && !this.inputfluid.isPresent()) {
            this.inputfluid = this.of(factory.read(new FluidMultiplier(), startElement));
            return true;
        }
        if ("outputfluid".equals(name) && !this.outputfluid.isPresent()) {
            this.outputfluid = this.of(factory.read(new Fluid(), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

