/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.common.network;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.io.IOUtils;
import team.thegoldenhoe.cameraobscura.common.craftstudio.TilePictureFrame;
import team.thegoldenhoe.cameraobscura.common.network.CONetworkHandler;
import team.thegoldenhoe.cameraobscura.common.network.MessageFrameStatusUpdate;
import team.thegoldenhoe.cameraobscura.common.network.MessagePhotoDataToClient;
import team.thegoldenhoe.cameraobscura.common.network.PhotoDataHandler;

public class MessagePhotoRequest
implements IMessage {
    private int dim;
    private int x;
    private int y;
    private int z;
    private String location;

    public MessagePhotoRequest() {
    }

    public MessagePhotoRequest(int dim, BlockPos pos, String location) {
        this.dim = dim;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.location = location;
    }

    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.location = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.location);
    }

    public static final class Handler
    implements IMessageHandler<MessagePhotoRequest, IMessage> {
        public IMessage onMessage(MessagePhotoRequest message, MessageContext ctx) {
            System.out.println(String.format("Requested : %s", message.location));
            File picture = PhotoDataHandler.getFile(message.location);
            if (picture == null) {
                MessageFrameStatusUpdate frameUpdateMsg = new MessageFrameStatusUpdate(message.dim, message.x, message.y, message.z, message.location, TilePictureFrame.Status.MISSING);
                CONetworkHandler.NETWORK.sendToDimension((IMessage)frameUpdateMsg, message.dim);
                return null;
            }
            try {
                boolean isLast;
                byte[] bytes = IOUtils.toByteArray((InputStream)new FileInputStream(picture));
                int length = bytes.length;
                int index = 0;
                int maxPacketSize = 30000;
                do {
                    int remainingData;
                    isLast = (remainingData = length - index) <= maxPacketSize;
                    int packetSize = Math.min(maxPacketSize, remainingData);
                    byte[] outData = Arrays.copyOfRange(bytes, index, index + packetSize);
                    index += packetSize;
                    MessagePhotoDataToClient msg = new MessagePhotoDataToClient(message.location, outData, isLast, length);
                    CONetworkHandler.NETWORK.sendToDimension((IMessage)msg, message.dim);
                } while (!isLast);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            MessageFrameStatusUpdate frameUpdateMsg = new MessageFrameStatusUpdate(message.dim, message.x, message.y, message.z, message.location, TilePictureFrame.Status.AVAILABLE);
            CONetworkHandler.NETWORK.sendToDimension((IMessage)frameUpdateMsg, message.dim);
            return null;
        }
    }
}

