/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.common.network;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import team.thegoldenhoe.cameraobscura.client.ClientPhotoCache;

public class MessagePhotoDataToClient
implements IMessage {
    private String filename;
    private byte[] data;
    private boolean isLast;
    private int fullSize;

    public MessagePhotoDataToClient() {
    }

    public MessagePhotoDataToClient(String filename, byte[] data, boolean isLast, int fullSize) {
        this.filename = filename;
        this.data = data;
        this.isLast = isLast;
        this.fullSize = fullSize;
    }

    public void fromBytes(ByteBuf buf) {
        this.filename = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int datalength = buf.readInt();
        this.data = new byte[datalength];
        buf.readBytes(this.data);
        this.isLast = buf.readBoolean();
        this.fullSize = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.filename);
        buf.writeInt(this.data.length);
        buf.writeBytes(this.data);
        buf.writeBoolean(this.isLast);
        buf.writeInt(this.fullSize);
    }

    public static final class Handler
    implements IMessageHandler<MessagePhotoDataToClient, IMessage> {
        public IMessage onMessage(MessagePhotoDataToClient message, MessageContext ctx) {
            ClientPhotoCache.INSTANCE.addBytes(message.filename, message.data, message.isLast, message.fullSize);
            return null;
        }
    }
}

