/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.common.craftstudio;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import team.thegoldenhoe.cameraobscura.CSModelMetadata;
import team.thegoldenhoe.cameraobscura.CameraObscura;
import team.thegoldenhoe.cameraobscura.client.ClientPhotoCache;
import team.thegoldenhoe.cameraobscura.common.capability.CameraCapabilities;
import team.thegoldenhoe.cameraobscura.common.capability.ICameraStorageNBT;
import team.thegoldenhoe.cameraobscura.common.craftstudio.BlockProps;
import team.thegoldenhoe.cameraobscura.common.craftstudio.TileProps;
import team.thegoldenhoe.cameraobscura.common.item.ItemBrush;
import team.thegoldenhoe.cameraobscura.common.item.ItemPolaroidSingle;
import team.thegoldenhoe.cameraobscura.common.item.ItemSDCard;
import team.thegoldenhoe.cameraobscura.common.item.ItemVintagePaper;
import team.thegoldenhoe.cameraobscura.common.network.CONetworkHandler;
import team.thegoldenhoe.cameraobscura.common.network.MessagePhotoRequest;
import team.thegoldenhoe.cameraobscura.utils.ModelHandler;

public class TilePictureFrame
extends TileProps
implements ITickable {
    private String prevLocation = "";
    private String pictureLocation = "";
    private Status prevStatus = Status.EMPTY;
    private Status status = Status.EMPTY;
    private int glTextureID = 0;

    public void setPicture(String pictureLocation) {
        this.pictureLocation = pictureLocation;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getPictureLocation() {
        return this.pictureLocation;
    }

    public int getGlTextureID() {
        return this.glTextureID;
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        String newPictureLocation = "";
        ItemStack held = player.func_184586_b(hand);
        if (!held.func_190926_b() && held.func_77973_b() instanceof ItemBrush) {
            int nextModelIndex;
            CSModelMetadata modelData = ModelHandler.getModelByID(this.type);
            int n = nextModelIndex = modelData.tileParams.containsKey("nextModel") ? Integer.valueOf((String)modelData.tileParams.get("nextModel")) : -1;
            if (nextModelIndex < 0) {
                return true;
            }
            this.switchModel(nextModelIndex);
            return true;
        }
        if (!held.func_190926_b() && held.func_77973_b() instanceof ItemSDCard && held.func_77978_p() != null) {
            ICameraStorageNBT.SDCardStorage storage = (ICameraStorageNBT.SDCardStorage)held.getCapability(CameraCapabilities.getSDCardStorageCapability(), null);
            ArrayList<String> paths = storage.getSavedImagePaths();
            int nextPictureIndex = 0;
            for (int i = 0; i < paths.size(); ++i) {
                if (!this.cleanPath(paths.get(i)).equals(this.pictureLocation)) continue;
                nextPictureIndex = i + 1;
                break;
            }
            if (nextPictureIndex >= paths.size()) {
                nextPictureIndex = 0;
            }
            newPictureLocation = this.cleanPath(paths.get(nextPictureIndex));
        }
        if (!held.func_190926_b() && (held.func_77973_b() instanceof ItemPolaroidSingle || held.func_77973_b() instanceof ItemVintagePaper) && held.func_77978_p() != null && held.func_77978_p().func_74764_b("Photo")) {
            newPictureLocation = this.cleanPath(held.func_77978_p().func_74779_i("Photo"));
        }
        if (world.field_72995_K) {
            BufferedImage image = ClientPhotoCache.INSTANCE.getImage(newPictureLocation);
            if (image != null) {
                this.setPicture(newPictureLocation);
                this.setStatus(Status.AVAILABLE);
            } else {
                this.setPicture(newPictureLocation);
                this.setStatus(Status.REQUEST);
            }
        } else {
            this.setPicture(newPictureLocation);
        }
        return true;
    }

    private String cleanPath(String path) {
        if (path.startsWith("/")) {
            return path.substring(path.lastIndexOf(47) + 1);
        }
        return path.substring(path.lastIndexOf(92) + 1);
    }

    private void switchModel(int newModelID) {
        CSModelMetadata targetData = ModelHandler.getModelByID(newModelID);
        CSModelMetadata currentData = ModelHandler.getModelByID(this.type);
        if (!TileProps.canReplace(targetData.wrapper, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), false, this.rotation, currentData.wrapper.getExtendPlacementBlock(this.rotation))) {
            return;
        }
        this.removeSlaves();
        this.field_145850_b.func_175698_g(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, CameraObscura.blockProps.func_176223_P().func_177226_a((IProperty)BlockProps.FACING, (Comparable)EnumFacing.NORTH));
        TileProps tileProps = TileProps.checkAndGetTileEntity(this.field_145850_b, this.field_174879_c, newModelID);
        tileProps.type = newModelID;
        tileProps.rotation = this.rotation;
        tileProps.tileParams = targetData.tileParams;
        if (tileProps instanceof TilePictureFrame) {
            TilePictureFrame tileFrame = (TilePictureFrame)tileProps;
            tileFrame.prevStatus = this.status;
            tileFrame.prevLocation = this.prevLocation;
            tileFrame.status = this.status;
            tileFrame.pictureLocation = this.pictureLocation;
        }
        tileProps.init();
        tileProps.blockPlaced(this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b, this.field_174879_c);
        tileProps.createSlaves();
        tileProps.func_70296_d();
        this.field_145850_b.func_175664_x(this.field_174879_c);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74778_a("pictureLocation", this.pictureLocation);
        return tagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.setPicture(tagCompound.func_74779_i("pictureLocation"));
        this.setStatus(Status.REQUEST);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && (!this.prevLocation.equals(this.pictureLocation) || this.prevStatus != this.status)) {
            this.prevLocation = this.pictureLocation;
            this.prevStatus = this.status;
            if (!"".equals(this.pictureLocation) && this.status == Status.REQUEST) {
                this.setStatus(Status.LOADING);
                CONetworkHandler.NETWORK.sendToServer((IMessage)new MessagePhotoRequest(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c, this.pictureLocation));
            }
            float aspectRatio = this.tileParams.containsKey("aspectRatio") ? Float.valueOf((String)this.tileParams.get("aspectRatio")).floatValue() : 1.0f;
            this.glTextureID = CameraObscura.proxy.uploadPictureToGPU(this.glTextureID, this.pictureLocation, this.status, aspectRatio);
        }
    }

    public static enum Status {
        EMPTY,
        MISSING,
        REQUEST,
        LOADING,
        AVAILABLE,
        SERVER;

    }
}

