/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.common.capability;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import team.thegoldenhoe.cameraobscura.client.PhotoFilter;
import team.thegoldenhoe.cameraobscura.common.capability.CameraCapabilities;
import team.thegoldenhoe.cameraobscura.common.capability.ICameraStorageNBT;
import team.thegoldenhoe.cameraobscura.common.item.ItemFilter;
import team.thegoldenhoe.cameraobscura.common.item.ItemPolaroidStack;
import team.thegoldenhoe.cameraobscura.common.item.ItemSDCard;
import team.thegoldenhoe.cameraobscura.common.item.ItemVintagePaper;

public interface ICameraNBT
extends IItemHandler,
INBTSerializable<NBTTagCompound> {
    public ICameraStorageNBT getStorageDevice();

    public Pair<PhotoFilter, PhotoFilter> getFilters();

    default public void markDirty() {
    }

    public static class CameraHandler
    extends ItemStackHandler
    implements ICameraNBT {
        public CameraHandler() {
            super(3);
        }

        public void setSize(int size) {
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.markDirty();
        }

        @Override
        public ICameraStorageNBT getStorageDevice() {
            ItemStack storageStack = this.getStackInSlot(0);
            if (!storageStack.func_190926_b()) {
                if (storageStack.func_77973_b() instanceof ItemSDCard) {
                    return (ICameraStorageNBT)storageStack.getCapability(CameraCapabilities.getSDCardStorageCapability(), null);
                }
                if (storageStack.func_77973_b() instanceof ItemPolaroidStack) {
                    return (ICameraStorageNBT)storageStack.getCapability(CameraCapabilities.getPolaroidStackCapability(), null);
                }
                if (storageStack.func_77973_b() instanceof ItemVintagePaper) {
                    return (ICameraStorageNBT)storageStack.getCapability(CameraCapabilities.getVintageStorageCapability(), null);
                }
            }
            return null;
        }

        @Override
        public Pair<PhotoFilter, PhotoFilter> getFilters() {
            if (this.getSlots() == 1) {
                return Pair.of(null, null);
            }
            ItemStack filter1 = this.getStackInSlot(1);
            ItemStack filter2 = this.getStackInSlot(2);
            PhotoFilter pf1 = null;
            PhotoFilter pf2 = null;
            if (!filter1.func_190926_b() && filter1.func_77973_b() instanceof ItemFilter) {
                pf1 = ItemFilter.FilterType.VALUES[filter1.func_77952_i()].getFilter();
            }
            if (!filter2.func_190926_b() && filter2.func_77973_b() instanceof ItemFilter) {
                pf2 = ItemFilter.FilterType.VALUES[filter2.func_77952_i()].getFilter();
            }
            return Pair.of(pf1, pf2);
        }
    }
}

