/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.common.capability;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import team.thegoldenhoe.cameraobscura.common.capability.ICameraNBT;
import team.thegoldenhoe.cameraobscura.common.capability.ICameraStorageNBT;

public class CameraCapabilities {
    @CapabilityInject(value=ICameraNBT.class)
    @Nonnull
    private static Capability<ICameraNBT> cameraCapability;
    @CapabilityInject(value=ICameraStorageNBT.SDCardStorage.class)
    @Nonnull
    private static Capability<ICameraStorageNBT.SDCardStorage> sdCardStorageCapability;
    @CapabilityInject(value=ICameraStorageNBT.PolaroidStackStorage.class)
    @Nonnull
    private static Capability<ICameraStorageNBT.PolaroidStackStorage> polaroidStackStorageCapability;
    @CapabilityInject(value=ICameraStorageNBT.VintageStorage.class)
    @Nonnull
    private static Capability<ICameraStorageNBT.VintageStorage> vintageStorageCapability;

    @Nonnull
    public static Capability<ICameraNBT> getCameraCapability() {
        return cameraCapability;
    }

    @Nonnull
    public static Capability<ICameraStorageNBT.SDCardStorage> getSDCardStorageCapability() {
        return sdCardStorageCapability;
    }

    @Nonnull
    public static Capability<ICameraStorageNBT.PolaroidStackStorage> getPolaroidStackCapability() {
        return polaroidStackStorageCapability;
    }

    @Nonnull
    public static Capability<ICameraStorageNBT.VintageStorage> getVintageStorageCapability() {
        return vintageStorageCapability;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(ICameraNBT.class, (Capability.IStorage)new Capability.IStorage<ICameraNBT>(){

            public NBTBase writeNBT(Capability<ICameraNBT> capability, ICameraNBT instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<ICameraNBT> capability, ICameraNBT instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
            }
        }, ICameraNBT.CameraHandler::new);
        CapabilityManager.INSTANCE.register(ICameraStorageNBT.SDCardStorage.class, (Capability.IStorage)new Capability.IStorage<ICameraStorageNBT.SDCardStorage>(){

            public NBTBase writeNBT(Capability<ICameraStorageNBT.SDCardStorage> capability, ICameraStorageNBT.SDCardStorage instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<ICameraStorageNBT.SDCardStorage> capability, ICameraStorageNBT.SDCardStorage instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTTagCompound)nbt);
            }
        }, ICameraStorageNBT.SDCardStorage::new);
        CapabilityManager.INSTANCE.register(ICameraStorageNBT.PolaroidStackStorage.class, (Capability.IStorage)new Capability.IStorage<ICameraStorageNBT.PolaroidStackStorage>(){

            public NBTBase writeNBT(Capability<ICameraStorageNBT.PolaroidStackStorage> capability, ICameraStorageNBT.PolaroidStackStorage instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<ICameraStorageNBT.PolaroidStackStorage> capability, ICameraStorageNBT.PolaroidStackStorage instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTTagCompound)nbt);
            }
        }, ICameraStorageNBT.PolaroidStackStorage::new);
        CapabilityManager.INSTANCE.register(ICameraStorageNBT.VintageStorage.class, (Capability.IStorage)new Capability.IStorage<ICameraStorageNBT.VintageStorage>(){

            public NBTBase writeNBT(Capability<ICameraStorageNBT.VintageStorage> capability, ICameraStorageNBT.VintageStorage instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<ICameraStorageNBT.VintageStorage> capability, ICameraStorageNBT.VintageStorage instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTTagCompound)nbt);
            }
        }, ICameraStorageNBT.VintageStorage::new);
    }

    public static <C> ICapabilityProvider getProvider(final Capability<C> cap, final Supplier<C> factory) {
        return new ICapabilityProvider(){

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == cap;
            }

            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                return (T)(this.hasCapability(capability, facing) ? cap.cast(factory.get()) : null);
            }
        };
    }
}

