/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.client;

import com.mia.craftstudio.minecraft.client.CSClientModelWrapperVBO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import team.thegoldenhoe.cameraobscura.CSModelMetadata;
import team.thegoldenhoe.cameraobscura.client.ClientProxy;
import team.thegoldenhoe.cameraobscura.client.PhotographHelper;
import team.thegoldenhoe.cameraobscura.client.renderers.RenderPropInv;
import team.thegoldenhoe.cameraobscura.common.craftstudio.TileProps;
import team.thegoldenhoe.cameraobscura.common.item.ItemProps;
import team.thegoldenhoe.cameraobscura.common.item.ItemRegistry;
import team.thegoldenhoe.cameraobscura.utils.ModelHandler;

public enum ClientEvents {
    INSTANCE;

    private int playerOrientation;
    private boolean canPlace;
    private CSModelMetadata model = null;
    private int tx;
    private int ty;
    private int tz;
    private int tick = 0;

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)INSTANCE);
    }

    @SubscribeEvent
    public void capturePhotographs(TickEvent.RenderTickEvent event) {
        if (ClientProxy.photographPending && Minecraft.func_71410_x().field_71474_y.field_74319_N && event.phase == TickEvent.Phase.END) {
            PhotographHelper.capturePhotograph();
            Minecraft.func_71410_x().field_71474_y.field_74319_N = ClientProxy.hideGUIDefault;
            ClientProxy.photographPending = false;
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("cameraobscura:csitem", "inventory"), (Object)new RenderPropInv());
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b().equals(ItemRegistry.itemProps) && event.getItemStack().func_77942_o() && event.getItemStack().func_77978_p().func_74764_b("savedProp")) {
            event.getToolTip().add(TextFormatting.RESET + "" + TextFormatting.AQUA + I18n.func_74838_a((String)"text.cultivation.tooltip.saved_item"));
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.tick++ % 4 == 0) {
            this.model = null;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            ItemStack currentItem = player.field_71071_by.func_70448_g();
            if (currentItem == null) {
                return;
            }
            if (!(currentItem.func_77973_b() instanceof ItemProps)) {
                return;
            }
            if (!ModelHandler.getModelFromStack((ItemStack)currentItem).placeable) {
                return;
            }
            RayTraceResult target = Minecraft.func_71410_x().field_71476_x;
            if (target == null) {
                return;
            }
            if (target.field_72313_a != RayTraceResult.Type.BLOCK) {
                return;
            }
            CSModelMetadata data = ModelHandler.getModelFromStack(currentItem);
            this.playerOrientation = 0;
            if (!data.limitRotation) {
                this.playerOrientation = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
            } else {
                int direction = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                this.playerOrientation = direction * 4;
            }
            EnumFacing fg = target.field_178784_b;
            this.tx = target.func_178782_a().func_177958_n() + fg.func_82601_c();
            this.ty = target.func_178782_a().func_177956_o() + fg.func_96559_d();
            this.tz = target.func_178782_a().func_177952_p() + fg.func_82599_e();
            this.canPlace = TileProps.canPlace(data.wrapper, player.field_70170_p, this.tx, this.ty, this.tz, player.func_70093_af(), this.playerOrientation);
            this.model = data;
        }
    }

    @SubscribeEvent
    public void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        if (this.model != null && this.model.wrapper != null && this.model.showOutline) {
            ((CSClientModelWrapperVBO)this.model.wrapper).renderPlacement(event.getPlayer(), event.getPartialTicks(), this.canPlace, this.tx, this.ty, this.tz, this.playerOrientation);
        }
    }
}

