/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.conduit;

import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IConduitTexture;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.conduits.render.ConduitTextureWrapper;
import gg.galaxygaming.gasconduits.client.utils.GasRenderUtil;
import gg.galaxygaming.gasconduits.common.conduit.AbstractGasConduit;
import gg.galaxygaming.gasconduits.common.conduit.AbstractGasTankConduitNetwork;
import gg.galaxygaming.gasconduits.common.conduit.ConduitGasTank;
import gg.galaxygaming.gasconduits.common.conduit.IGasConduit;
import gg.galaxygaming.gasconduits.common.conduit.basic.GasConduitNetwork;
import gg.galaxygaming.gasconduits.common.utils.GasUtil;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractGasTankConduit
extends AbstractGasConduit {
    protected ConduitGasTank tank = new ConduitGasTank(0);
    protected boolean stateDirty = false;
    protected long lastEmptyTick = 0L;
    protected int numEmptyEvents = 0;
    protected boolean gasTypeLocked = false;

    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            return false;
        }
        AbstractGasTankConduitNetwork<? extends AbstractGasTankConduit> network = this.getTankNetwork();
        if (ToolUtil.isToolEquipped((EntityPlayer)player, (EnumHand)hand)) {
            CollidableComponent component;
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && (component = res.component) != null) {
                EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
                if (component.isCore()) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                        return true;
                    }
                    BlockPos pos = this.getBundle().getLocation().func_177972_a(faceHit);
                    IGasConduit gasConduit = (IGasConduit)ConduitUtil.getConduit((World)this.getBundle().getEntity().func_145831_w(), (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p(), IGasConduit.class);
                    if (!(gasConduit instanceof AbstractGasTankConduit) || !this.canJoinNeighbour(gasConduit)) {
                        return false;
                    }
                    AbstractGasTankConduit neighbour = (AbstractGasTankConduit)gasConduit;
                    if (neighbour.getGasType() != null) {
                        this.setGasTypeOnNetwork(this, neighbour.getGasType());
                    } else if (this.getGasType() != null) {
                        neighbour.setGasTypeOnNetwork(neighbour, this.getGasType());
                    }
                    return ConduitUtil.connectConduits((IServerConduit)this, (EnumFacing)faceHit);
                }
                EnumFacing connDir = component.getDirection();
                if (this.containsExternalConnection(connDir)) {
                    this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                } else if (this.containsConduitConnection(connDir)) {
                    GasStack curGasType = null;
                    if (this.getTankNetwork() != null) {
                        curGasType = this.getTankNetwork().getGasType();
                    }
                    ConduitUtil.disconnectConduits((IServerConduit)this, (EnumFacing)connDir);
                    this.setGasType(curGasType);
                }
            }
            return true;
        }
        if (heldItem.func_77973_b() == Items.field_151133_ar) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K) {
                long curTick = this.getBundle().getEntity().func_145831_w().func_82737_E();
                this.numEmptyEvents = curTick - this.lastEmptyTick < 20L ? ++this.numEmptyEvents : 1;
                this.lastEmptyTick = curTick;
                if (this.numEmptyEvents < 2) {
                    if (network.gasTypeLocked) {
                        network.setGasTypeLocked(false);
                        this.numEmptyEvents = 0;
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("gasconduits.item_gas_conduit.unlocked_type", new Object[0]), true);
                    }
                } else if (network != null) {
                    network.setGasType(null);
                    this.numEmptyEvents = 0;
                }
            }
            return true;
        }
        GasStack gas = GasUtil.getGasTypeFromItem(heldItem);
        if (gas != null) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && network != null && (network.getGasType() == null || network.getTotalVolume() < 500 || GasConduitNetwork.areGasesCompatible(this.getGasType(), gas))) {
                network.setGasType(gas);
                network.setGasTypeLocked(true);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("gasconduits.item_gas_conduit.locked_type", new Object[]{gas.getGas().getLocalizedName()}), true);
            }
            return true;
        }
        return false;
    }

    void setGasTypeLocked(boolean gasTypeLocked) {
        if (gasTypeLocked == this.gasTypeLocked) {
            return;
        }
        this.gasTypeLocked = gasTypeLocked;
        this.stateDirty = true;
    }

    private void setGasTypeOnNetwork(AbstractGasTankConduit con, GasStack type) {
        IConduitNetwork n = con.getNetwork();
        if (n != null) {
            AbstractGasTankConduitNetwork network = (AbstractGasTankConduitNetwork)n;
            network.setGasType(type);
        }
    }

    protected abstract boolean canJoinNeighbour(IGasConduit var1);

    public abstract AbstractGasTankConduitNetwork<? extends AbstractGasTankConduit> getTankNetwork();

    public void setGasType(GasStack gasType) {
        if (this.tank.getGas() != null && this.tank.getGas().isGasEqual(gasType)) {
            return;
        }
        if (gasType != null) {
            gasType = gasType.copy();
        } else if (this.tank.getGas() == null) {
            return;
        }
        this.tank.setGas(gasType);
        this.stateDirty = true;
    }

    public ConduitGasTank getTank() {
        return this.tank;
    }

    public GasStack getGasType() {
        GasStack result = null;
        if (this.getTankNetwork() != null) {
            result = this.getTankNetwork().getGasType();
        }
        if (result == null) {
            result = this.tank.getGas();
        }
        return result;
    }

    public boolean isGasTypeLocked() {
        return this.gasTypeLocked;
    }

    protected abstract void updateTank();

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.updateTank();
        if (nbtRoot.func_74764_b("tank")) {
            GasStack gas = GasStack.readFromNBT((NBTTagCompound)nbtRoot.func_74775_l("tank"));
            this.tank.setGas(gas);
        } else {
            this.tank.setGas(null);
        }
        this.gasTypeLocked = nbtRoot.func_74767_n("gasLocked");
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        GasStack gt = this.getGasType();
        if (gt != null) {
            this.updateTank();
            gt = gt.copy();
            gt.amount = this.tank.getStored();
            nbtRoot.func_74782_a("tank", (NBTBase)gt.write(new NBTTagCompound()));
        }
        nbtRoot.func_74757_a("gasLocked", this.gasTypeLocked);
    }

    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(hashCodes);
        if (this.gasTypeLocked) {
            hashCodes.add(1);
        }
    }

    public boolean canReceiveGas(EnumFacing side, Gas gas) {
        if (this.getNetwork() == null || !this.getConnectionMode(side).acceptsInput()) {
            return false;
        }
        return this.canExtractFromDir(side) && GasConduitNetwork.areGasesCompatible(this.getGasType(), gas);
    }

    public boolean canDrawGas(EnumFacing side, Gas gas) {
        if (this.getNetwork() == null || !this.getConnectionMode(side).acceptsOutput()) {
            return false;
        }
        return this.canInputToDir(side) && GasConduitNetwork.areGasesCompatible(this.getGasType(), gas);
    }

    @SideOnly(value=Side.CLIENT)
    public IConduitTexture getTransmitionTextureForState(@Nonnull CollidableComponent component) {
        if (this.tank.getGas() != null && this.tank.getGasType() != null && this.tank.getFilledRatio() > 0.01f) {
            return new ConduitTextureWrapper(GasRenderUtil.getStillTexture(this.tank.getGas()));
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Vector4f getTransmitionTextureColorForState(@Nonnull CollidableComponent component) {
        if (this.tank.getGasType() != null && this.tank.getFilledRatio() > 0.01f) {
            int color = this.tank.getGasType().getTint();
            return new Vector4f((double)(color >> 16 & 0xFF) / 255.0, (double)(color >> 8 & 0xFF) / 255.0, (double)(color & 0xFF) / 255.0, (double)this.tank.getFilledRatio());
        }
        return null;
    }
}

