/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.handlers.FileHandler;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.function.BiConsumer;
import org.apache.commons.io.IOUtils;

public class ThreadFileDownloader
extends Thread
implements IProcess {
    public final String sourceURL;
    public final File outputFile;
    private volatile double progress = 0.0;
    private volatile boolean finished = false;
    private volatile boolean failed = false;
    private volatile boolean running = false;
    private boolean processComplete = false;
    private Exception exception = null;
    private BiConsumer<ThreadFileDownloader, File> downloadCompleteHandler = null;

    public ThreadFileDownloader(String threadName, String sourceURL, File outputFile, BiConsumer<ThreadFileDownloader, File> completionCallBack) {
        super(threadName);
        this.sourceURL = sourceURL;
        this.outputFile = outputFile;
        this.downloadCompleteHandler = completionCallBack;
    }

    public ThreadFileDownloader(String threadName, String sourceURL, File outputFile) {
        this(threadName, sourceURL, outputFile, null);
    }

    @Override
    public synchronized void start() {
        if (this.downloadCompleteHandler != null) {
            BrandonsCore.proxy.addProcess(this);
        }
        this.running = true;
        super.start();
    }

    @Override
    public void run() {
        try {
            int n;
            URL url = new URL(this.sourceURL);
            if (!this.outputFile.getParentFile().exists() && !this.outputFile.getParentFile().mkdirs()) {
                throw new IOException("Could not create parent folder, Reason unknown");
            }
            if (!this.outputFile.exists() && !this.outputFile.createNewFile()) {
                throw new IOException("Could not create file, Reason unknown");
            }
            InputStream is = FileHandler.openURLStream(url);
            FileOutputStream os = new FileOutputStream(this.outputFile);
            int size = is.available();
            byte[] buffer = new byte[8192];
            long count = 0L;
            while (-1 != (n = is.read(buffer))) {
                ((OutputStream)os).write(buffer, 0, n);
                this.progress = (double)(count += (long)n) / (double)size;
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
            this.finished = true;
        }
        catch (Exception e) {
            LogHelperBC.warn("ThreadFileDownloader: DL Failed " + e.getMessage());
            if (BCConfig.devLog) {
                e.printStackTrace();
            }
            this.exception = e;
            this.failed = true;
        }
        this.running = false;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean downloadFailed() {
        return this.failed;
    }

    public Exception getException() {
        return this.exception;
    }

    public double getProgress() {
        return this.progress;
    }

    @Override
    public void updateProcess() {
        if (this.isFinished()) {
            this.downloadCompleteHandler.accept(this, this.outputFile);
            this.processComplete = true;
        } else if (this.downloadFailed()) {
            this.downloadCompleteHandler.accept(this, null);
            this.processComplete = true;
        }
    }

    @Override
    public boolean isDead() {
        return this.processComplete;
    }
}

