/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import java.io.IOException;
import java.util.function.Supplier;

public class GuiDraggable
extends MGuiElementBase<GuiDraggable> {
    protected int dragXOffset = 0;
    protected int dragYOffset = 0;
    protected boolean dragging = false;
    protected Supplier<Boolean> canDrag = () -> true;
    protected PositionValidator dragZoneValidator = null;
    protected int dragBarHeight = 20;
    protected Runnable onMovedCallback = null;
    protected PositionRestraint positionRestraint = MGuiElementBase::normalizePosition;

    public void setCanDrag(Supplier<Boolean> canDrag) {
        this.canDrag = canDrag;
    }

    public void setDragBarHeight(int dragBarHeight) {
        this.dragBarHeight = dragBarHeight;
    }

    public void setDragZoneValidator(PositionValidator dragZoneValidator) {
        this.dragZoneValidator = dragZoneValidator;
    }

    public void setOnMovedCallback(Runnable onMovedCallback) {
        this.onMovedCallback = onMovedCallback;
    }

    public void setPositionRestraint(PositionRestraint positionRestraint) {
        this.positionRestraint = positionRestraint;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        boolean captured = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (!captured && this.canDrag.get().booleanValue() && (this.dragZoneValidator != null ? this.dragZoneValidator.validate(mouseX, mouseY) : GuiHelper.isInRect(this.xPos(), this.yPos(), this.xSize(), this.dragBarHeight, mouseX, mouseY))) {
            this.dragging = true;
            this.dragXOffset = mouseX - this.xPos();
            this.dragYOffset = mouseY - this.yPos();
        }
        return captured;
    }

    @Override
    public boolean mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.dragging) {
            int xMove = mouseX - this.dragXOffset - this.xPos();
            int yMove = mouseY - this.dragYOffset - this.yPos();
            this.translate(xMove, yMove);
            this.validatePosition();
            if (this.onMovedCallback != null) {
                this.onMovedCallback.run();
            }
        }
        return super.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int state) {
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, state);
    }

    @Override
    public void reloadElement() {
        super.reloadElement();
        if (this.xSize() > 0 && this.ySize() > 0) {
            this.validatePosition();
        }
    }

    private void validatePosition() {
        int x = this.xPos();
        int y = this.yPos();
        this.positionRestraint.restrainPosition(this);
        if ((x != this.xPos() || y != this.yPos()) && this.onMovedCallback != null) {
            this.onMovedCallback.run();
        }
    }

    public static interface PositionValidator {
        public boolean validate(int var1, int var2);
    }

    public static interface PositionRestraint {
        public void restrainPosition(GuiDraggable var1);
    }
}

