/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.client.render;

import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.lib.client.model.MutableVertex;
import buildcraft.lib.client.sprite.DynamicTextureBC;
import buildcraft.lib.misc.RenderUtil;
import buildcraft.lib.misc.data.WorldPos;
import buildcraft.robotics.BCRoboticsBlocks;
import buildcraft.robotics.tile.TileZonePlanner;
import buildcraft.robotics.zone.ZonePlannerMapChunk;
import buildcraft.robotics.zone.ZonePlannerMapChunkKey;
import buildcraft.robotics.zone.ZonePlannerMapDataClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;

public class RenderZonePlanner
extends TileEntitySpecialRenderer<TileZonePlanner> {
    private static final Cache<WorldPos, DynamicTextureBC> TEXTURES = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).removalListener(RenderZonePlanner::onRemove).build();
    private static final int TEXTURE_WIDTH = 10;
    private static final int TEXTURE_HEIGHT = 8;

    private static void onRemove(RemovalNotification<WorldPos, DynamicTextureBC> notification) {
        DynamicTextureBC texture = (DynamicTextureBC)notification.getValue();
        if (texture != null) {
            texture.deleteGlTexture();
        }
    }

    public final void render(TileZonePlanner tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Minecraft.func_71410_x().field_71424_I.func_76320_a("bc");
        Minecraft.func_71410_x().field_71424_I.func_76320_a("zone");
        double offset = 0.001;
        double minX = 0.1875 - offset;
        double maxX = 0.8125 + offset;
        double minY = 0.3125 - offset;
        double maxY = 0.8125 + offset;
        double minZ = -offset;
        double maxZ = 1.0 + offset;
        IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (state.func_177230_c() != BCRoboticsBlocks.zonePlanner) {
            return;
        }
        EnumFacing side = ((EnumFacing)state.func_177229_b(BuildCraftProperties.BLOCK_FACING)).func_176734_d();
        DynamicTextureBC texture = RenderZonePlanner.getTexture(tile, side);
        if (texture == null) {
            return;
        }
        try (RenderUtil.AutoTessellator tessellator = RenderUtil.getThreadLocalUnusedTessellator();){
            Vec3d max;
            Vec3d min;
            BufferBuilder buffer = tessellator.tessellator.func_178180_c();
            texture.updateTexture();
            texture.bindGlTexture();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179090_x();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_179084_k();
            GlStateManager.func_179129_p();
            if (Minecraft.func_71379_u()) {
                GlStateManager.func_179103_j((int)7425);
            } else {
                GlStateManager.func_179103_j((int)7424);
            }
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            buffer.func_178969_c(x, y, z);
            float minU = 0.0f;
            float maxU = texture.getMaxU();
            float minV = 0.0f;
            float maxV = texture.getMaxV();
            switch (side) {
                case NORTH: {
                    min = new Vec3d(minX, minY, maxZ);
                    max = new Vec3d(maxX, maxY, maxZ);
                    break;
                }
                case EAST: {
                    min = new Vec3d(minZ, minY, minX);
                    max = new Vec3d(minZ, maxY, maxX);
                    break;
                }
                case SOUTH: {
                    min = new Vec3d(minX, minY, minZ);
                    max = new Vec3d(maxX, maxY, minZ);
                    break;
                }
                default: {
                    min = new Vec3d(maxZ, minY, minX);
                    max = new Vec3d(maxZ, maxY, maxX);
                }
            }
            MutableVertex vertex = new MutableVertex();
            vertex.colouri(-1);
            vertex.lighti(15, 15);
            vertex.positiond(min.field_72450_a, min.field_72448_b, min.field_72449_c).texf(minU, minV).render(buffer);
            vertex.positiond(max.field_72450_a, min.field_72448_b, max.field_72449_c).texf(maxU, minV).render(buffer);
            vertex.positiond(max.field_72450_a, max.field_72448_b, max.field_72449_c).texf(maxU, maxV).render(buffer);
            vertex.positiond(min.field_72450_a, max.field_72448_b, min.field_72449_c).texf(minU, maxV).render(buffer);
            buffer.func_178969_c(0.0, 0.0, 0.0);
            tessellator.tessellator.func_78381_a();
        }
        RenderHelper.func_74519_b();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    private static DynamicTextureBC getTexture(TileZonePlanner tile, EnumFacing side) {
        DynamicTextureBC texture;
        if (TEXTURES.getIfPresent((Object)new WorldPos(tile)) == null && (texture = RenderZonePlanner.createTexture(tile, side)) != null) {
            TEXTURES.put((Object)new WorldPos(tile), (Object)texture);
        }
        return (DynamicTextureBC)TEXTURES.getIfPresent((Object)new WorldPos(tile));
    }

    private static DynamicTextureBC createTexture(TileZonePlanner tile, EnumFacing side) {
        DynamicTextureBC texture = new DynamicTextureBC(10, 8);
        for (int textureX = 0; textureX < 10; ++textureX) {
            for (int textureY = 0; textureY < 8; ++textureY) {
                int posZ;
                int posX;
                int scale = 4;
                int offset1 = (textureX - 5) * scale;
                int offset2 = (textureY - 4) * scale;
                switch (side) {
                    case NORTH: {
                        posX = tile.func_174877_v().func_177958_n() + offset1;
                        posZ = tile.func_174877_v().func_177952_p() - offset2;
                        break;
                    }
                    case EAST: {
                        posX = tile.func_174877_v().func_177958_n() + offset2;
                        posZ = tile.func_174877_v().func_177952_p() + offset1;
                        break;
                    }
                    case SOUTH: {
                        posX = tile.func_174877_v().func_177958_n() + offset1;
                        posZ = tile.func_174877_v().func_177952_p() + offset2;
                        break;
                    }
                    default: {
                        posX = tile.func_174877_v().func_177958_n() - offset2;
                        posZ = tile.func_174877_v().func_177952_p() + offset1;
                    }
                }
                ChunkPos chunkPos = new ChunkPos(posX >> 4, posZ >> 4);
                texture.setColor(textureX, textureY, -1);
                ZonePlannerMapChunkKey key = new ZonePlannerMapChunkKey(chunkPos, tile.func_145831_w().field_73011_w.getDimension(), tile.getLevel());
                ZonePlannerMapChunk zonePlannerMapChunk = ZonePlannerMapDataClient.INSTANCE.getChunk(tile.func_145831_w(), key);
                if (zonePlannerMapChunk == null) {
                    return null;
                }
                texture.setColor(textureX, textureY, zonePlannerMapChunk.getColour(posX, posZ) | 0xFF000000);
            }
        }
        return texture;
    }
}

