/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.permissions.gui;

import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItemData;
import brad16840.common.gui.ContainerList;
import brad16840.common.gui.RadioButtonGroup;
import brad16840.common.permissions.PacketHandler;
import brad16840.common.permissions.PermissionGroup;
import brad16840.common.permissions.PermissionPlayer;
import brad16840.common.permissions.PermissionRule;
import brad16840.common.permissions.gui.ClientState;
import brad16840.common.permissions.gui.RuleView;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class GroupView
extends StackableContainer.SimpleContainer
implements RuleView.RuleSource {
    public ClientState.PermissionState state;
    @SideOnly(value=Side.CLIENT)
    public StackableContainer.ContainerButton addButton;
    @SideOnly(value=Side.CLIENT)
    public StackableContainer.ContainerButton editButton;
    @SideOnly(value=Side.CLIENT)
    public StackableContainer.ContainerButton deleteButton;
    @SideOnly(value=Side.CLIENT)
    public ContainerList list;
    @SideOnly(value=Side.CLIENT)
    public RadioButtonGroup permissionTab;
    private int storedScrollPos = 0;
    public int selectedRule = -3;
    public boolean waitingForResponse = false;
    public boolean needsUpdating = false;
    private boolean addingRule = false;
    private boolean blockPermission = false;
    public static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/permission_group.png");

    public GroupView(ClientState.PermissionState state) {
        super(176, 192);
        this.state = state;
        this.selectedRule = state.adminLevel - 1;
    }

    public boolean refreshData(EntityPlayer player) {
        if (!this.needsUpdating || player.field_70170_p.field_72995_K) {
            return true;
        }
        if (!PermissionGroup.hasGroup(player.field_70170_p, this.state.id)) {
            UniqueItemData.permissionError("view", PermissionGroup._name).send(player);
            Common.channel.sendToPlayer(player, new PacketHandler.UpdateClientGroup(this.container.stacks[this.stackId].size() - 1, null));
            return false;
        }
        PermissionPlayer p = PermissionGroup.getPlayerPermission(player);
        PermissionGroup group = PermissionGroup.getGroup(player.field_70170_p, this.state.id);
        if (group == null || !group.canView(p, true)) {
            UniqueItemData.permissionError("view", PermissionGroup._name).send(player);
            Common.channel.sendToPlayer(player, new PacketHandler.UpdateClientGroup(this.container.stacks[this.stackId].size() - 1, null));
            return false;
        }
        ClientState.PermissionState state = new ClientState.PermissionState(group.name, group.getId(), group.tempId, group.canEdit(p), group.visibility, new ClientState.PermissionGroupState(group.owner, group.owner.canView(p, true)), new ClientState.PermissionGroupState(group.parent, group.parent.canView(p, true)), group.getEditPrivilige(p));
        for (PermissionRule rule : group.rules) {
            if (rule != null && rule.group != null && rule.group.deleted) continue;
            state.rules.add(rule == null ? null : new ClientState.PermissionRuleState(new ClientState.PermissionGroupState(rule.group, rule.group.canView(p, true)), rule.isAllowed, rule.tempId));
        }
        Common.channel.sendToPlayer(player, new PacketHandler.UpdateClientGroup(this.container.stacks[this.stackId].size() - 1, state));
        this.state = state;
        this.updateScreen();
        return true;
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        return this.refreshData(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        this.blockPermission = this.state.id.startsWith("I_@");
        int yShift = this.blockPermission ? 20 : 0;
        this.list = new ContainerList(this, 7, 40 - yShift, 161, 100 + yShift, new ContainerList.DataProvider(this){

            @Override
            public int size() {
                return GroupView.this.state.rules.size() + 3;
            }

            @Override
            public void drawRowForeground(int row, int x, int y, int width, int mx, int my) {
                boolean selected;
                boolean hovered = mx >= x && mx < x + width && my >= y && my < y + 11;
                boolean bl = selected = row == GroupView.this.selectedRule + 3;
                if (GroupView.this.list.isDragging) {
                    hovered = row == GroupView.this.list.rowClicked;
                }
                int color1 = -3092272;
                int color2 = -3092416;
                int color3 = -12566352;
                if (hovered || selected) {
                    color1 = -8355712;
                    color2 = -8355712;
                }
                if (row < 2) {
                    boolean isOpenable;
                    ClientState.PermissionGroupState group = row == 0 ? GroupView.this.state.owner : GroupView.this.state.parent;
                    boolean bl2 = isOpenable = group != null && group.canView && group.id.startsWith("G_");
                    if (group != null && group.id.equals("P_" + Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
                        isOpenable = true;
                    }
                    GroupView.this.gui.text(this.container, new Translatable(row == 0 ? "gui.permissionlist.owner" : "gui.permissionlist.defaultto", new Object[0]).translate()).truncateString(50).drawString(x + 4, y + 1, color1, true);
                    GroupView.this.gui.text(this.container, (isOpenable && (hovered || selected) ? "\u00a7n" : "") + group.name).truncateString(width - 64).drawString(x + 60, y + 1, group.id.startsWith("G_") || group.id.startsWith("S_") ? -7339808 : color3, false);
                } else if (row == 2) {
                    GroupView.this.gui.text(this.container, new Translatable("gui.permissionlist.admins", new Object[0]).translate()).drawCenteredString(x + width / 2, y + 1, color2);
                } else if (row - 3 < GroupView.this.state.rules.size()) {
                    ClientState.PermissionRuleState rule = GroupView.this.state.rules.get(row - 3);
                    if (rule == null) {
                        GroupView.this.gui.text(this.container, new Translatable("gui.permissionlist.members", new Object[0]).translate()).drawCenteredString(x + width / 2, y + 1, color2);
                    } else {
                        boolean isOpenable;
                        boolean bl3 = isOpenable = rule.group != null && rule.group.canView && rule.group.id.startsWith("G_");
                        if (rule.group != null && rule.group.id.equals("P_" + Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
                            isOpenable = true;
                        }
                        GroupView.this.gui.text(this.container, new Translatable(rule.allowed ? "gui.permissionlist.allow" : "gui.permissionlist.deny", new Object[0]).translate()).truncateString(50).drawString(x + 4, y + 1, color1, true);
                        GroupView.this.gui.text(this.container, (isOpenable && (hovered || selected) ? "\u00a7n" : "") + rule.group.name).truncateString(width - 64).drawString(x + 60, y + 1, rule.group.id.startsWith("G_") || rule.group.id.startsWith("S_") ? -7339808 : color3, false);
                    }
                }
            }

            @Override
            public void drawRowBackground(int row, int x, int y, int width, int mx, int my) {
                boolean nextEdit;
                boolean selected;
                boolean hovered = mx >= x && mx < x + width && my >= y && my < y + 11;
                boolean bl = selected = row == GroupView.this.selectedRule + 3;
                if (GroupView.this.list.isDragging) {
                    hovered = row == GroupView.this.list.rowClicked;
                }
                int height = 10;
                boolean flag = false;
                boolean editable = GroupView.this.state.adminLevel == 0 || GroupView.this.state.adminLevel > 0 && GroupView.this.state.adminLevel + 3 <= row;
                GroupView.this.gui.drawRectangle(this.container, x, y, x + width, y + height, selected ? -14751714 : (hovered ? -8850318 : (editable ? -7631989 : -6250336)));
                boolean bl2 = nextEdit = GroupView.this.state.adminLevel != 0 && GroupView.this.state.adminLevel > 0;
                if (selected) {
                    GroupView.this.gui.drawHorizontalLine(this.container, x, x + width, y - 1, nextEdit && GroupView.this.state.adminLevel + 3 == row ? -13158601 : -14630848);
                    GroupView.this.gui.drawHorizontalLine(this.container, x, x + width, y + height, nextEdit && GroupView.this.state.adminLevel + 2 == row ? -13158601 : -14630848);
                } else if (nextEdit && GroupView.this.state.adminLevel + 2 == row) {
                    GroupView.this.gui.drawHorizontalLine(this.container, x, x + width, y + height, -13158601);
                } else if (editable) {
                    GroupView.this.gui.drawHorizontalLine(this.container, x, x + width, y + height, -6250336);
                } else {
                    GroupView.this.gui.drawHorizontalLine(this.container, x, x + width, y + height, -4144960);
                }
            }

            @Override
            public int getRowHeight(int slot) {
                return 11;
            }

            @Override
            public void rowSelected(int row, boolean doubleClicked, int mx) {
                if (doubleClicked || GroupView.this.selectedRule == row - 3) {
                    GroupView.this.openGroup();
                } else {
                    GroupView.this.setSelectionPos(row - 3);
                }
            }

            @Override
            public void rowDragged(int row, int mx, int my) {
                if (GroupView.this.waitingForResponse) {
                    return;
                }
                if ((row -= 3) >= 0 && GroupView.this.state.adminLevel >= 0) {
                    if (row > 0 && (GroupView.this.state.adminLevel == 0 || GroupView.this.state.adminLevel < row) && GroupView.this.list.getRowOffset(row + 3) - GroupView.this.list.scrollPos > my) {
                        GroupView.this.waitingForResponse = true;
                        Common.channel.sendToServer(new PacketHandler.LowerRule(GroupView.this.state.id, GroupView.this.state.rules.get(row - 1), false));
                        if (row == GroupView.this.selectedRule) {
                            --GroupView.this.selectedRule;
                        } else if (row - 1 == GroupView.this.selectedRule) {
                            ++GroupView.this.selectedRule;
                        }
                        --GroupView.this.list.rowClicked;
                        ClientState.PermissionRuleState rule = GroupView.this.state.rules.get(row - 1);
                        GroupView.this.state.rules.remove(row - 1);
                        GroupView.this.state.rules.add(row, rule);
                        return;
                    }
                    if (row < GroupView.this.state.rules.size() - 1 && (GroupView.this.state.adminLevel == 0 || GroupView.this.state.adminLevel < row + 1) && GroupView.this.list.getRowOffset(row + 4) - GroupView.this.list.scrollPos < my) {
                        GroupView.this.waitingForResponse = true;
                        Common.channel.sendToServer(new PacketHandler.LowerRule(GroupView.this.state.id, GroupView.this.state.rules.get(row), true));
                        ClientState.PermissionRuleState rule = GroupView.this.state.rules.get(row);
                        GroupView.this.state.rules.remove(row);
                        GroupView.this.state.rules.add(row + 1, rule);
                        if (row == GroupView.this.selectedRule) {
                            ++GroupView.this.selectedRule;
                        } else if (row + 1 == GroupView.this.selectedRule) {
                            --GroupView.this.selectedRule;
                        }
                        ++GroupView.this.list.rowClicked;
                        return;
                    }
                }
            }
        });
        this.list.scrollPos = this.storedScrollPos;
        this.permissionTab = new RadioButtonGroup(7, 20, 16, new RadioButtonGroup.RadioButtons(){
            long hoveringTime = -1L;
            int hoveredButton = -1;

            @Override
            public int size() {
                return 3;
            }

            @Override
            public int getButtonWidth(int i) {
                return i == 1 ? 59 : 51;
            }

            @Override
            public void drawButtonForeground(int button, int x, int y, int width, int height, int mx, int my) {
                GroupView.this.gui.text(GroupView.this, new Translatable("gui.permissionvisibility." + (button == 0 ? "public" : (button == 1 ? "protected" : "private")), new Object[0]).translate()).truncateString(width).drawCenteredString(x + width / 2, y + 4, -13158601);
            }

            @Override
            public void drawButtonBackground(int button, int x, int y, int width, int height, int mx, int my) {
                boolean hovered;
                boolean bl = hovered = my > y && my < y + height && mx > x && mx < x + width;
                if (hovered) {
                    long time = Minecraft.func_71386_F();
                    if (this.hoveredButton != button) {
                        this.hoveringTime = -1L;
                    }
                    this.hoveredButton = button;
                    if (this.hoveringTime == -1L) {
                        this.hoveringTime = time;
                    } else if (time - this.hoveringTime > 1000L && GroupView.this.gui != null) {
                        GroupView.this.gui.tooltips.clear();
                        if (button == 0) {
                            new Translatable("gui.permissionvisibility.public.tooltip", new Object[0]).addTo(GroupView.this.gui.tooltips);
                        } else if (button == 1) {
                            new Translatable("gui.permissionvisibility.protected.tooltip", new Object[0]).addTo(GroupView.this.gui.tooltips);
                        } else if (button == 2) {
                            new Translatable("gui.permissionvisibility.private.tooltip", new Object[0]).addTo(GroupView.this.gui.tooltips);
                        }
                    }
                } else if (this.hoveredButton == button) {
                    this.hoveringTime = -1L;
                    this.hoveredButton = -1;
                }
                hovered = hovered && GroupView.this.state.adminLevel == 0;
                GroupView.this.gui.drawRectangle(GroupView.this, x, y, x + width, y + height, GroupView.this.state.visibility == button ? -14751714 : (hovered ? -8850318 : -7631989));
                GroupView.this.gui.drawRectangleBorder(GroupView.this, x, y, x + width, y + height, -13158601);
            }

            @Override
            public void buttonClicked(int i) {
                if (GroupView.this.state.adminLevel == 0) {
                    Common.channel.sendToServer(new PacketHandler.ChangeVisibility(GroupView.this.state.id, i));
                }
            }
        });
        this.addButton = new StackableContainer.ContainerButton(this, 3, 7, 143, 52, 20, new Translatable("button.add", new Object[0]).translate());
        this.gui.addButton(this.addButton);
        this.editButton = new StackableContainer.ContainerButton(this, 6, 62, 143, 52, 20, new Translatable("button.edit", new Object[0]).translate());
        this.gui.addButton(this.editButton);
        this.deleteButton = new StackableContainer.ContainerButton(this, 2, 117, 143, 52, 20, new Translatable("button.delete", new Object[0]).translate());
        this.gui.addButton(this.deleteButton);
        this.gui.addButton(new StackableContainer.ContainerButton(this, 0, 7, 165, 163, 20, this.gui.getBackButtonText(this), new ContainerStack.Callback(){

            @Override
            public void call() {
                GroupView.this.gui.closeContainer(GroupView.this.stackId);
            }
        }));
        this.list.addButtons();
        this.setSelectionPos(this.selectedRule);
        if (!this.needsUpdating) {
            this.list.scrollToVisible(this.selectedRule + 3);
        }
    }

    @Override
    public void onClosed(EntityPlayer player) {
        if (this.isClient() && this.list != null) {
            this.storedScrollPos = this.list.scrollPos;
        }
        this.needsUpdating = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int x, int y) {
        if (this.state.id.startsWith("I_")) {
            if (this.blockPermission) {
                int o = this.state.name.indexOf(";");
                this.gui.text(this, new Translatable("gui.permissionlist.block", this.state.name.substring(6, o), this.state.name.substring(o + 7)).translate()).truncateString(160).drawCenteredString(86, 8, -13158601);
            } else {
                this.gui.text(this, new Translatable("gui.permissionlist.item", this.state.name.substring(0, 13).toUpperCase()).translate()).truncateString(160).drawCenteredString(86, 8, -13158601);
            }
        } else {
            this.gui.text(this, new Translatable("gui.permissionlist.group", this.state.name).translate()).truncateString(160).drawCenteredString(86, 8, -13158601);
        }
        if (!this.blockPermission) {
            this.permissionTab.drawForeground(x, y);
        }
        this.list.drawForeground(x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        if (this.blockPermission) {
            this.gui.drawTexture(this, 0, 0, this.guiWidth, this.guiHeight, 0, 0);
            this.gui.drawTexture(this, 0, 18, this.guiWidth, 42, 0, 38);
        } else {
            this.gui.drawTexture(this, 0, 0, this.guiWidth, this.guiHeight, 0, 0);
            this.permissionTab.drawBackground(x, y);
        }
        this.list.drawBackground(x, y);
    }

    @SideOnly(value=Side.CLIENT)
    public void setSelectionPos(int pos) {
        if (!this.isClient()) {
            return;
        }
        this.selectedRule = pos;
        if (this.selectedRule >= this.state.rules.size()) {
            this.selectedRule = this.state.rules.size() - 1;
        }
        PermissionPlayer player = (PermissionPlayer)PermissionGroup.getGroup((World)Minecraft.func_71410_x().field_71441_e, "P_" + Minecraft.func_71410_x().field_71439_g.func_70005_c_());
        ClientState.PermissionGroupState g = this.getSelectedGroup();
        this.deleteButton.field_146124_l = false;
        this.deleteButton.field_146126_j = new Translatable("button.delete", new Object[0]).translate();
        if (this.state.adminLevel < 0) {
            this.addButton.field_146124_l = false;
            this.editButton.field_146124_l = false;
            return;
        }
        boolean bl = this.addButton.field_146124_l = this.state.adminLevel == 0 || this.state.adminLevel - 1 <= this.selectedRule;
        if (this.selectedRule < 0) {
            boolean bl2 = this.editButton.field_146124_l = this.state.adminLevel == 0 && this.selectedRule != -1;
            if (this.selectedRule == -3 && this.state.adminLevel == 0 && (this.state.id.startsWith("G_") || this.state.id.startsWith("I_"))) {
                this.deleteButton.field_146124_l = true;
                this.deleteButton.field_146126_j = new Translatable(this.state.id.startsWith("G_") ? "button.disband" : "button.destroy", new Object[0]).translate();
            }
        } else if (this.state.adminLevel <= this.selectedRule) {
            boolean isNull = this.state.rules.get(this.selectedRule) == null;
            this.editButton.field_146124_l = !isNull;
            this.deleteButton.field_146124_l = !isNull;
        } else {
            this.editButton.field_146124_l = false;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseWheel(int x, int y, int wheel) {
        return this.list.mouseWheel(x, y, wheel);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseDown(int x, int y, int button) {
        if (button == 0) {
            if (this.list.mouseDown(x, y)) {
                return true;
            }
            if (!this.blockPermission && this.permissionTab.mouseDown(x, y)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseDragged(int x, int y, int button) {
        if (this.waitingForResponse) {
            return false;
        }
        return this.list.mouseDragged(x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseUp(int x, int y, int button) {
        return this.list.mouseUp(x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionPerformed(StackableContainer.ContainerButton button) {
        if (button.field_146124_l && !this.waitingForResponse) {
            if (button.field_146127_k == this.editButton.field_146127_k) {
                ClientState.PermissionGroupState selectedGroup = this.getSelectedGroup();
                if (selectedGroup == null) {
                    return;
                }
                this.addingRule = false;
                Common.channel.sendToServer(new PacketHandler.OpenRule(this.state.tempId, selectedGroup, this.selectedRule < 0 ? (this.selectedRule == -3 ? 2 : 3) : (this.state.rules.get((int)this.selectedRule).allowed ? 1 : 0), this.selectedRule < 0 ? 0 : this.state.rules.get((int)this.selectedRule).tempId));
            } else if (button.field_146127_k == this.addButton.field_146127_k) {
                this.addingRule = true;
                Common.channel.sendToServer(new PacketHandler.OpenRule(this.state.tempId, null, -1, 0));
            } else if (button.field_146127_k == this.deleteButton.field_146127_k) {
                if (this.selectedRule == -3 && this.state.adminLevel == 0) {
                    if (this.state.id.startsWith("G_")) {
                        this.gui.needsConfirming = true;
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this.gui, new Translatable("gui.confirmdisband.group.title", this.state.name).translate(), new Translatable("gui.confirmdisband.group.message", new Object[0]).translate(), new Translatable("gui.confirmdisband.group.yes", new Object[0]).translate(), new Translatable("gui.confirmdisband.group.no", new Object[0]).translate(), this.stackId));
                    } else if (this.state.id.startsWith("I_")) {
                        this.gui.needsConfirming = true;
                        if (this.blockPermission) {
                            int o = this.state.name.indexOf(";");
                            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this.gui, new Translatable("gui.confirmdisband.block.title", this.state.name.substring(6, o), this.state.name.substring(o + 7)).translate(), new Translatable("gui.confirmdisband.block.message", new Object[0]).translate(), new Translatable("gui.confirmdisband.block.yes", new Object[0]).translate(), new Translatable("gui.confirmdisband.block.no", new Object[0]).translate(), this.stackId));
                        } else {
                            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this.gui, new Translatable("gui.confirmdisband.item.title", this.state.name.substring(0, 13).toUpperCase()).translate(), new Translatable("gui.confirmdisband.item.message", new Object[0]).translate(), new Translatable("gui.confirmdisband.item.yes", new Object[0]).translate(), new Translatable("gui.confirmdisband.item.no", new Object[0]).translate(), this.stackId));
                        }
                    }
                    return;
                }
                if (this.state.adminLevel < 0 || this.selectedRule < this.state.adminLevel) {
                    return;
                }
                this.waitingForResponse = true;
                ClientState.PermissionRuleState rule = this.state.rules.remove(this.selectedRule);
                Common.channel.sendToServer(new PacketHandler.DeleteRule(this.state.id, rule));
                this.setSelectionPos(this.selectedRule - 1);
                this.updateScreen();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        if (keyCode == Common.permissionKey.func_151463_i()) {
            Common.channel.sendToServer(new PacketHandler.OpenPlayer());
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private ClientState.PermissionGroupState getSelectedGroup() {
        ClientState.PermissionRuleState rule;
        ClientState.PermissionGroupState selectedGroup = null;
        if (this.selectedRule == -3) {
            selectedGroup = this.state.owner;
        } else if (this.selectedRule == -2) {
            selectedGroup = this.state.parent;
        } else if (this.selectedRule >= 0 && (rule = this.state.rules.get(this.selectedRule)) != null) {
            selectedGroup = rule.group;
        }
        return selectedGroup;
    }

    @SideOnly(value=Side.CLIENT)
    public void addRule(ClientState.PermissionGroupState group, boolean isAllowed) {
        int pos = this.selectedRule + 1;
        if (this.state.adminLevel < 0) {
            return;
        }
        if (pos < this.state.adminLevel) {
            pos = this.state.adminLevel;
        }
        if (pos > this.state.rules.size()) {
            return;
        }
        ClientState.PermissionRuleState rule = new ClientState.PermissionRuleState(group, isAllowed);
        this.state.rules.add(pos, rule);
        this.setSelectionPos(pos);
        this.waitingForResponse = true;
        Common.channel.sendToServer(new PacketHandler.AddRule(this.state.id, pos == 0 ? 0 : (this.state.rules.get(pos - 1) == null ? -1 : this.state.rules.get((int)(pos - 1)).tempId), group, isAllowed, rule.tempId));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void confirmClicked(boolean accepted) {
        if (accepted) {
            this.waitingForResponse = true;
            Common.channel.sendToServer(new PacketHandler.DeleteGroup(this.state.id));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void openGroup() {
        ClientState.PermissionGroupState selectedGroup = this.getSelectedGroup();
        if (selectedGroup != null && selectedGroup.id.equals("P_" + Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
            Common.channel.sendToServer(new PacketHandler.OpenPlayer());
            return;
        }
        if (selectedGroup == null || !selectedGroup.canView || !selectedGroup.id.startsWith("G_")) {
            return;
        }
        Common.channel.sendToServer(new PacketHandler.OpenGroup(this.state.tempId, selectedGroup, true));
    }

    public void updateScreen() {
        if (this.isClient()) {
            this.setSelectionPos(this.selectedRule);
            this.list.updateData();
            this.gui.func_73876_c();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void accept(ClientState.PermissionGroupState group, boolean isAllowed, int ruleId) {
        ClientState.PermissionGroupState selectedGroup = this.getSelectedGroup();
        if (selectedGroup == null && !this.addingRule) {
            return;
        }
        if (!this.addingRule && this.selectedRule >= 0) {
            for (int i = 0; i < this.state.rules.size(); ++i) {
                if (this.state.rules.get(i) == null || this.state.rules.get((int)i).tempId != ruleId) continue;
                this.state.rules.get((int)i).allowed = isAllowed;
                this.state.rules.get((int)i).group = group;
                break;
            }
            Common.channel.sendToServer(new PacketHandler.EditRule(this.state.id, new ClientState.PermissionRuleState(group, isAllowed, ruleId)));
        } else {
            int pos = this.selectedRule + 1;
            if (pos < 1 && selectedGroup != null) {
                if (this.state.adminLevel == 0) {
                    if (pos == -2) {
                        this.state.owner = group;
                    } else if (pos == -1) {
                        this.state.parent = group;
                    } else {
                        return;
                    }
                    this.setSelectionPos(this.selectedRule);
                    this.waitingForResponse = true;
                    Common.channel.sendToServer(new PacketHandler.EditRule(this.state.id, new ClientState.PermissionRuleState(group, isAllowed, pos)));
                }
                return;
            }
            this.addRule(group, isAllowed);
        }
    }

    @Override
    public boolean stillValid(World world, PermissionPlayer player) {
        if (!PermissionGroup.hasGroup(world, this.state.id)) {
            return false;
        }
        PermissionGroup parentGroup = PermissionGroup.getGroup(world, this.state.id);
        return parentGroup != null && parentGroup.canView(player, true);
    }
}

