/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.permissions;

import brad16840.common.permissions.ItemPermission;
import brad16840.common.permissions.PermissionData;
import brad16840.common.permissions.PermissionGroup;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.world.World;

public class PermissionPlayer
extends PermissionGroup {
    @Override
    public String getId() {
        return "P_" + this.name;
    }

    public static PermissionPlayer create(World world, String name) {
        return (PermissionPlayer)PermissionPlayer.getGroup(world, "P_" + name);
    }

    public PermissionPlayer(PermissionData data, World world, String name) {
        super(data, world, name);
    }

    @Override
    protected boolean isMember(PermissionPlayer player, HashMap<PermissionGroup, Boolean> map, boolean includeOwner, boolean onlyAdmins) throws PermissionGroup.InvalidPermissionException {
        return player.name.equals(this.name) && !onlyAdmins;
    }

    public ArrayList<PermissionGroup> getAvailableGroups(World world, boolean onlyAdmins) {
        PermissionData data = PermissionData.get(world);
        data.loadAllPermissions(world);
        ArrayList<PermissionGroup> groups = new ArrayList<PermissionGroup>();
        for (PermissionGroup group : PermissionData.groups.values()) {
            if (group instanceof ItemPermission) continue;
            try {
                if (!(group instanceof PermissionPlayer) && !(group instanceof PermissionGroup.SpecialPermissionGroup) && !group.isMember(this, new HashMap<PermissionGroup, Boolean>(), true, onlyAdmins)) continue;
                groups.add(group);
            }
            catch (PermissionGroup.InvalidPermissionException invalidPermissionException) {}
        }
        return groups;
    }
}

