/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.common.Common;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class UnknownItem
extends Item {
    public String field_77774_bZ;

    public UnknownItem(String unlocalizedName) {
        this.field_77774_bZ = unlocalizedName;
        this.func_77655_b(unlocalizedName);
        this.func_77627_a(true);
    }

    public static ItemStack wrap(String id, int metadata, NBTTagCompound capabilityTag) {
        Item item;
        if (id == null) {
            id = "null";
        }
        if (id.toLowerCase().startsWith("oredict:")) {
            id = "oredict:" + id.substring(8);
            metadata = 0;
        }
        if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id))) == null) {
            ItemStack stack = new ItemStack((Item)Common.unknownItem, 1, metadata, capabilityTag);
            NBTTagCompound tag = new NBTTagCompound();
            UniqueItem.setNBTId(tag, id);
            stack.func_77982_d(tag);
            return stack;
        }
        return new ItemStack(item, 1, metadata, capabilityTag);
    }

    public static ItemStack wrap(String id, int metadata, int count, NBTTagCompound capabilityTag) {
        ItemStack stack = UnknownItem.wrap(id, metadata, capabilityTag);
        stack.func_190920_e(count);
        return stack;
    }

    public static String getItemDescriptor(ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_190926_b()) {
            return "null";
        }
        if (stack.func_77973_b() instanceof UnknownItem && (tag = stack.func_77978_p()) != null && tag.func_74764_b("id")) {
            return UniqueItem.getNBTId(tag);
        }
        String id = "null";
        try {
            id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.func_77973_b()).toString();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return id;
    }

    public static ItemStack unwrap(ItemStack stack) {
        Object forgeCaps = new NBTTagCompound();
        stack.func_77955_b(forgeCaps);
        forgeCaps = forgeCaps.func_150297_b("ForgeCaps", 10) ? forgeCaps.func_74775_l("ForgeCaps") : null;
        ItemStack result = UnknownItem.wrap(UnknownItem.getItemDescriptor(stack), stack.func_77960_j(), forgeCaps);
        result.func_77982_d(stack.func_77978_p());
        result.func_190920_e(stack.func_190916_E());
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        String id = UnknownItem.getItemDescriptor(stack);
        if (id == null) {
            id = "null";
        }
        if (id.toLowerCase().startsWith("oredict:")) {
            return;
        }
        if (ForgeRegistries.ITEMS.getValue(new ResourceLocation(id)) == Common.unknownItem) {
            new Translatable("tooltip.unknownitem.item", new Object[0]).addTo(list);
        } else {
            new Translatable("tooltip.unknownitem.proxy", id, stack.func_77960_j()).addTo(list);
        }
    }
}

