/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.backpacks.BackpackChecker;
import brad16840.backpacks.InventoryScanner;
import brad16840.backpacks.PacketHandler;
import brad16840.backpacks.blocks.BackpackBlock;
import brad16840.backpacks.blocks.BackpackBlockTileEntity;
import brad16840.backpacks.blocks.QuantumChest;
import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.gui.LoaderEditor;
import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.BackpackPouchUpgrade;
import brad16840.backpacks.items.BackpackRestorer;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.BackpackCommand;
import brad16840.common.ClientProxy;
import brad16840.common.ContainerStack;
import brad16840.common.ContainerStackGui;
import brad16840.common.KeyBindingRegistry;
import brad16840.common.Logger;
import brad16840.common.MessageChannel;
import brad16840.common.PacketHandler;
import brad16840.common.Proxy;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import brad16840.common.UnknownItem;
import brad16840.common.gui.BlockSelector;
import brad16840.common.gui.ChestContainer;
import brad16840.common.gui.PlayerContainer;
import brad16840.common.permissions.PermissionData;
import java.util.ArrayList;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(modid="backpacks16840", name="Backpacks!", version="3.5.8", guiFactory="brad16840.common.CommonGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class Common {
    public static final String modId = "backpacks16840";
    public static final String modVersion = "3.5.8";
    @Mod.Instance(value="backpacks16840")
    public static Common instance;
    public static final String mcVersionId = "1.12";
    public static final String compatibilityVersionId = "3.5";
    public static String fileVersion;
    public static boolean shiftOpensInSameStack;
    public static boolean _disableItemRestorers;
    public static boolean disableItemRestorers;
    public static boolean _disableCraftingGui;
    public static boolean disableCraftingGui;
    public static boolean _disableChestOpening;
    public static boolean disableChestOpening;
    public static boolean _allEditorsRequireOpPermission;
    public static boolean allEditorsRequireOpPermission;
    public static boolean restrictBackpackCreation;
    public static ArrayList<String> drdFilenames;
    private static String configDirectory;
    public static final MessageChannel channel;
    @SideOnly(value=Side.CLIENT)
    public static KeyBinding loaderKeyBinding;
    @SideOnly(value=Side.CLIENT)
    public static KeyBinding pauseLoaderKeyBinding;
    @SideOnly(value=Side.CLIENT)
    public static KeyBindingRegistry.KeyHandler openFirstKeyBinding;
    public static Backpack backpack;
    public static BackpackBlock backpackBlock;
    public static QuantumBackpack quantumBackpack;
    public static Backpack.BackpackResizer backpackResizer;
    public static BackpackRestorer backpackRestorer;
    public static BackpackPouchUpgrade backpackUpgrade;
    public static QuantumChest quantumChest;
    public static boolean _preventQuantumChestCreation;
    public static boolean preventQuantumChestCreation;
    public static boolean _disableBackpackBlocks;
    public static boolean disableBackpackBlocks;
    public static boolean _requirePermissionToDestroyQuantumChest;
    public static boolean requirePermissionToDestroyQuantumChest;
    public static boolean allowBackpackCommand;
    public static boolean disableAutoLoader;
    public static boolean animatedQuantumBackpacks;
    public static boolean displayPlacedBackpackNames;
    public static boolean _disableNesting;
    public static boolean disableNesting;
    public static boolean disableInventoryOpening;
    public static boolean reverseBackpackSearch;
    @SidedProxy(clientSide="brad16840.common.ClientProxy", serverSide="brad16840.common.Proxy")
    public static Proxy proxy;
    @SideOnly(value=Side.CLIENT)
    public static KeyBinding permissionKey;
    @SideOnly(value=Side.CLIENT)
    public static KeyBindingRegistry.KeyHandler loadKeyBinding;
    public static UnknownItem unknownItem;
    public static boolean hideUniqueItemIds;
    public static boolean disableRecipeEditor;
    public static boolean allowOpFunctionsInSinglePlayer;
    private long lastOpenTime = 0L;
    private WeakHashMap<EntityPlayer, Integer> tickNumbers = new WeakHashMap();
    public static boolean backpackRendererEnabled;
    public static int backpackRendererTickCount;
    public static Configuration config;

    public static void ensureCompatibleWith(String modName, String versionId) {
        if (versionId.startsWith("1.12 - ") && versionId.endsWith(compatibilityVersionId)) {
            return;
        }
        throw new RuntimeException(modName + " requires version \"" + versionId + "\" of Backpacks!, but that is incompatible with the installed version (" + mcVersionId + " - " + compatibilityVersionId + ")");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configDirectory = event.getModConfigurationDirectory().getAbsolutePath();
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        Logger.logger = event.getModLog();
        this.resetDefaults();
        this.LoadConfig();
        config.save();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        unknownItem = new UnknownItem("unknown_item");
        registry.register(unknownItem.setRegistryName(Common.unknownItem.field_77774_bZ));
        backpack = new Backpack("backpack");
        registry.register(backpack.setRegistryName(Common.backpack.field_77774_bZ));
        quantumBackpack = new QuantumBackpack("quantum_backpack");
        registry.register(quantumBackpack.setRegistryName(Common.quantumBackpack.field_77774_bZ));
        backpackResizer = new Backpack.BackpackResizer("backpack_resizer");
        registry.register(backpackResizer.setRegistryName(Common.backpackResizer.field_77774_bZ));
        backpackRestorer = new BackpackRestorer("backpack_restorer");
        registry.register(backpackRestorer.setRegistryName(Common.backpackRestorer.field_77774_bZ));
        backpackUpgrade = new BackpackPouchUpgrade("backpack_pouch");
        registry.register(backpackUpgrade.setRegistryName(Common.backpackUpgrade.field_77774_bZ));
        registry.register(new ItemBlock((Block)backpackBlock).setRegistryName(backpackBlock.getRegistryName()));
        registry.register(new ItemBlock((Block)quantumChest).setRegistryName(quantumChest.getRegistryName()));
        UniqueItem.registerContainerItem(backpack);
        if (proxy == null) {
            proxy = MessageChannel.getEffectiveSide() == Side.CLIENT ? new ClientProxy() : new Proxy();
        }
        proxy.preInit();
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        backpackBlock = new BackpackBlock("backpack_block");
        registry.register(backpackBlock.setRegistryName(Common.backpackBlock.field_149770_b));
        quantumChest = new QuantumChest("quantum_chest");
        registry.register(quantumChest.setRegistryName(Common.quantumChest.field_149770_b));
        GameRegistry.registerTileEntity(BackpackBlockTileEntity.class, (String)Common.backpackBlock.field_149770_b);
        GameRegistry.registerTileEntity(QuantumChestTileEntity.class, (String)"quantumChest");
        UniqueItem.registerProtectedBlockType(quantumChest);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        if (proxy == null) {
            proxy = MessageChannel.getEffectiveSide() == Side.CLIENT ? new ClientProxy() : new Proxy();
        }
        proxy.init(this);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)modId, (IGuiHandler)proxy);
        channel.initialize(modId);
        PacketHandler.registerMessages(channel);
        brad16840.common.permissions.PacketHandler.registerMessages(channel);
        brad16840.backpacks.PacketHandler.registerMessages(channel);
    }

    private void resetDefaults() {
        shiftOpensInSameStack = false;
        _disableItemRestorers = false;
        disableItemRestorers = false;
        hideUniqueItemIds = true;
        disableRecipeEditor = false;
        allowOpFunctionsInSinglePlayer = true;
        _disableChestOpening = false;
        disableChestOpening = false;
        _disableCraftingGui = false;
        disableCraftingGui = false;
        _allEditorsRequireOpPermission = false;
        allEditorsRequireOpPermission = false;
        Backpack._widths = new int[]{9, 9, 9, 9, 9, 9};
        Backpack._heights = new int[]{3, 4, 5, 6, 7, 8};
        Backpack._upgrades = new String[]{"backpacks16840:backpack_pouch", "backpacks16840:backpack_pouch", "backpacks16840:backpack_pouch", "backpacks16840:backpack_pouch", "backpacks16840:backpack_pouch"};
        Backpack.widths = Backpack._widths;
        Backpack.heights = Backpack._heights;
        Backpack.upgrades = Backpack._upgrades;
        Backpack._forceDefaults = false;
        Backpack.forceDefaults = false;
        BackpackBlock._canDuplicate = true;
        BackpackBlock.canDuplicate = true;
        _preventQuantumChestCreation = false;
        preventQuantumChestCreation = false;
        animatedQuantumBackpacks = true;
        displayPlacedBackpackNames = true;
        _disableNesting = false;
        disableNesting = false;
        _requirePermissionToDestroyQuantumChest = true;
        requirePermissionToDestroyQuantumChest = true;
        _disableBackpackBlocks = false;
        disableBackpackBlocks = false;
        disableAutoLoader = false;
        backpackRendererTickCount = 7;
        backpackRendererEnabled = true;
        disableInventoryOpening = false;
        reverseBackpackSearch = false;
        restrictBackpackCreation = false;
    }

    private boolean LoadProperty(String oldName, String newName, boolean defaultValue, String description) {
        return this.LoadProperty(oldName, newName, defaultValue, false, description);
    }

    private boolean LoadProperty(String oldName, String newName, boolean defaultValue, boolean reverseOldCondition, String description) {
        String category = "general";
        if (config.hasCategory(category) && oldName != null && config.getCategory(category).containsKey(oldName) && !oldName.equalsIgnoreCase(newName)) {
            if (reverseOldCondition) {
                config.get(category, newName, !config.getCategory(category).get(oldName).getBoolean(), description);
            } else {
                config.get(category, newName, config.getCategory(category).get(oldName).getBoolean(), description);
            }
            config.getCategory(category).remove((Object)oldName);
        }
        return config.get(category, newName, defaultValue, description).getBoolean(defaultValue);
    }

    private int[] LoadProperty(String oldName, String newName, int[] defaultValue, String description) {
        String category = "general";
        if (config.hasCategory(category) && oldName != null && config.getCategory(category).containsKey(oldName) && !oldName.equalsIgnoreCase(newName)) {
            config.get(category, newName, config.getCategory(category).get(oldName).getIntList(), description);
            config.getCategory(category).remove((Object)oldName);
        }
        return config.get(category, newName, defaultValue, description).getIntList();
    }

    private String[] LoadProperty(String oldName, String newName, String[] defaultValue, String description) {
        String category = "general";
        if (config.hasCategory(category) && oldName != null && config.getCategory(category).containsKey(oldName) && !oldName.equalsIgnoreCase(newName)) {
            config.get(category, newName, config.getCategory(category).get(oldName).getStringList(), description);
            config.getCategory(category).remove((Object)oldName);
        }
        return config.get(category, newName, defaultValue, description).getStringList();
    }

    private int LoadProperty(String oldName, String newName, int defaultValue, String description) {
        String category = "general";
        if (config.hasCategory(category) && oldName != null && config.getCategory(category).containsKey(oldName) && !oldName.equalsIgnoreCase(newName)) {
            config.get(category, newName, config.getCategory(category).get(oldName).getInt(), description);
            config.getCategory(category).remove((Object)oldName);
        }
        return config.get(category, newName, defaultValue, description).getInt();
    }

    private void LoadConfig() {
        int minUpgrades;
        int i;
        _disableNesting = !this.LoadProperty("disable_backpack_nesting", "Allow backpack nesting", !_disableNesting, true, "Allow backpacks to be placed inside of other backpacks for maximal space efficiency and item organization.");
        disableNesting = _disableNesting;
        _disableBackpackBlocks = !this.LoadProperty("disable_backpack_blocks", "Allow backpacks to be placed on blocks", !_disableBackpackBlocks, true, "Holding down the sneak key allows backpacks to be placed on the sides blocks. Set this to false to disable this feature.");
        disableBackpackBlocks = _disableBackpackBlocks;
        disableAutoLoader = !this.LoadProperty("disable_backpack_auto_loader", "Allow auto-collect & auto-resupply", !disableAutoLoader, true, "Allow backpacks to automatically collect items as you pick them up or to replace items as they break.");
        allowBackpackCommand = this.LoadProperty(null, "Allow backpack command", allowBackpackCommand, "Allow personal backpacks to be created and opened with the chat command /backpack.");
        displayPlacedBackpackNames = !this.LoadProperty("show_names_of_placed_backpacks", "Disable name tags for placed backpacks", !displayPlacedBackpackNames, true, "Placed backpacks show their name tags when you look at them. Set this to true to disable this feature.");
        _disableCraftingGui = !this.LoadProperty("disable_inventory_crafting_interface", "Allow portable crafting interface", !_disableCraftingGui, true, "Allow the portable crafting interface to be opened by right-clicking on any crafting table within your inventory.");
        disableCraftingGui = _disableCraftingGui;
        BackpackBlock.canDuplicate = BackpackBlock._canDuplicate = this.LoadProperty("ender_eyes_can_duplicate_backpacks", "Ender eyes can duplicate backpacks", BackpackBlock._canDuplicate, "When you use an ender eye on a placed backpack you will get a quantum copy of that backpack. Set this to false to disable this feature.");
        shiftOpensInSameStack = !this.LoadProperty("items_open_in_same_section", "Open backpacks in same section", !shiftOpensInSameStack, "When you open a backpack with right-click it will open in the same inventory section unless you're holding down shift. Set this to false to reverse this behaviour.");
        _disableItemRestorers = !this.LoadProperty("disable_item_restorers", "Allow backpack restorers", !_disableItemRestorers, true, "Allow backpack restorers to be used to restore lost backpacks or to create extra copies to share with friends.");
        disableItemRestorers = _disableItemRestorers;
        hideUniqueItemIds = !this.LoadProperty("hide_unique_item_ids", "Show backpack uuids", !hideUniqueItemIds, true, "Each backpack is assigned a unique identifier when it is first opened. Set this to true if you'd like to see these uuids in a backpack's tooltip.");
        disableRecipeEditor = this.LoadProperty("disable_recipe_editor", "Disable recipe editor", disableRecipeEditor, "Backpacks contains an in-game recipe editor available to opped players by pressing CTRL+R from the backpack UI. Set this to true to disable the recipe editor.");
        allowOpFunctionsInSinglePlayer = this.LoadProperty("allow_op_functions_in_single_player", "Treat single player as being opped", allowOpFunctionsInSinglePlayer, "Several features in Backpacks! are exclusive to opped players. When this is true these features will also be allowed in single player.");
        disableChestOpening = _disableChestOpening = this.LoadProperty("disable_custom_block_interfaces", "Disable backpack-friendly vanilla UIs", _disableChestOpening, "When you open a vanilla chest or crafting table with a backpack in your hand it will open a backpack-friendly version of the vanilla UI. Set this to true to disable this feature.");
        allEditorsRequireOpPermission = _allEditorsRequireOpPermission = this.LoadProperty("need_op_permission_to_use_any_editor", "Limit collect/resupply to opped players", _allEditorsRequireOpPermission, "Set this to true if you want to prevent non-opped players from being able to configure what items their backpacks should collect and resupply.");
        Backpack._widths = this.LoadProperty("backpack_widths", "Backpack widths", Backpack._widths, "Defines how many columns of storage a backpack with X pouches will have.");
        Backpack._heights = this.LoadProperty("backpack_heights", "Backpack heights", Backpack._heights, "Defines how many rows of storage a backpack with X pouches will have.");
        Backpack._upgrades = this.LoadProperty("backpack_upgrades", "Backpack upgrades", Backpack._upgrades, "Defines what item is required to add another pouch to a backpack that already has X pouches.");
        Backpack._allowBetterUpgrades = !this.LoadProperty("allow_better_upgrades", "Use strict upgrade tiers", !Backpack._allowBetterUpgrades, "Set this to true if you want to prevent higher-tier upgrades from being used in place of lower-tier upgrades.");
        Backpack.allowBetterUpgrades = Backpack._allowBetterUpgrades;
        if (Backpack._widths.length < 1) {
            Backpack._widths = new int[]{3};
        }
        if (Backpack._heights.length < 1) {
            Backpack._heights = new int[]{3};
        }
        if (Backpack._upgrades.length < 1) {
            Backpack._upgrades = new String[]{"backpacks16840:backpack_pouch"};
        }
        if (Backpack._widths.length != Backpack._heights.length) {
            int[] w = Backpack._widths;
            int[] h = Backpack._heights;
            int min = w.length < h.length ? w.length : h.length;
            Backpack._widths = new int[min];
            Backpack._heights = new int[min];
            for (i = 0; i < min; ++i) {
                Backpack._widths[i] = w[i];
                Backpack._heights[i] = h[i];
            }
            Logger.logger.warn("The list of backpack widths was a different size to the list of backpack heights, so unpaired values are being ignored");
        }
        if (Backpack._upgrades.length < (minUpgrades = Math.max(Backpack._widths.length - 1, 1))) {
            String[] upgrades = Backpack._upgrades;
            Backpack._upgrades = new String[minUpgrades];
            String lastUpgrade = "backpacks16840:backpack_pouch";
            for (i = 0; i < minUpgrades; ++i) {
                if (upgrades.length > i) {
                    lastUpgrade = upgrades[i];
                }
                Backpack._upgrades[i] = lastUpgrade;
            }
        }
        Backpack.widths = Backpack._widths;
        Backpack.heights = Backpack._heights;
        Backpack.upgrades = Backpack._upgrades;
        Backpack.forceDefaults = Backpack._forceDefaults = this.LoadProperty("restrict_backpack_size_to_presets", "Enforce backpack sizes", Backpack._forceDefaults, "Set this to true if you want to force the size of existing backpacks to match a size defined by Backpack widths & Backpack heights.");
        preventQuantumChestCreation = _preventQuantumChestCreation = this.LoadProperty("prevent_quantum_chest_placement", "Disable creation of quantum chests", _preventQuantumChestCreation, "Set this to true to prevent new quantum chests being placed in the world (existing chests won't be affected).");
        animatedQuantumBackpacks = !this.LoadProperty("animate_quantum_backpacks", "Disable quantum backpack texture animation", !animatedQuantumBackpacks, true, "Set this to true to disable the animated texture used by the 3D quantum backpack model.");
        _requirePermissionToDestroyQuantumChest = !this.LoadProperty("require_permission_to_destroy_quantum_chests", "Disable quantum chest permission lock", !_requirePermissionToDestroyQuantumChest, true, "Quantum chests can only be destroyed by players with permission to do so. Set this to true to allow all players to destroy quantum chests.");
        requirePermissionToDestroyQuantumChest = _requirePermissionToDestroyQuantumChest;
        backpackRendererTickCount = this.LoadProperty("backpack_renderer_refresh_frequency", "Update frequency for backpack renderer", backpackRendererTickCount, "Defines how often (in ticks) the backpack renderer should update. Setting this to 0 will turn off backpack renderer updates.");
        backpackRendererEnabled = !this.LoadProperty("backpack_renderer_enabled", "Disable backpack renderer", !backpackRendererEnabled, true, "When a player has a backpack on their hotbar it will be rendered on their back. Set this to true to disable this feature.");
        disableInventoryOpening = !this.LoadProperty("disable_open_backpack_with_inventory_key", "Open backpack with inventory key", !disableInventoryOpening, true, "When this is true pressing the inventory key while you have a backpack in your hand will open the backpack.");
        reverseBackpackSearch = this.LoadProperty("reverse_open_first_backpack_search_order", "Reverse search for first backpack", reverseBackpackSearch, "When this is true the 'open first backpack in inventory' key will open the last backpack in your inventory.");
        restrictBackpackCreation = this.LoadProperty(null, "Restrict backpack creation", restrictBackpackCreation, false, "Set this to true if you want to prevent users from creating multiple backpacks (all new backpacks they open will become copies of their bound backpack).");
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals(modId) && config.hasChanged()) {
            this.resetDefaults();
            this.LoadConfig();
            config.save();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Logger.register();
        if (MessageChannel.getEffectiveSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new KeyBindingRegistry());
            ContainerStackGui.customMouseClickHandlers.add(new ContainerStackGui.CustomMouseClickHandler(){

                @Override
                public boolean handle(EntityPlayer player, ItemStack stack, boolean holdingShift) {
                    if ((stack.func_77973_b() instanceof Backpack || stack.func_77973_b() instanceof QuantumBackpack) && !holdingShift) {
                        Backpack.openingStandalone = true;
                        ((UniqueItem.OpenableItem)stack.func_77973_b()).open(player, stack, player.field_70170_p);
                        return true;
                    }
                    return false;
                }
            });
        }
        MinecraftForge.EVENT_BUS.register((Object)new InventoryScanner());
        PacketHandler.OpenEditorWindow.nonOpEditors.add("loader");
        PacketHandler.OpenEditorWindow.nonOpEditors.add("loadbackpack");
        PacketHandler.OpenEditorWindow.editors.add(new PacketHandler.OpenEditorWindow.CustomEditor(){

            public boolean load(ContainerStack container, int stackId, EntityPlayer player) {
                StackableContainer stack;
                if (container.stacks.length > stackId && (stack = container.getContainer(stackId)) instanceof ContainerStack.LoadableContainer) {
                    String uuid = stack.getId();
                    NBTTagCompound tag = UniqueItemData.get(player.field_70170_p).getItemData(uuid, false);
                    if (tag == null) {
                        return false;
                    }
                    container.addContainers(player, new StackableContainer[]{new BlockSelector(), new LoaderEditor(uuid, tag, ((ContainerStack.LoadableContainer)((Object)stack)).getName())});
                    return true;
                }
                return false;
            }

            @Override
            public boolean loadEditor(String type, int stackId, ContainerStack container, EntityPlayer player) {
                block7: {
                    block10: {
                        block8: {
                            block9: {
                                if (!type.equals("loadbackpack")) break block7;
                                if (disableAutoLoader) {
                                    new Translatable("problem.autoloaddisabled", new Object[0]).send(player);
                                    return true;
                                }
                                if (container != null) break block8;
                                if (!(player.field_71070_bA instanceof ContainerChest)) break block9;
                                InventoryScanner.loadFromInventory(player, ((ContainerChest)player.field_71070_bA).func_85151_d());
                                player.field_71070_bA.func_75142_b();
                                break block10;
                            }
                            if (!(player.field_71070_bA instanceof ContainerPlayer)) break block10;
                            InventoryScanner.loadFromInventory(player, (IInventory)player.field_71071_by);
                            player.field_71070_bA.func_75142_b();
                            break block10;
                        }
                        for (int i = 0; i < container.stacks.length; ++i) {
                            StackableContainer c = container.getContainer(i);
                            if (c instanceof ChestContainer && stackId == 0) {
                                InventoryScanner.loadFromInventory(player, ((ChestContainer)c).inventory);
                                container.func_75142_b();
                                break;
                            }
                            if (!(c instanceof PlayerContainer)) continue;
                            InventoryScanner.loadFromInventory(player, (IInventory)((PlayerContainer)c).inventory);
                            container.func_75142_b();
                            break;
                        }
                    }
                    return true;
                }
                if (type.equals("loader") && container.stacks.length > stackId) {
                    int i;
                    if (this.load(container, stackId, player)) {
                        return true;
                    }
                    for (i = stackId; i < container.stacks.length; ++i) {
                        if (!this.load(container, i, player)) continue;
                        return true;
                    }
                    for (i = 0; i < stackId; ++i) {
                        if (!this.load(container, i, player)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    @SubscribeEvent
    public void onKeypress(InputEvent.KeyInputEvent event) {
        if (MessageChannel.getEffectiveSide() == Side.CLIENT) {
            this.handleKeypress(event);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (MessageChannel.getEffectiveSide() == Side.CLIENT || backpackRendererTickCount == 0) {
            return;
        }
        Integer count = this.tickNumbers.get(event.player);
        count = count == null ? Integer.valueOf(backpackRendererTickCount) : Integer.valueOf(count + 1);
        if (count >= backpackRendererTickCount) {
            count = 0;
            BackpackChecker.update(event.player);
        }
        this.tickNumbers.put(event.player, count);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleKeypress(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (disableInventoryOpening || mc == null || mc.field_71439_g == null || !mc.field_71474_y.field_151445_Q.func_151470_d()) {
            return;
        }
        long time = Minecraft.func_71386_F();
        if (time - this.lastOpenTime < 500L) {
            KeyBinding.func_74510_a((int)mc.field_71474_y.field_151445_Q.func_151463_i(), (boolean)false);
            while (mc.field_71474_y.field_151445_Q.func_151468_f()) {
            }
            return;
        }
        ItemStack stack = mc.field_71439_g.func_184614_ca();
        if (mc.field_71462_r == null && !stack.func_190926_b() && stack.func_77973_b() instanceof UniqueItem.OpenableItem && !mc.field_71439_g.func_70093_af()) {
            this.lastOpenTime = time;
            KeyBinding.func_74510_a((int)mc.field_71474_y.field_151445_Q.func_151463_i(), (boolean)false);
            while (mc.field_71474_y.field_151445_Q.func_151468_f()) {
            }
            if (!((UniqueItem.OpenableItem)stack.func_77973_b()).ensureInventoryIdentifiers((EntityPlayer)mc.field_71439_g, stack)) {
                return;
            }
            channel.sendToServer(new PacketHandler.OpenItemOnServer(UniqueItem.getIdentifier(stack)));
        }
        stack = mc.field_71439_g.func_184592_cb();
        if (mc.field_71462_r == null && !stack.func_190926_b() && stack.func_77973_b() instanceof UniqueItem.OpenableItem && !mc.field_71439_g.func_70093_af()) {
            this.lastOpenTime = time;
            KeyBinding.func_74510_a((int)mc.field_71474_y.field_151445_Q.func_151463_i(), (boolean)false);
            while (mc.field_71474_y.field_151445_Q.func_151468_f()) {
            }
            if (!((UniqueItem.OpenableItem)stack.func_77973_b()).ensureInventoryIdentifiers((EntityPlayer)mc.field_71439_g, stack)) {
                return;
            }
            channel.sendToServer(new PacketHandler.OpenItemOnServer(UniqueItem.getIdentifier(stack)));
        }
    }

    @Mod.EventHandler
    public void onServerLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new BackpackCommand());
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        channel.sendToPlayer(event.player, new PacketHandler.InitializePlayer());
        channel.sendToPlayer(event.player, new PacketHandler.InitializePlayer());
    }

    @SubscribeEvent
    public void saveEvent(WorldEvent.Save event) {
        if (MessageChannel.getEffectiveSide() != Side.SERVER) {
            return;
        }
        UniqueItemData.saveData(true);
        PermissionData.saveData(true);
    }

    @SubscribeEvent
    public void loadEvent(WorldEvent.Load event) {
        UniqueItemData.uniqueItemDataClient = null;
        PermissionData.permissionDataClient = null;
        if (MessageChannel.getEffectiveSide() != Side.SERVER) {
            return;
        }
        if (event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        UniqueItemData.loadData();
        PermissionData.loadData();
    }

    public static boolean ensureInventoryIdentifiers(EntityPlayer player, IInventory inventory, ItemStack stackToOpen, int stackToOpenIn, ArrayList<String> dataNeeded) {
        if (inventory == null) {
            return false;
        }
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        String parentGuid = inventory instanceof UniqueItemInventory ? ((UniqueItemInventory)inventory).getIdentifier() : "none";
        ArrayList<Integer> slotsNeeded = new ArrayList<Integer>();
        int slotToOpen = -1;
        String idToOpen = UniqueItem.getIdentifier(stackToOpen);
        if (!stackToOpen.func_190926_b() && stackToOpen.func_77973_b() instanceof UniqueItem && !idToOpen.equals("none") && ((UniqueItem)stackToOpen.func_77973_b()).hasUniqueData() && !data.isSubscribed(idToOpen)) {
            dataNeeded.add(idToOpen);
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof UniqueItem) {
                if (!UniqueItem.hasIdentifier(stack) || data.isPermissionDeleted(player, UniqueItem.getIdentifier(stack))) {
                    slotsNeeded.add(i);
                    if (stackToOpen.func_190926_b() || !stackToOpen.equals(stack) || slotToOpen >= 0) continue;
                    slotToOpen = i;
                    continue;
                }
                String uuid = UniqueItem.getIdentifier(stack);
                if (uuid.equals(idToOpen)) {
                    slotToOpen = i;
                }
                if (!((UniqueItem)stack.func_77973_b()).hasUniqueData()) continue;
                if (!data.isSubscribed(uuid)) {
                    dataNeeded.add(uuid);
                }
                if (player.field_70170_p.field_72995_K || data.items.containsKey(uuid)) continue;
                UniqueItem.setIdentifier(player, stack, uuid);
                continue;
            }
            if (stack.func_190926_b() || stackToOpen.func_190926_b() || !stackToOpen.equals(stack) || slotToOpen >= 0) continue;
            slotToOpen = i;
        }
        if (slotsNeeded.size() < 1 && dataNeeded.size() < 1) {
            return true;
        }
        if (stackToOpen.func_190926_b()) {
            slotToOpen = -1;
        }
        if (player.field_70170_p.field_72995_K) {
            channel.sendToServer(new PacketHandler.InventoryIdRequest(parentGuid, slotsNeeded, dataNeeded, slotToOpen, stackToOpenIn));
        }
        return false;
    }

    public static void ensureInventorySubscribed(EntityPlayer player, IInventory inventory) {
        if (inventory == null || player.field_70170_p.field_72995_K) {
            return;
        }
        ArrayList<String> dataNeeded = new ArrayList<String>();
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof UniqueItem) || !UniqueItem.hasIdentifier(stack)) continue;
            if (((UniqueItem)stack.func_77973_b()).hasUniqueData()) {
                String uuid = UniqueItem.getIdentifier(stack);
                dataNeeded.add(uuid);
                if (data.items.containsKey(uuid)) continue;
                UniqueItem.setIdentifier(player, stack, uuid);
                continue;
            }
            if (!(stack.func_77973_b() instanceof QuantumBackpack)) continue;
            dataNeeded.add(QuantumBackpack.getInfo(stack));
        }
        ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
        for (String aDataNeeded : dataNeeded) {
            data.subscribePlayer(player, aDataNeeded, tags, false);
        }
        if (tags.size() < 1) {
            return;
        }
        channel.sendToPlayer(player, new PacketHandler.DataUpdate(tags));
    }

    public static String requestInventoryIdentifier(EntityPlayer player, IInventory inventory, int index) {
        ItemStack stack = inventory.func_70301_a(index);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof UniqueItem) {
            if (!UniqueItem.hasIdentifier(stack) || UniqueItemData.get(player.field_70170_p).isPermissionDeleted(player, UniqueItem.getIdentifier(stack))) {
                String uuid = UUID.randomUUID().toString();
                if (restrictBackpackCreation && stack.func_77973_b() instanceof Backpack) {
                    UniqueItemData data = UniqueItemData.get(player.field_70170_p);
                    String existingUuid = BackpackCommand.getPlayerUuid(data, player.func_70005_c_());
                    if (existingUuid == null) {
                        existingUuid = uuid;
                        data.setPlayerId(player.func_70005_c_(), uuid);
                    }
                    uuid = existingUuid;
                }
                UniqueItem.setIdentifier(player, stack, uuid);
            } else {
                String uuid = UniqueItem.getIdentifier(stack);
                if (((UniqueItem)stack.func_77973_b()).hasUniqueData() && !UniqueItemData.get((World)player.field_70170_p).items.containsKey(uuid)) {
                    UniqueItem.setIdentifier(player, stack, uuid);
                }
            }
            return UniqueItem.getIdentifier(stack);
        }
        return null;
    }

    public static void setInventoryIdentifier(EntityPlayer player, IInventory inventory, int index, String id) {
        ItemStack stack = inventory.func_70301_a(index);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof UniqueItem) {
            UniqueItem.setIdentifier(player, stack, id);
        }
    }

    static {
        fileVersion = "3.4";
        shiftOpensInSameStack = false;
        _disableItemRestorers = false;
        _disableCraftingGui = false;
        _disableChestOpening = false;
        _allEditorsRequireOpPermission = false;
        restrictBackpackCreation = false;
        drdFilenames = new ArrayList();
        channel = new MessageChannel();
        _preventQuantumChestCreation = false;
        _disableBackpackBlocks = false;
        _requirePermissionToDestroyQuantumChest = true;
        allowBackpackCommand = false;
        disableAutoLoader = false;
        animatedQuantumBackpacks = true;
        displayPlacedBackpackNames = true;
        _disableNesting = false;
        disableInventoryOpening = false;
        reverseBackpackSearch = false;
        hideUniqueItemIds = true;
        disableRecipeEditor = false;
        allowOpFunctionsInSinglePlayer = true;
        backpackRendererEnabled = true;
        backpackRendererTickCount = 7;
    }
}

