/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks.blocks;

import brad16840.backpacks.InventoryScanner;
import brad16840.backpacks.PacketHandler;
import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.Common;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BackpackBlockTileEntity
extends TileEntity
implements ISidedInventory,
ITickable {
    public ItemStack backpack;
    public boolean hasBackpackDropped = false;
    public boolean hasChanged = false;
    public boolean allowFrontPipe = false;
    public String inactivePipeEntity = null;
    public int backpackType = -1;
    private static final int[] slots_none = new int[0];
    public HashMap<Integer, Integer> delays = new HashMap();
    private BackpackBlockItemHandler topItemHandler = new BackpackBlockItemHandler(HandlerSide.Top);
    private BackpackBlockItemHandler bottomItemHandler = new BackpackBlockItemHandler(HandlerSide.Bottom);
    private BackpackBlockItemHandler frontItemHandler = new BackpackBlockItemHandler(HandlerSide.Front);
    private BackpackBlockItemHandler backItemHandler = new BackpackBlockItemHandler(HandlerSide.Back);

    public BackpackBlockTileEntity() {
        this.backpack = ItemStack.field_190927_a;
    }

    public ItemStack getBackpack() {
        return this.backpack;
    }

    private String getBackpackId(World world) {
        if (this.backpack.func_190926_b()) {
            return "none";
        }
        if (this.backpack.func_77973_b() == Common.backpack) {
            return UniqueItem.getIdentifier(this.backpack);
        }
        if (this.backpack.func_77973_b() == Common.quantumBackpack) {
            QuantumChestTileEntity.VirtualQuantumChest chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(world, QuantumBackpack.getInfo(this.backpack));
            if (chest == null) {
                return "none";
            }
            return chest.getBackpackId(world, "[world]");
        }
        return "none";
    }

    private UniqueItemInventory getBackpackInventory(World world) {
        String uuid = this.getBackpackId(world);
        if (uuid == null || uuid.equals("none")) {
            return null;
        }
        return UniqueItemInventory.getInventory(null, world, uuid);
    }

    public int func_70302_i_() {
        UniqueItemInventory inventory = this.getBackpackInventory(this.field_145850_b);
        return inventory == null ? 0 : inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        UniqueItemInventory inventory = this.getBackpackInventory(this.field_145850_b);
        return inventory == null ? null : inventory.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        UniqueItemInventory inventory = this.getBackpackInventory(this.field_145850_b);
        if (inventory == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = inventory.func_70298_a(index, count);
        inventory.saveInventory();
        this.hasChanged = true;
        return result;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        UniqueItemInventory inventory = this.getBackpackInventory(this.field_145850_b);
        if (inventory == null) {
            return;
        }
        inventory.func_70299_a(index, stack);
        inventory.saveInventory();
        this.hasChanged = true;
    }

    public void func_70296_d() {
        UniqueItemInventory inventory = this.getBackpackInventory(this.field_145850_b);
        if (inventory == null) {
            return;
        }
        inventory.saveInventory();
        this.hasChanged = true;
        super.func_70296_d();
    }

    public String func_70005_c_() {
        return "backpack_block";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.allowFrontPipe = false;
        if (nbt.func_74764_b("backpack")) {
            this.backpack = UniqueItem.loadItemStackFromNBT(nbt.func_74775_l("backpack"));
            if (nbt.func_150297_b("allowFrontPipe", 99)) {
                this.allowFrontPipe = nbt.func_74767_n("allowFrontPipe");
            }
        } else {
            this.backpack = ItemStack.field_190927_a;
        }
        this.hasBackpackDropped = nbt.func_74767_n("hasBackpackDropped");
        this.updateBackpackType();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (!this.backpack.func_190926_b()) {
            nbt.func_74782_a("backpack", (NBTBase)UniqueItem.writeItemStackToNBT(this.backpack, null));
            nbt.func_74757_a("allowFrontPipe", this.allowFrontPipe);
        }
        nbt.func_74757_a("hasBackpackDropped", this.hasBackpackDropped);
        return nbt;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145836_u() {
        super.func_145836_u();
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean fillSlot(UniqueItemData data, UniqueItemInventory inventory, NBTTagCompound accepts, UniqueItemInventory inv, NBTTagCompound replenishes, int slot, HashSet<String> visited) {
        if (inv == null) {
            return false;
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            NBTTagCompound collect;
            QuantumChestTileEntity.VirtualQuantumChest chest;
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (replenishes != null && InventoryScanner.backpackAccepts(replenishes, stack) && InventoryScanner.backpackAccepts(accepts, stack)) {
                inventory.func_70299_a(slot, stack);
                inv.func_70299_a(i, ItemStack.field_190927_a);
                return true;
            }
            String uuid = null;
            if (stack.func_77973_b() == Common.backpack) {
                uuid = UniqueItem.getIdentifier(stack);
            } else if (stack.func_77973_b() == Common.quantumBackpack && (chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(this.field_145850_b, QuantumBackpack.getInfo(stack))) != null) {
                uuid = chest.getBackpackId(this.field_145850_b, "[world]");
            }
            if (uuid == null || uuid.equals("none") || visited.contains(uuid)) continue;
            visited.add(uuid);
            UniqueItemInventory inv2 = UniqueItemInventory.getInventory(null, this.field_145850_b, uuid);
            NBTTagCompound tag = data.getItemData(uuid, false);
            if (tag == null || !tag.func_150297_b("replenish", 10) || (collect = tag.func_74775_l("collect")).func_74767_n("collect-paused") || !this.fillSlot(data, inventory, accepts, inv2, tag = tag.func_74775_l("replenish"), slot, visited)) continue;
            inv2.saveInventory();
            return true;
        }
        return false;
    }

    public boolean emptySlot(UniqueItemData data, UniqueItemInventory inventory, UniqueItemInventory inv, NBTTagCompound accepts, int slot, HashSet<String> visited, ItemStack item) {
        int i;
        if (inv == null) {
            return false;
        }
        for (i = 0; i < inv.func_70302_i_(); ++i) {
            QuantumChestTileEntity.VirtualQuantumChest chest;
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            String uuid = null;
            if (stack.func_77973_b() == Common.backpack) {
                uuid = UniqueItem.getIdentifier(stack);
            } else if (stack.func_77973_b() == Common.quantumBackpack && (chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(this.field_145850_b, QuantumBackpack.getInfo(stack))) != null) {
                uuid = chest.getBackpackId(this.field_145850_b, "[world]");
            }
            if (uuid == null || uuid.equals("none") || visited.contains(uuid)) continue;
            visited.add(uuid);
            UniqueItemInventory inv2 = UniqueItemInventory.getInventory(null, this.field_145850_b, uuid);
            NBTTagCompound tag = data.getItemData(uuid, false);
            if (tag == null || !tag.func_150297_b("collect", 10) || !this.emptySlot(data, inventory, inv2, tag = tag.func_74775_l("collect"), slot, visited, item)) continue;
            inv2.saveInventory();
        }
        if (item.func_190916_E() == 0) {
            return false;
        }
        if (InventoryScanner.backpackAccepts(accepts, item)) {
            do {
                i = item.func_190916_E();
                item.func_190920_e(InventoryScanner.storePartialItemStack(inv, item, true, true));
            } while (item.func_190916_E() > 0 && item.func_190916_E() < i);
            return true;
        }
        return false;
    }

    public boolean func_191420_l() {
        UniqueItemInventory inventory = this.getBackpackInventory(this.field_145850_b);
        return inventory == null ? true : inventory.func_191420_l();
    }

    public void func_73660_a() {
        if (this.hasChanged) {
            this.hasChanged = false;
            UniqueItemData data = UniqueItemData.get(this.field_145850_b);
            UniqueItemInventory inventory = this.getBackpackInventory(this.field_145850_b);
            if (inventory == null) {
                return;
            }
            NBTTagCompound tag = data.getItemData(this.getBackpackId(this.field_145850_b), false);
            if (tag == null) {
                return;
            }
            if (tag.func_150297_b("replenish", 10)) {
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack stack = inventory.func_70301_a(i);
                    if (stack.func_190926_b()) continue;
                    this.emptySlot(data, inventory, inventory, null, i, new HashSet<String>(), stack);
                }
                inventory.saveInventory();
            }
            if (tag.func_150297_b("collect", 10)) {
                NBTTagCompound accepts = tag.func_74775_l("collect");
                for (int i = 0; i < inventory.func_70302_i_() && (!inventory.func_70301_a(i).func_190926_b() || this.fillSlot(data, inventory, accepts, inventory, null, i, new HashSet<String>())); ++i) {
                }
                inventory.saveInventory();
            }
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        UniqueItemInventory inventory = this.getBackpackInventory(this.field_145850_b);
        return inventory == null ? false : inventory.func_94041_b(index, stack);
    }

    private int orientateSide(EnumFacing eside) {
        if (eside == null) {
            return -1;
        }
        int side = eside.func_176745_a();
        int i = this.func_145832_p();
        if (i == 4 || i == 5) {
            if (side > 3) {
                side -= 2;
            } else if (side > 1) {
                side += 2;
            }
        }
        if (i == 3 || i == 5) {
            if (side > 3) {
                side = 4 + (5 - side);
            } else if (side > 1) {
                side = 2 + (3 - side);
            }
        }
        return side;
    }

    private HandlerSide getHandlerForSide(EnumFacing eside) {
        int side = this.orientateSide(eside);
        if (side == 0) {
            return HandlerSide.Bottom;
        }
        if (side == 1) {
            return HandlerSide.Top;
        }
        if (side == 2) {
            return HandlerSide.Front;
        }
        if (side == 3) {
            return HandlerSide.Back;
        }
        return HandlerSide.None;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    private int[] allSlots(UniqueItemInventory inventory) {
        int[] slots = new int[inventory.func_70302_i_()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public int[] func_180463_a(EnumFacing eside) {
        int side = this.orientateSide(eside);
        if (side != 3 && side != 0 && side != 1 && side != 2) {
            return slots_none;
        }
        UniqueItemInventory inventory = this.getBackpackInventory(this.field_145850_b);
        return inventory == null ? slots_none : this.allSlots(inventory);
    }

    public boolean canAddItem(int slot, ItemStack stack, HandlerSide side) {
        if (side != HandlerSide.Back && side != HandlerSide.Top) {
            return false;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        UniqueItemInventory inventory = this.getBackpackInventory(this.field_145850_b);
        if (inventory == null || slot >= inventory.func_70302_i_()) {
            return false;
        }
        if (Common.disableNesting && !stack.func_190926_b() && (stack.func_77973_b() instanceof Backpack || stack.func_77973_b() instanceof QuantumBackpack)) {
            return false;
        }
        UniqueItemData data = UniqueItemData.get(this.field_145850_b);
        if (!InventoryScanner.backpackCanAccept(data.getItemData(this.getBackpackId(this.field_145850_b), false), stack)) {
            return false;
        }
        if (side == HandlerSide.Top) {
            NBTTagCompound tag = data.getItemData(this.getBackpackId(this.field_145850_b), false);
            if (tag == null || !tag.func_150297_b("collect", 10)) {
                return false;
            }
            if (!InventoryScanner.backpackAccepts(tag.func_74775_l("collect"), stack)) {
                return false;
            }
        }
        this.delays.put(slot, 4);
        return true;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing eside) {
        return this.canAddItem(slot, stack, this.getHandlerForSide(eside));
    }

    public boolean canTakeItem(int slot, ItemStack stack, HandlerSide side) {
        if (side != HandlerSide.Bottom && side != HandlerSide.Front) {
            return false;
        }
        String uuid = this.getBackpackId(this.field_145850_b);
        if (uuid == null || uuid.equals("none")) {
            return false;
        }
        Integer delay = this.delays.get(slot);
        if (delay != null && delay > 0) {
            this.delays.put(slot, delay - 1);
            return false;
        }
        UniqueItemInventory inventory = UniqueItemInventory.getInventory(null, this.field_145850_b, uuid);
        if (inventory == null || slot >= inventory.func_70302_i_()) {
            return false;
        }
        NBTTagCompound tag = UniqueItemData.get(this.field_145850_b).getItemData(uuid, false);
        if (tag != null && side == HandlerSide.Front) {
            if (this.allowFrontPipe) {
                return stack != null;
            }
            this.inactivePipeEntity = this.getFrontPipeEntityName();
            return false;
        }
        if (tag == null || !tag.func_150297_b("replenish", 10)) {
            return false;
        }
        NBTTagCompound collect = tag.func_74775_l("collect");
        if (collect.func_74767_n("collect-paused")) {
            return false;
        }
        tag = tag.func_74775_l("replenish");
        return InventoryScanner.backpackAccepts(tag, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing eside) {
        return this.canTakeItem(slot, stack, this.getHandlerForSide(eside));
    }

    public String getFrontPipeEntityName() {
        try {
            int x = this.field_174879_c.func_177958_n();
            int z = this.field_174879_c.func_177952_p();
            int i = this.func_145832_p();
            if (i == 2) {
                --z;
            } else if (i == 5) {
                ++x;
            } else if (i == 3) {
                ++z;
            } else if (i == 4) {
                --x;
            } else {
                return null;
            }
            TileEntity entity = this.field_145850_b.func_175625_s(new BlockPos(x, this.field_174879_c.func_177956_o(), z));
            if (entity != null) {
                return entity.getClass().getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_189515_b(nbttagcompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 90, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.func_189515_b(tag);
        return tag;
    }

    public void updateBackpackType() {
        this.backpackType = this.backpack.func_190926_b() ? -1 : (this.backpack.func_77973_b() == Common.quantumBackpack ? (this.backpack.func_77960_j() == 0 ? 16 : (this.backpack.func_77960_j() - 1) % 16) : (this.backpack.func_77973_b() == Common.backpack ? Math.min(this.backpack.func_77960_j(), 15) : -1));
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            NBTTagCompound tag = new NBTTagCompound();
            this.func_189515_b(tag);
            Common.channel.sendToAll(new PacketHandler.UpdateClientTileEntity(new brad16840.common.BlockPos(this.field_174879_c), tag));
        }
    }

    public int func_174887_a_(int p_getField_1_) {
        return 0;
    }

    public void func_174885_b(int p_setField_1_, int p_setField_2_) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentTranslation(this.func_70005_c_(), new Object[0]) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            HandlerSide side = this.getHandlerForSide(facing);
            return side != HandlerSide.None;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            HandlerSide side = this.getHandlerForSide(facing);
            if (side == HandlerSide.Top) {
                return (T)this.topItemHandler;
            }
            if (side == HandlerSide.Bottom) {
                return (T)this.bottomItemHandler;
            }
            if (side == HandlerSide.Front) {
                return (T)this.frontItemHandler;
            }
            if (side == HandlerSide.Back) {
                return (T)this.backItemHandler;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public class BackpackBlockItemHandler
    implements IItemHandler {
        private HandlerSide side;

        BackpackBlockItemHandler(HandlerSide side) {
            this.side = side;
        }

        public int getSlots() {
            UniqueItemInventory inventory = BackpackBlockTileEntity.this.getBackpackInventory(BackpackBlockTileEntity.this.field_145850_b);
            return inventory == null ? 0 : inventory.func_70302_i_();
        }

        public ItemStack getStackInSlot(int slot) {
            return BackpackBlockTileEntity.this.func_70301_a(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack == null || stack.func_190926_b() || !BackpackBlockTileEntity.this.canAddItem(slot, stack, this.side)) {
                return stack;
            }
            UniqueItemInventory inventory = BackpackBlockTileEntity.this.getBackpackInventory(BackpackBlockTileEntity.this.field_145850_b);
            if (inventory == null) {
                return stack;
            }
            ItemStack result = InventoryScanner.storePartialItemStackInSlot(inventory, slot, stack, simulate);
            if (!simulate && (result == null || result.func_190926_b() || result.func_190916_E() < stack.func_190916_E())) {
                inventory.saveInventory();
                BackpackBlockTileEntity.this.hasChanged = true;
            }
            return result;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack = this.getStackInSlot(slot);
            if (stack.func_190926_b() || !BackpackBlockTileEntity.this.canTakeItem(slot, stack, this.side)) {
                return ItemStack.field_190927_a;
            }
            int maxAmount = Math.min(Math.min(amount, stack.func_77976_d()), stack.func_190916_E());
            if (maxAmount < 1) {
                return ItemStack.field_190927_a;
            }
            if (simulate) {
                stack = stack.func_77946_l();
                stack.func_190920_e(maxAmount);
                return stack;
            }
            return BackpackBlockTileEntity.this.func_70298_a(slot, maxAmount);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    }

    private static enum HandlerSide {
        Top,
        Bottom,
        Front,
        Back,
        None;

    }
}

