/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks;

import brad16840.backpacks.PacketHandler;
import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.gui.StandaloneBackpackGui;
import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.BackpackCommand;
import brad16840.common.Common;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InventoryScanner {
    public static ItemStack getEmptyStack() {
        return ItemStack.field_190927_a;
    }

    public static boolean isEmpty(ItemStack stack) {
        return stack == null || stack.func_190926_b();
    }

    public static int stackSize(ItemStack stack) {
        return stack.func_190916_E();
    }

    public static void setStackSize(ItemStack stack, int amount) {
        stack.func_190920_e(amount);
    }

    public static void decreaseStackSize(ItemStack stack, int amount) {
        stack.func_190917_f(-amount);
    }

    public static void increaseStackSize(ItemStack stack, int amount) {
        stack.func_190917_f(amount);
    }

    public static int getMetadata(ItemStack stack) {
        return stack.func_77960_j();
    }

    public static boolean areItemStacksEquivalent(ItemStack stack, ItemStack target, boolean allowWildcardMetadata) {
        if (InventoryScanner.isEmpty(stack) || stack.func_77973_b() != target.func_77973_b()) {
            return false;
        }
        return allowWildcardMetadata || InventoryScanner.getMetadata(stack) == InventoryScanner.getMetadata(target);
    }

    public static boolean scanBackpack(EntityPlayer player, UniqueItemData data, String uuid, ScanFilter filter, HashSet<String> visited) {
        if (uuid == null || uuid.equals("none") || visited.contains(uuid) || !data.strictlyHasRequiredPermission(player.field_70170_p, player.func_70005_c_(), uuid, 2)) {
            return false;
        }
        visited.add(uuid);
        UniqueItemInventory inv = UniqueItemInventory.getInventory(null, player.field_70170_p, uuid);
        if (inv == null) {
            return false;
        }
        NBTTagCompound tag = data.getItemData(uuid, false);
        if (tag != null && !(filter instanceof PickItemFilter)) {
            NBTTagCompound collect = tag.func_74775_l("collect");
            if (collect.func_74767_n("autoload-paused")) {
                return false;
            }
            if (!filter.scanPausedBackpacks() && collect.func_74767_n("collect-paused")) {
                return false;
            }
        }
        if (InventoryScanner.scanInventory(player, data, inv, filter, visited)) {
            return true;
        }
        return filter.checkBackpack(inv, uuid, tag, player);
    }

    public static boolean scanInventory(EntityPlayer player, UniqueItemData data, IInventory inventory, ScanFilter filter, HashSet<String> visited) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (InventoryScanner.isEmpty(stack) || !(stack.func_77973_b() instanceof Backpack) && !(stack.func_77973_b() instanceof QuantumBackpack) || !InventoryScanner.scanBackpack(player, data, InventoryScanner.getUUID(player, stack), filter, visited)) continue;
            return true;
        }
        return false;
    }

    public static boolean scanPlayer(EntityPlayer player, UniqueItemData data, ScanFilter filter) {
        NBTTagCompound tag;
        HashSet<String> visited = new HashSet<String>();
        String boundBackpack = BackpackCommand.getPlayerUuid(data, player.func_70005_c_());
        if (boundBackpack != null && data.items.containsKey(boundBackpack) && (tag = data.getItemData(boundBackpack, false)) != null && tag.func_74767_n("isEquipped") && InventoryScanner.scanBackpack(player, data, boundBackpack, filter, visited)) {
            return true;
        }
        if (InventoryScanner.scanInventory(player, data, (IInventory)player.field_71071_by, filter, visited)) {
            return true;
        }
        return InventoryScanner.scanBackpack(player, data, boundBackpack, filter, visited);
    }

    public static String getUUID(EntityPlayer player, ItemStack stack) {
        QuantumChestTileEntity.VirtualQuantumChest chest;
        if (stack.func_77973_b() instanceof QuantumBackpack && (chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, QuantumBackpack.getInfo(stack))) != null && chest.canStrictlyUse(player.field_70170_p, player.func_70005_c_())) {
            return chest.getBackpackId(player.field_70170_p, player.func_70005_c_());
        }
        return UniqueItem.getIdentifier(stack);
    }

    public static boolean backpackCanAccept(NBTTagCompound tag, ItemStack stack) {
        if (tag == null) {
            return false;
        }
        if (InventoryScanner.isEmpty(stack) || !tag.func_150297_b("filtered", 99) || !tag.func_74767_n("filtered")) {
            return true;
        }
        if (!tag.func_150297_b("collect", 10)) {
            return false;
        }
        boolean inverse = (tag = tag.func_74775_l("collect")).func_150297_b("exclude", 99) && tag.func_74767_n("exclude");
        String desc = UniqueItem.getDescriptor(stack.func_77973_b()).replace(":", "+");
        boolean isSpecified = tag.func_74764_b(desc) || tag.func_74764_b(desc + "@" + InventoryScanner.getMetadata(stack));
        return isSpecified != inverse;
    }

    public static boolean backpackAccepts(NBTTagCompound tag, ItemStack stack) {
        if (tag == null || InventoryScanner.isEmpty(stack) || tag.func_74767_n("collect-paused")) {
            return false;
        }
        boolean inverse = tag.func_150297_b("exclude", 99) && tag.func_74767_n("exclude");
        String desc = UniqueItem.getDescriptor(stack.func_77973_b()).replace(":", "+");
        boolean isSpecified = tag.func_74764_b(desc) || tag.func_74764_b(desc + "@" + InventoryScanner.getMetadata(stack));
        return isSpecified != inverse;
    }

    public static void loadFromInventory(EntityPlayer player, IInventory inventory) {
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        int i = inventory.func_70302_i_() - 1;
        int min = 0;
        boolean hasStockBackpacks = false;
        if (inventory instanceof InventoryPlayer) {
            hasStockBackpacks = true;
            i = ((InventoryPlayer)inventory).field_70462_a.size() - 1;
            min = InventoryPlayer.func_70451_h();
        }
        while (i >= min) {
            block14: {
                ItemStack stack;
                block15: {
                    stack = inventory.func_70301_a(i);
                    if (InventoryScanner.isEmpty(stack) || stack.func_77973_b() instanceof Backpack || stack.func_77973_b() instanceof QuantumBackpack) break block14;
                    int stackLimit = Math.min(stack.func_77976_d(), inventory.func_70297_j_());
                    if (InventoryScanner.stackSize(stack) >= stackLimit) break block15;
                    for (int t = 0; t < i; ++t) {
                        ItemStack is = inventory.func_70301_a(t);
                        if (InventoryScanner.isEmpty(is) || is.func_77973_b() != stack.func_77973_b() || !is.func_77985_e() || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)stack) || is.func_77981_g() && InventoryScanner.getMetadata(is) != InventoryScanner.getMetadata(stack) || InventoryScanner.stackSize(is) >= stackLimit) continue;
                        int needed = stackLimit - InventoryScanner.stackSize(is);
                        if (InventoryScanner.stackSize(stack) > needed) {
                            InventoryScanner.increaseStackSize(is, needed);
                            InventoryScanner.decreaseStackSize(stack, needed);
                            continue;
                        }
                        InventoryScanner.increaseStackSize(is, InventoryScanner.stackSize(stack));
                        inventory.func_70299_a(i, InventoryScanner.getEmptyStack());
                        break;
                    }
                    if (InventoryScanner.isEmpty(stack = inventory.func_70301_a(i))) break block14;
                }
                int amountToCollect = InventoryScanner.stackSize(stack);
                if (hasStockBackpacks) {
                    WouldResupplyFilter wouldResupply = new WouldResupplyFilter(stack, inventory, true);
                    InventoryScanner.scanPlayer(player, data, wouldResupply);
                    amountToCollect = wouldResupply.getAmountToCollect();
                    hasStockBackpacks = wouldResupply.hasStockBackpacks;
                }
                if (amountToCollect != 0) {
                    if (amountToCollect >= InventoryScanner.stackSize(stack)) {
                        InventoryScanner.scanPlayer(player, data, new AutoCollectFilter(stack, true));
                        if (InventoryScanner.stackSize(stack) == 0) {
                            inventory.func_70299_a(i, InventoryScanner.getEmptyStack());
                        }
                    } else {
                        ItemStack remaining = stack.func_77946_l();
                        ItemStack split = remaining.func_77979_a(amountToCollect);
                        InventoryScanner.scanPlayer(player, data, new AutoCollectFilter(split, true));
                        if (InventoryScanner.stackSize(split) != amountToCollect && InventoryScanner.stackSize(split) > 0) {
                            InventoryScanner.increaseStackSize(remaining, InventoryScanner.stackSize(split));
                        }
                        inventory.func_70299_a(i, remaining);
                    }
                }
            }
            --i;
        }
        if (hasStockBackpacks) {
            InventoryScanner.scanPlayer(player, data, new ResupplyInventoryFilter((InventoryPlayer)inventory));
        }
        InventoryScanner.refreshStandaloneBackpackGui(player, false);
    }

    @SideOnly(value=Side.CLIENT)
    private static void __refreshStandaloneBackpackGui() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && mc.field_71462_r instanceof StandaloneBackpackGui) {
            ((StandaloneBackpackGui)mc.field_71462_r).updateBackpack();
        }
    }

    public static void refreshStandaloneBackpackGui(EntityPlayer player, boolean forceFromServer) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            InventoryScanner.__refreshStandaloneBackpackGui();
        } else if (forceFromServer) {
            Common.channel.sendToPlayer(player, new PacketHandler.RefreshStandaloneBackpackGui());
        }
    }

    @SubscribeEvent
    public void onPlayerPickup(EntityItemPickupEvent event) {
        if (Common.disableAutoLoader) {
            return;
        }
        try {
            ItemStack stack = event.getItem().func_92059_d();
            EntityPlayer player = event.getEntityPlayer();
            if (event.getItem().func_174874_s() || InventoryScanner.stackSize(stack) < 1 || player instanceof FakePlayer) {
                return;
            }
            UniqueItemData data = UniqueItemData.get(player.field_70170_p);
            WouldResupplyFilter wouldResupply = new WouldResupplyFilter(stack, (IInventory)player.field_71071_by, false);
            InventoryScanner.scanPlayer(player, data, wouldResupply);
            int amountToCollect = wouldResupply.getAmountToCollect();
            if (amountToCollect == 0) {
                return;
            }
            if (amountToCollect >= InventoryScanner.stackSize(stack)) {
                InventoryScanner.scanPlayer(player, data, new AutoCollectFilter(stack, false));
            } else {
                ItemStack remaining = stack.func_77946_l();
                ItemStack split = remaining.func_77979_a(amountToCollect);
                InventoryScanner.scanPlayer(player, data, new AutoCollectFilter(split, false));
                if (InventoryScanner.stackSize(split) != amountToCollect) {
                    if (InventoryScanner.stackSize(split) > 0) {
                        InventoryScanner.increaseStackSize(remaining, InventoryScanner.stackSize(split));
                    }
                    InventoryScanner.increaseStackSize(stack, InventoryScanner.stackSize(remaining));
                }
            }
            if (InventoryScanner.stackSize(stack) == 0) {
                event.setResult(Event.Result.ALLOW);
            }
            InventoryScanner.refreshStandaloneBackpackGui(player, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onPlayerBreak(PlayerDestroyItemEvent event) {
        if (Common.disableAutoLoader) {
            return;
        }
        try {
            ItemStack stack = event.getOriginal();
            EntityPlayer player = event.getEntityPlayer();
            if (player instanceof FakePlayer || player.field_70170_p.field_72995_K) {
                return;
            }
            EnumHand hand = event.getHand();
            if (hand == null) {
                hand = EnumHand.MAIN_HAND;
            }
            UniqueItemData data = UniqueItemData.get(player.field_70170_p);
            if (!InventoryScanner.isEmpty(player.func_184586_b(hand)) && InventoryScanner.stackSize(player.func_184586_b(hand)) == 0) {
                player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, InventoryScanner.getEmptyStack());
            }
            try {
                player.field_71069_bz.func_75142_b();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!InventoryScanner.isEmpty(player.func_184586_b(hand))) {
                return;
            }
            InventoryScanner.scanPlayer(player, data, new AutoResupplyFilter(stack, hand));
            InventoryScanner.refreshStandaloneBackpackGui(player, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean addItemStackToInventory(UniqueItemInventory inventory, ItemStack stack, boolean canFillEmptySlots, boolean autoCollectAll) {
        if (InventoryScanner.isEmpty(stack) || InventoryScanner.stackSize(stack) == 0 || stack.func_77973_b() == null) {
            return false;
        }
        if (!stack.func_77951_h()) {
            int i;
            int originalStackSize = InventoryScanner.stackSize(stack);
            do {
                i = InventoryScanner.stackSize(stack);
                InventoryScanner.setStackSize(stack, InventoryScanner.storePartialItemStack(inventory, stack, canFillEmptySlots, autoCollectAll));
            } while (InventoryScanner.stackSize(stack) > 0 && InventoryScanner.stackSize(stack) < i);
            return InventoryScanner.stackSize(stack) < originalStackSize;
        }
        int i = InventoryScanner.getFirstEmptyStack(inventory);
        if (i < 0 || !canFillEmptySlots) {
            return false;
        }
        inventory.func_70299_a(i, stack.func_77946_l());
        InventoryScanner.setStackSize(stack, 0);
        return true;
    }

    public static boolean canReplenishItem(EntityPlayer player, UniqueItemInventory inventory, String id, int metadata, EnumHand hand) {
        if (!InventoryScanner.isEmpty(player.func_184586_b(hand))) {
            return false;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (InventoryScanner.isEmpty(stack) || !UniqueItem.getDescriptor(stack.func_77973_b()).equals(id) || metadata != Short.MAX_VALUE && metadata != InventoryScanner.getMetadata(stack)) continue;
            player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, stack);
            inventory.func_70299_a(i, InventoryScanner.getEmptyStack());
            try {
                player.field_71069_bz.func_75142_b();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public static int getFirstEmptyStack(UniqueItemInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!InventoryScanner.isEmpty(inventory.func_70301_a(i))) continue;
            return i;
        }
        return -1;
    }

    public static int storePartialItemStack(UniqueItemInventory inventory, ItemStack stack, boolean canFillEmptySlots, boolean collectExistingItems) {
        int spacesRemaining = InventoryScanner.stackSize(stack);
        int slot = -1;
        if (stack.func_77976_d() == 1) {
            slot = InventoryScanner.getFirstEmptyStack(inventory);
            if (slot < 0 || !canFillEmptySlots) {
                return spacesRemaining;
            }
            if (InventoryScanner.isEmpty(inventory.func_70301_a(slot))) {
                inventory.func_70299_a(slot, stack.func_77946_l());
            }
            return 0;
        }
        int stackLimit = Math.min(stack.func_77976_d(), inventory.func_70297_j_());
        boolean itemExists = false;
        for (int t = 0; t < inventory.func_70302_i_(); ++t) {
            ItemStack is = inventory.func_70301_a(t);
            if (InventoryScanner.isEmpty(is) || is.func_77973_b() != stack.func_77973_b() || !is.func_77985_e() || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)stack) || is.func_77981_g() && InventoryScanner.getMetadata(is) != InventoryScanner.getMetadata(stack)) continue;
            itemExists = true;
            if (InventoryScanner.stackSize(is) >= stackLimit) continue;
            slot = t;
            break;
        }
        if (slot < 0 && (canFillEmptySlots || collectExistingItems && itemExists)) {
            slot = InventoryScanner.getFirstEmptyStack(inventory);
        }
        if (slot < 0) {
            return spacesRemaining;
        }
        ItemStack existingStack = inventory.func_70301_a(slot);
        int spacesAvailable = Math.min(spacesRemaining, stackLimit - (InventoryScanner.isEmpty(existingStack) ? 0 : InventoryScanner.stackSize(existingStack)));
        if (spacesAvailable > 0) {
            spacesRemaining -= spacesAvailable;
            if (!InventoryScanner.isEmpty(existingStack)) {
                InventoryScanner.increaseStackSize(existingStack, spacesAvailable);
            } else {
                ItemStack temp = stack.func_77946_l();
                InventoryScanner.setStackSize(temp, spacesAvailable);
                inventory.func_70299_a(slot, temp);
            }
        }
        return spacesRemaining;
    }

    public static boolean areItemStacksEquivalent(ItemStack stack, ItemStack target) {
        if (stack == null && target == null) {
            return true;
        }
        if (stack == null || target == null) {
            return false;
        }
        if (stack.func_190926_b() && target.func_190926_b()) {
            return true;
        }
        if (stack.func_190926_b() || target.func_190926_b() || stack.func_77973_b() != target.func_77973_b()) {
            return false;
        }
        return (!stack.func_77981_g() || stack.func_77960_j() == target.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)target);
    }

    public static ItemStack storePartialItemStackInSlot(UniqueItemInventory inventory, int slot, ItemStack stack, boolean simulate) {
        int spacesRemaining;
        int spacesAvailable;
        if (slot < 0 || slot >= inventory.func_70302_i_() || stack.func_77976_d() == 1) {
            return stack;
        }
        int stackLimit = Math.min(stack.func_77976_d(), inventory.func_70297_j_());
        ItemStack existingStack = inventory.func_70301_a(slot);
        if (!existingStack.func_190926_b()) {
            if (existingStack.func_77973_b() != stack.func_77973_b() || !existingStack.func_77985_e()) {
                return stack;
            }
            if (!ItemStack.func_77970_a((ItemStack)existingStack, (ItemStack)stack) || existingStack.func_77981_g() && existingStack.func_77960_j() != stack.func_77960_j()) {
                return stack;
            }
        }
        if ((spacesAvailable = Math.min(spacesRemaining = stack.func_190916_E(), stackLimit - (existingStack.func_190926_b() ? 0 : existingStack.func_190916_E()))) < 1) {
            return stack;
        }
        spacesRemaining -= spacesAvailable;
        if (!simulate) {
            if (!existingStack.func_190926_b()) {
                existingStack.func_190917_f(spacesAvailable);
            } else {
                ItemStack temp = stack.func_77946_l();
                temp.func_190920_e(spacesAvailable);
                inventory.func_70299_a(slot, temp);
            }
        }
        if (spacesRemaining < 1) {
            return ItemStack.field_190927_a;
        }
        stack = stack.func_77946_l();
        stack.func_190920_e(spacesRemaining);
        return stack;
    }

    public static class PickItemFilter
    implements ScanFilter {
        private ItemStack target;
        private boolean wildcardMetadata;
        public int resultSlot;

        public PickItemFilter(ItemStack target, boolean wildcardMetadata) {
            this.target = target;
            this.wildcardMetadata = wildcardMetadata;
            this.resultSlot = -1;
        }

        @Override
        public boolean scanPausedBackpacks() {
            return true;
        }

        public static int getAppropriateHotbarSlot(EntityPlayer player) {
            int currentSlot = player.field_71071_by.field_70461_c;
            for (int i = 0; i < 27; ++i) {
                int slot = (currentSlot + i) % 9;
                ItemStack stack = player.field_71071_by.func_70301_a(slot);
                if (!InventoryScanner.isEmpty(stack) && (i < 9 || stack.func_77973_b() instanceof Backpack || stack.func_77973_b() instanceof QuantumBackpack || i < 18 && stack.func_77948_v())) continue;
                return slot;
            }
            return -1;
        }

        @Override
        public boolean checkBackpack(UniqueItemInventory inventory, String uuid, NBTTagCompound tag, EntityPlayer player) {
            if (InventoryScanner.isEmpty(this.target)) {
                return true;
            }
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                int emptySlot;
                ItemStack stack = inventory.func_70301_a(i);
                if (!InventoryScanner.areItemStacksEquivalent(stack, this.target, this.wildcardMetadata)) continue;
                int targetSlot = PickItemFilter.getAppropriateHotbarSlot(player);
                if (targetSlot < 0) {
                    return false;
                }
                ItemStack existingStack = player.field_71071_by.func_70301_a(targetSlot);
                if (!InventoryScanner.isEmpty(existingStack) && (emptySlot = player.field_71071_by.func_70447_i()) >= 0) {
                    ItemStack temp = player.field_71071_by.func_70301_a(emptySlot);
                    player.field_71071_by.func_70299_a(emptySlot, existingStack);
                    existingStack = temp;
                }
                player.field_71071_by.func_70299_a(targetSlot, stack);
                inventory.func_70299_a(i, existingStack);
                this.resultSlot = targetSlot;
                try {
                    player.field_71069_bz.func_75142_b();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                inventory.saveInventory();
                return true;
            }
            return false;
        }
    }

    public static class AutoResupplyFilter
    implements ScanFilter {
        private ItemStack target;
        private EnumHand hand;

        public AutoResupplyFilter(ItemStack target, EnumHand hand) {
            this.target = target;
            this.hand = hand;
        }

        @Override
        public boolean scanPausedBackpacks() {
            return true;
        }

        @Override
        public boolean checkBackpack(UniqueItemInventory inventory, String uuid, NBTTagCompound tag, EntityPlayer player) {
            boolean isSpecified;
            if (InventoryScanner.isEmpty(this.target) || tag == null || !tag.func_150297_b("replenish", 10) || !InventoryScanner.isEmpty(player.func_184586_b(this.hand))) {
                return false;
            }
            boolean inverse = (tag = tag.func_74775_l("replenish")).func_150297_b("exclude", 99) && tag.func_74767_n("exclude");
            String id = UniqueItem.getDescriptor(this.target.func_77973_b());
            String desc = id.replace(":", "+");
            boolean bl = isSpecified = tag.func_74764_b(desc) || tag.func_74764_b(desc + "@" + InventoryScanner.getMetadata(this.target));
            if (isSpecified == inverse) {
                return false;
            }
            if (InventoryScanner.canReplenishItem(player, inventory, id, InventoryScanner.getMetadata(this.target), this.hand)) {
                inventory.saveInventory();
                return true;
            }
            if (tag.func_74764_b(desc) != inverse && InventoryScanner.canReplenishItem(player, inventory, id, Short.MAX_VALUE, this.hand)) {
                inventory.saveInventory();
                return true;
            }
            return false;
        }
    }

    public static class ResupplyInventoryFilter
    implements ScanFilter {
        private InventoryPlayer inventory;

        public ResupplyInventoryFilter(InventoryPlayer inventory) {
            this.inventory = inventory;
        }

        @Override
        public boolean scanPausedBackpacks() {
            return true;
        }

        private int stockItemInInventory(ItemStack stack, int stackLimit) {
            ItemStack is;
            int i;
            int freeSlot = -1;
            int existingSlot = -1;
            int existingCount = 0;
            for (int i2 = 0; i2 < this.inventory.func_70302_i_(); ++i2) {
                ItemStack is2 = this.inventory.func_70301_a(i2);
                if (InventoryScanner.isEmpty(is2)) {
                    if (freeSlot >= 0) continue;
                    ResupplyInventoryFilter resupplyInventoryFilter = this;
                    if (i2 < resupplyInventoryFilter.inventory.func_70451_h()) continue;
                    freeSlot = i2;
                    continue;
                }
                if (is2.func_77973_b() != stack.func_77973_b() || !is2.func_77985_e() || !ItemStack.func_77970_a((ItemStack)is2, (ItemStack)stack) || is2.func_77981_g() && InventoryScanner.getMetadata(is2) != InventoryScanner.getMetadata(stack)) continue;
                if (existingSlot < 0) {
                    existingSlot = i2;
                }
                existingCount += InventoryScanner.stackSize(is2);
            }
            int actualLimit = Math.min(stack.func_77976_d(), this.inventory.func_70297_j_());
            if (stackLimit < 0) {
                stackLimit = actualLimit;
            }
            if (existingCount > stackLimit) {
                return -1;
            }
            int itemsNeeded = stackLimit - existingCount;
            int itemsRemaining = InventoryScanner.stackSize(stack);
            if (existingSlot >= 0) {
                for (i = existingSlot; i < this.inventory.func_70302_i_() && itemsNeeded != 0; ++i) {
                    is = this.inventory.func_70301_a(i);
                    if (InventoryScanner.isEmpty(is) || is.func_77973_b() != stack.func_77973_b() || !is.func_77985_e() || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)stack) || is.func_77981_g() && InventoryScanner.getMetadata(is) != InventoryScanner.getMetadata(stack)) continue;
                    int stackSize = InventoryScanner.stackSize(is);
                    int spaces = Math.min(actualLimit - stackSize, itemsNeeded);
                    if (itemsRemaining <= spaces) {
                        InventoryScanner.increaseStackSize(is, itemsRemaining);
                        return 0;
                    }
                    if (spaces <= 0) continue;
                    InventoryScanner.increaseStackSize(is, spaces);
                    itemsRemaining -= spaces;
                    itemsNeeded -= spaces;
                }
            } else if (freeSlot < 0) {
                return -1;
            }
            if (freeSlot >= 0) {
                for (i = freeSlot; i < this.inventory.func_70302_i_() && itemsNeeded != 0; ++i) {
                    is = this.inventory.func_70301_a(i);
                    if (!InventoryScanner.isEmpty(is)) continue;
                    InventoryScanner.setStackSize(stack, itemsRemaining);
                    int spaces = Math.min(actualLimit, itemsNeeded);
                    if (itemsRemaining <= spaces) {
                        this.inventory.func_70299_a(i, stack);
                        return 0;
                    }
                    if (spaces <= 0) continue;
                    itemsRemaining -= spaces;
                    itemsNeeded -= spaces;
                    this.inventory.func_70299_a(i, stack.func_77979_a(spaces));
                }
            }
            return itemsRemaining;
        }

        @Override
        public boolean checkBackpack(UniqueItemInventory inventory, String uuid, NBTTagCompound tag, EntityPlayer player) {
            if (inventory == null || tag == null || !tag.func_150297_b("replenish", 10)) {
                return false;
            }
            if (!tag.func_150297_b("stock", 99) || !tag.func_74767_n("stock")) {
                return false;
            }
            NBTTagCompound stockAmount = null;
            if (tag.func_150297_b("stockAmount", 10)) {
                stockAmount = tag.func_74775_l("stockAmount");
            }
            boolean inverse = (tag = tag.func_74775_l("replenish")).func_150297_b("exclude", 99) && tag.func_74767_n("exclude");
            boolean changesMade = false;
            for (int i = inventory.func_70302_i_() - 1; i >= 0; --i) {
                int itemsLeft;
                boolean isSpecified;
                ItemStack stack = inventory.func_70301_a(i);
                if (InventoryScanner.isEmpty(stack)) continue;
                String id = UniqueItem.getDescriptor(stack.func_77973_b());
                String desc = id.replace(":", "+");
                boolean bl = isSpecified = tag.func_74764_b(desc) || tag.func_74764_b(desc + "@" + InventoryScanner.getMetadata(stack));
                if (isSpecified == inverse) continue;
                int limit = -1;
                if (stockAmount != null) {
                    if (stockAmount.func_150297_b(desc + "@" + InventoryScanner.getMetadata(stack), 99)) {
                        limit = stockAmount.func_74762_e(desc + "@" + InventoryScanner.getMetadata(stack));
                    } else if (stockAmount.func_150297_b(desc, 99)) {
                        limit = stockAmount.func_74762_e(desc);
                    }
                }
                if ((itemsLeft = this.stockItemInInventory(stack.func_77946_l(), limit)) < 0) continue;
                changesMade = true;
                if (itemsLeft == 0) {
                    inventory.func_70299_a(i, InventoryScanner.getEmptyStack());
                    continue;
                }
                InventoryScanner.setStackSize(stack, itemsLeft);
            }
            if (changesMade) {
                inventory.saveInventory();
                try {
                    player.field_71069_bz.func_75142_b();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public static class WouldResupplyFilter
    implements ScanFilter {
        private ItemStack target;
        private IInventory inventory;
        private int totalInInventory;
        private int totalWildcardsInInventory;
        private int stackableAmount;
        private boolean wouldResupplyStack;
        private boolean wouldResupplyWildcardStack;
        private boolean hasStockBackpacks;

        public WouldResupplyFilter(ItemStack target, IInventory inventory, boolean targetIsInInventory) {
            this.target = target;
            this.inventory = inventory;
            this.totalInInventory = 0;
            this.totalWildcardsInInventory = 0;
            this.stackableAmount = -1;
            this.wouldResupplyStack = false;
            this.wouldResupplyWildcardStack = false;
            this.hasStockBackpacks = false;
            if (inventory != null && !InventoryScanner.isEmpty(target)) {
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack stack = inventory.func_70301_a(i);
                    if (InventoryScanner.areItemStacksEquivalent(stack, target, false)) {
                        this.totalInInventory += InventoryScanner.stackSize(stack);
                        this.totalWildcardsInInventory += InventoryScanner.stackSize(stack);
                        continue;
                    }
                    if (!InventoryScanner.areItemStacksEquivalent(stack, target, true)) continue;
                    this.totalWildcardsInInventory += InventoryScanner.stackSize(stack);
                }
                if (targetIsInInventory) {
                    this.totalInInventory -= InventoryScanner.stackSize(target);
                    this.totalWildcardsInInventory -= InventoryScanner.stackSize(target);
                }
            }
        }

        @Override
        public boolean scanPausedBackpacks() {
            return true;
        }

        public int getAmountToCollect() {
            if (this.stackableAmount < 0 && this.inventory != null && !InventoryScanner.isEmpty(this.target) && this.target.func_77985_e()) {
                this.stackableAmount = Math.min(this.target.func_77976_d(), this.inventory.func_70297_j_());
            }
            if (this.wouldResupplyStack) {
                if (this.totalInInventory >= this.stackableAmount) {
                    return InventoryScanner.stackSize(this.target);
                }
                return Math.max(0, this.totalInInventory + InventoryScanner.stackSize(this.target) - this.stackableAmount);
            }
            if (this.wouldResupplyWildcardStack) {
                if (this.totalWildcardsInInventory >= this.stackableAmount) {
                    if (this.totalInInventory >= this.stackableAmount) {
                        return InventoryScanner.stackSize(this.target);
                    }
                    if (this.totalInInventory > 0) {
                        return Math.max(0, this.totalInInventory + InventoryScanner.stackSize(this.target) - this.stackableAmount);
                    }
                    return InventoryScanner.stackSize(this.target);
                }
                return Math.max(0, this.totalInInventory + InventoryScanner.stackSize(this.target) - this.stackableAmount);
            }
            return InventoryScanner.stackSize(this.target);
        }

        @Override
        public boolean checkBackpack(UniqueItemInventory inventory, String uuid, NBTTagCompound tag, EntityPlayer player) {
            boolean isSpecified;
            if (InventoryScanner.isEmpty(this.target) || tag == null || !tag.func_150297_b("replenish", 10)) {
                return false;
            }
            if (!tag.func_150297_b("stock", 99) || !tag.func_74767_n("stock")) {
                return false;
            }
            NBTTagCompound stockAmount = null;
            if (tag.func_150297_b("stockAmount", 10)) {
                stockAmount = tag.func_74775_l("stockAmount");
            }
            this.hasStockBackpacks = true;
            boolean inverse = (tag = tag.func_74775_l("replenish")).func_150297_b("exclude", 99) && tag.func_74767_n("exclude");
            String id = UniqueItem.getDescriptor(this.target.func_77973_b());
            String desc = id.replace(":", "+");
            boolean bl = isSpecified = tag.func_74764_b(desc) || tag.func_74764_b(desc + "@" + InventoryScanner.getMetadata(this.target));
            if (isSpecified == inverse) {
                return false;
            }
            if (stockAmount != null) {
                if (stockAmount.func_150297_b(desc + "@" + InventoryScanner.getMetadata(this.target), 99)) {
                    this.stackableAmount = Math.max(stockAmount.func_74762_e(desc + "@" + InventoryScanner.getMetadata(this.target)), this.stackableAmount);
                } else if (stockAmount.func_150297_b(desc, 99)) {
                    this.stackableAmount = Math.max(stockAmount.func_74762_e(desc), this.stackableAmount);
                }
            }
            if (!tag.func_74764_b(desc + "@" + InventoryScanner.getMetadata(this.target))) {
                this.wouldResupplyWildcardStack = true;
            } else {
                this.wouldResupplyStack = true;
            }
            return this.wouldResupplyStack;
        }
    }

    public static class AutoCollectFilter
    implements ScanFilter {
        private ItemStack target;
        private boolean isManual;

        public AutoCollectFilter(ItemStack target, boolean isManual) {
            this.target = target;
            this.isManual = isManual;
        }

        @Override
        public boolean scanPausedBackpacks() {
            return this.isManual;
        }

        @Override
        public boolean checkBackpack(UniqueItemInventory inventory, String uuid, NBTTagCompound tag, EntityPlayer player) {
            boolean isSpecified;
            if (InventoryScanner.isEmpty(this.target) || tag == null || InventoryScanner.stackSize(this.target) < 1 || !tag.func_150297_b("collect", 10) && !tag.func_150297_b("fillExisting", 99) && !tag.func_150297_b("autoCollectAll", 99)) {
                return false;
            }
            boolean fillExistingStacks = tag.func_74767_n("fillExisting");
            boolean collectExistingStacks = fillExistingStacks && tag.func_74767_n("autoCollectAll");
            tag = tag.func_74775_l("collect");
            boolean inverse = tag.func_150297_b("exclude", 99) && tag.func_74767_n("exclude");
            String desc = UniqueItem.getDescriptor(this.target.func_77973_b()).replace(":", "+");
            boolean bl = isSpecified = tag.func_74764_b(desc) || tag.func_74764_b(desc + "@" + InventoryScanner.getMetadata(this.target));
            if (isSpecified != inverse) {
                if (InventoryScanner.addItemStackToInventory(inventory, this.target, true, true)) {
                    inventory.saveInventory();
                }
            } else if (fillExistingStacks && !isSpecified && InventoryScanner.addItemStackToInventory(inventory, this.target, false, collectExistingStacks)) {
                inventory.saveInventory();
            }
            return InventoryScanner.stackSize(this.target) < 1;
        }
    }

    public static interface ScanFilter {
        public boolean checkBackpack(UniqueItemInventory var1, String var2, NBTTagCompound var3, EntityPlayer var4);

        public boolean scanPausedBackpacks();
    }
}

