/*
 * Decompiled with CFR 0.152.
 */
package net.crazysnailboy.mods.enchantingtable.inventory;

import java.lang.reflect.Field;
import net.crazysnailboy.mods.enchantingtable.block.BlockEnderEnchantmentTable;
import net.crazysnailboy.mods.enchantingtable.capability.CapabilityHandler;
import net.crazysnailboy.mods.enchantingtable.capability.ILapisHandler;
import net.crazysnailboy.mods.enchantingtable.tileentity.TileEntityEnchantmentTable;
import net.crazysnailboy.mods.enchantingtable.util.ReflectionHelper;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ContainerEnchantment
extends net.minecraft.inventory.ContainerEnchantment {
    private static final Field worldField = ReflectionHelper.getDeclaredField(net.minecraft.inventory.ContainerEnchantment.class, "worldPointer", "field_75172_h");
    private static final Field positionField = ReflectionHelper.getDeclaredField(net.minecraft.inventory.ContainerEnchantment.class, "position", "field_178150_j");

    public ContainerEnchantment(InventoryPlayer playerInventory, World world, BlockPos pos) {
        super(playerInventory, world, pos);
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockEnderEnchantmentTable) {
            this.loadLapisFromPlayer(playerInventory.field_70458_d);
        } else {
            this.loadLapisFromTable(world, pos);
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        BlockPos pos;
        World world = (World)ReflectionHelper.getFieldValue(worldField, this);
        if (world.func_180495_p(pos = (BlockPos)ReflectionHelper.getFieldValue(positionField, this)).func_177230_c() instanceof BlockEnchantmentTable) {
            return player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
        }
        return false;
    }

    public void func_75134_a(EntityPlayer player) {
        ItemStack itemstack;
        World world = (World)ReflectionHelper.getFieldValue(worldField, this);
        BlockPos pos = (BlockPos)ReflectionHelper.getFieldValue(positionField, this);
        InventoryPlayer inventoryplayer = player.field_71071_by;
        if (!inventoryplayer.func_70445_o().func_190926_b()) {
            player.func_71019_a(inventoryplayer.func_70445_o(), false);
            inventoryplayer.func_70437_b(ItemStack.field_190927_a);
        }
        if (!world.field_72995_K && !(itemstack = this.field_75168_e.func_70304_b(0)).func_190926_b()) {
            player.func_71019_a(itemstack, false);
        }
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockEnderEnchantmentTable) {
            this.saveLapisToPlayer(player);
        } else {
            this.saveLapisToTable(world, pos);
        }
    }

    private void loadLapisFromTable(World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityEnchantmentTable) {
            TileEntityEnchantmentTable tileentityenchantmenttable = (TileEntityEnchantmentTable)tileentity;
            IItemHandler handler = (IItemHandler)tileentityenchantmenttable.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack lapisStack = handler.getStackInSlot(0);
            if (!lapisStack.func_190926_b()) {
                lapisStack = lapisStack.func_77946_l();
            }
            this.field_75168_e.func_70299_a(1, lapisStack);
            handler.insertItem(0, ItemStack.field_190927_a, false);
        }
    }

    private void loadLapisFromPlayer(EntityPlayer player) {
        boolean hasCapability = player.hasCapability(CapabilityHandler.LAPIS_HANDLER_CAPABILITY, null);
        if (hasCapability) {
            ILapisHandler handler = (ILapisHandler)player.getCapability(CapabilityHandler.LAPIS_HANDLER_CAPABILITY, null);
            ItemStack lapisStack = handler.getStackInSlot(0);
            if (!lapisStack.func_190926_b()) {
                lapisStack = lapisStack.func_77946_l();
            }
            this.field_75168_e.func_70299_a(1, lapisStack);
            handler.insertItem(0, ItemStack.field_190927_a, false);
        }
    }

    private void saveLapisToTable(World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityEnchantmentTable) {
            TileEntityEnchantmentTable tileentityenchantmenttable = (TileEntityEnchantmentTable)tileentity;
            IItemHandler handler = (IItemHandler)tileentityenchantmenttable.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            handler.extractItem(0, 64, false);
            ItemStack lapisStack = this.field_75168_e.func_70304_b(1);
            handler.insertItem(0, lapisStack, false);
        }
    }

    private void saveLapisToPlayer(EntityPlayer player) {
        boolean hasCapability = player.hasCapability(CapabilityHandler.LAPIS_HANDLER_CAPABILITY, null);
        if (hasCapability) {
            ILapisHandler handler = (ILapisHandler)player.getCapability(CapabilityHandler.LAPIS_HANDLER_CAPABILITY, null);
            handler.extractItem(0, 64, false);
            ItemStack lapisStack = this.field_75168_e.func_70304_b(1);
            handler.insertItem(0, lapisStack, false);
        }
    }
}

