/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.immersivecables.util;

import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="immersivecables")
public class ICConfiguration {
    public static Configuration config;
    public static final String CAT_AE2 = "Applied Energistics 2";
    public static boolean ae2Enabled;
    public static float ae2FluixRelayPowerDrain;
    public static float ae2DenseRelayPowerDrain;
    public static float ae2FluixTransformerPowerDrain;
    public static float ae2DenseTransformerPowerDrain;
    public static float ae2QuartzConnectorPowerDrain;
    public static int ae2FluixWireMaxLength;
    public static int ae2DenseWireMaxLength;
    public static int ae2QuartzWireMaxLength;
    public static final String CAT_RS = "Refined Storage";
    public static boolean rsEnabled;
    public static int rsRelayPowerDrain;
    public static int rsTransformerPowerDrain;
    public static int rsWireMaxLength;

    public static boolean isAe2Enabled() {
        return ae2Enabled && Loader.isModLoaded((String)"appliedenergistics2");
    }

    public static boolean isRsEnabled() {
        return rsEnabled && Loader.isModLoaded((String)"refinedstorage");
    }

    public static void initialize(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        ICConfiguration.synchronize();
    }

    public static void synchronize() {
        String desc = "Enables or disables the Applied Energistics 2 features. Will be ignored if AE2 is not available.";
        ae2Enabled = config.getBoolean("enabled", CAT_AE2, ae2Enabled, desc);
        config.getCategory(CAT_AE2).get("enabled").setRequiresMcRestart(true);
        desc = "The power drained from the AE system by a regular fluix relay.";
        ae2FluixRelayPowerDrain = config.getFloat("fluixRelayPowerDrain", CAT_AE2, ae2FluixRelayPowerDrain, 0.0f, Float.MAX_VALUE, desc);
        desc = "The power drained from the AE system by a dense fluix relay.";
        ae2DenseRelayPowerDrain = config.getFloat("denseRelayPowerDrain", CAT_AE2, ae2DenseRelayPowerDrain, 0.0f, Float.MAX_VALUE, desc);
        desc = "The power drained from the AE system by a regular fluix transformer.";
        ae2FluixTransformerPowerDrain = config.getFloat("fluixTransformerPowerDrain", CAT_AE2, ae2FluixTransformerPowerDrain, 0.0f, Float.MAX_VALUE, desc);
        desc = "The power drained from the AE system by a dense fluix transformer.";
        ae2DenseTransformerPowerDrain = config.getFloat("denseTransformerPowerDrain", CAT_AE2, ae2DenseTransformerPowerDrain, 0.0f, Float.MAX_VALUE, desc);
        desc = "The maximum length in blocks a regular fluix wire can be.";
        ae2FluixWireMaxLength = config.getInt("fluixWireMaxLength", CAT_AE2, ae2FluixWireMaxLength, 0, Integer.MAX_VALUE, desc);
        desc = "The maximum length in blocks a dense fluix wire can be.";
        ae2DenseWireMaxLength = config.getInt("denseWireMaxLength", CAT_AE2, ae2DenseWireMaxLength, 0, Integer.MAX_VALUE, desc);
        desc = "Enables or disables the Refined Storage features. Will be ignored if RS is not available.";
        rsEnabled = config.getBoolean("enabled", CAT_RS, rsEnabled, desc);
        config.getCategory(CAT_RS).get("enabled").setRequiresMcRestart(true);
        desc = "The power drained from the RS system by a refined relay.";
        rsRelayPowerDrain = config.getInt("relayPowerDrain", CAT_RS, rsRelayPowerDrain, 0, Integer.MAX_VALUE, desc);
        desc = "The power drained from the RS system by a refined transformer.";
        rsTransformerPowerDrain = config.getInt("transformerPowerDrain", CAT_RS, rsTransformerPowerDrain, 0, Integer.MAX_VALUE, desc);
        desc = "The maximum length in blocks a refined fiber wire can be.";
        rsWireMaxLength = config.getInt("wireMaxLength", CAT_RS, rsWireMaxLength, 0, Integer.MAX_VALUE, desc);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static ConfigCategory getCategory(String category) {
        return config.getCategory(category);
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("immersivecables")) {
            ICConfiguration.synchronize();
        }
    }

    static {
        ae2Enabled = true;
        ae2FluixRelayPowerDrain = 2.0f;
        ae2DenseRelayPowerDrain = 3.0f;
        ae2FluixTransformerPowerDrain = 8.0f;
        ae2DenseTransformerPowerDrain = 10.0f;
        ae2QuartzConnectorPowerDrain = 1.0f;
        ae2FluixWireMaxLength = 24;
        ae2DenseWireMaxLength = 16;
        ae2QuartzWireMaxLength = 24;
        rsEnabled = true;
        rsRelayPowerDrain = 2;
        rsTransformerPowerDrain = 12;
        rsWireMaxLength = 16;
    }
}

