/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.thread;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.core.HatHandler;
import me.ichun.mods.ichunutil.common.module.tabula.formats.ImportList;

public class ThreadHatsReader
extends Thread {
    public final File hatsFolder;
    public final boolean shouldDownload;
    public final boolean loadGuiOnEnd;

    public ThreadHatsReader(File hatsFolder, boolean shouldDownload, boolean loadGuiOnEnd) {
        this.hatsFolder = hatsFolder;
        this.shouldDownload = shouldDownload;
        this.loadGuiOnEnd = loadGuiOnEnd;
        this.setName("Hats Download/Read Hats Thread");
        this.setDaemon(true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        void var7_23;
        File[] files;
        File[] favs;
        byte[] buffer;
        if (this.shouldDownload) {
            int hatDownloaded = 0;
            File[] hats = this.hatsFolder.listFiles();
            boolean hasHats = false;
            for (File file : hats) {
                if (file.isDirectory() || !file.getName().endsWith(".tbl")) continue;
                hasHats = true;
            }
            if (!hasHats) {
                try (InputStream in = Hats.class.getResourceAsStream("/hats.zip");){
                    Throwable throwable = null;
                    try (ZipInputStream zipStream = new ZipInputStream(in);){
                        ZipEntry entry;
                        while ((entry = zipStream.getNextEntry()) != null) {
                            int len;
                            File file2 = new File(this.hatsFolder, entry.getName());
                            if (file2.exists() && file2.length() > 3L) continue;
                            if (entry.isDirectory()) {
                                if (file2.exists()) continue;
                                file2.mkdirs();
                                continue;
                            }
                            FileOutputStream out = new FileOutputStream(file2);
                            buffer = new byte[8192];
                            while ((len = zipStream.read(buffer)) != -1) {
                                out.write(buffer, 0, len);
                            }
                            out.close();
                            ++hatDownloaded;
                        }
                    }
                    catch (Throwable entry) {
                        Throwable throwable2 = entry;
                        throw entry;
                    }
                }
                catch (IOException | NullPointerException e) {
                    Hats.LOGGER.warn((Object)"Failed to extract hats from hat jar.");
                    e.printStackTrace();
                }
            }
            if (hatDownloaded != 0) {
                Hats.console("Extracted " + hatDownloaded + " hats from archive");
            }
        }
        int hatCount = 0;
        HatHandler.reloadingHats = true;
        Hats.proxy.clearAllHats();
        File fav = new File(this.hatsFolder, "/Favourites");
        if (!fav.exists()) {
            fav.mkdirs();
        }
        for (File file : favs = fav.listFiles()) {
            File hat;
            if (file.isDirectory() || !ImportList.isFileSupported((File)file) || (hat = new File(this.hatsFolder, file.getName())).exists()) continue;
            FileInputStream inStream = null;
            FileOutputStream outStream = null;
            try {
                int length;
                inStream = new FileInputStream(file);
                outStream = new FileOutputStream(hat);
                buffer = new byte[1024];
                while ((length = ((InputStream)inStream).read(buffer)) > 0) {
                    ((OutputStream)outStream).write(buffer, 0, length);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (outStream == null) continue;
                ((OutputStream)outStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        File[] fileArray = files = this.hatsFolder.listFiles();
        int n = fileArray.length;
        boolean bl = false;
        while (var7_23 < n) {
            File file = fileArray[var7_23];
            if (!file.isDirectory() && HatHandler.readHatFromFile(file)) {
                ++hatCount;
            }
            ++var7_23;
        }
        int contribHats = 0;
        for (File file : files) {
            if (!file.isDirectory() || file.getName().equalsIgnoreCase("Disabled")) continue;
            if (file.getName().equalsIgnoreCase("Contributors")) {
                hatCount += (contribHats += HatHandler.loadCategory(file));
                continue;
            }
            hatCount += HatHandler.loadCategory(file);
        }
        Hats.console((this.loadGuiOnEnd ? "Reloaded " : "Loaded ") + Integer.toString(hatCount) + (hatCount == 1 ? " hat" : " hats. " + contribHats + " are contributor hats."));
        HatHandler.reloadingHats = false;
        if (this.loadGuiOnEnd) {
            HatHandler.reloadAndOpenGui();
        }
    }

    public boolean downloadResource(URL par1URL, File par2File, long size) throws IOException {
        if (par2File.exists()) {
            if (par2File.length() == size || HatHandler.isHatReadable(par2File)) {
                return false;
            }
        } else if (!par2File.getParentFile().exists()) {
            par2File.getParentFile().mkdirs();
        }
        byte[] var5 = new byte[4096];
        HttpsURLConnection con = (HttpsURLConnection)par1URL.openConnection();
        con.setConnectTimeout(15000);
        con.setReadTimeout(15000);
        DataInputStream var6 = new DataInputStream(con.getInputStream());
        DataOutputStream var7 = new DataOutputStream(new FileOutputStream(par2File));
        boolean var8 = false;
        while (true) {
            int var9;
            if ((var9 = var6.read(var5)) < 0) {
                var6.close();
                var7.close();
                return true;
            }
            var7.write(var5, 0, var9);
        }
    }
}

