/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.conduit.ender;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IConduitTexture;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableCache;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.base.conduit.item.FunctionUpgrade;
import crazypants.enderio.base.conduit.item.ItemFunctionUpgrade;
import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.capability.CapabilityFilterHolder;
import crazypants.enderio.base.filter.capability.IFilterHolder;
import crazypants.enderio.base.lang.LangFluid;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.conduits.capability.CapabilityUpgradeHolder;
import crazypants.enderio.conduits.capability.IUpgradeHolder;
import crazypants.enderio.conduits.conduit.IEnderConduit;
import crazypants.enderio.conduits.conduit.item.ItemConduit;
import crazypants.enderio.conduits.lang.Lang;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.conduits.render.ConduitTexture;
import crazypants.enderio.conduits.render.ConduitTextureWrapper;
import crazypants.enderio.util.EnumReader;
import crazypants.enderio.util.Prep;
import gg.galaxygaming.gasconduits.common.conduit.AbstractGasConduit;
import gg.galaxygaming.gasconduits.common.conduit.GasConduitObject;
import gg.galaxygaming.gasconduits.common.conduit.IGasConduit;
import gg.galaxygaming.gasconduits.common.conduit.ender.EnderGasConduitNetwork;
import gg.galaxygaming.gasconduits.common.config.GasConduitConfig;
import gg.galaxygaming.gasconduits.common.filter.GasFilter;
import gg.galaxygaming.gasconduits.common.filter.IGasFilter;
import gg.galaxygaming.gasconduits.common.filter.IItemFilterGasUpgrade;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnderGasConduit
extends AbstractGasConduit
implements IFilterHolder<IGasFilter>,
IUpgradeHolder,
IEnderConduit {
    public static final IConduitTexture ICON_KEY = new ConduitTexture(TextureRegistry.registerTexture((String)"gasconduits:blocks/gas_conduit", (boolean)false), ConduitTexture.arm((int)3));
    public static final IConduitTexture ICON_CORE_KEY = new ConduitTexture(TextureRegistry.registerTexture((String)"gasconduits:blocks/gas_conduit_core", (boolean)false), ConduitTexture.core((int)2));
    private EnderGasConduitNetwork network;
    private int ticksSinceFailedExtract;
    @Nonnull
    private final EnumMap<EnumFacing, IGasFilter> outputFilters = new EnumMap(EnumFacing.class);
    @Nonnull
    private final EnumMap<EnumFacing, IGasFilter> inputFilters = new EnumMap(EnumFacing.class);
    @Nonnull
    private final EnumMap<EnumFacing, ItemStack> outputFilterUpgrades = new EnumMap(EnumFacing.class);
    @Nonnull
    private final EnumMap<EnumFacing, ItemStack> inputFilterUpgrades = new EnumMap(EnumFacing.class);
    @Nonnull
    private final EnumMap<EnumFacing, DyeColor> inputColors = new EnumMap(EnumFacing.class);
    @Nonnull
    private final EnumMap<EnumFacing, DyeColor> outputColors = new EnumMap(EnumFacing.class);
    @Nonnull
    protected final EnumMap<EnumFacing, Integer> priorities = new EnumMap(EnumFacing.class);
    @Nonnull
    protected final EnumMap<EnumFacing, Boolean> roundRobin = new EnumMap(EnumFacing.class);
    @Nonnull
    protected final EnumMap<EnumFacing, Boolean> selfFeed = new EnumMap(EnumFacing.class);
    @Nonnull
    protected final EnumMap<EnumFacing, ItemStack> functionUpgrades = new EnumMap(EnumFacing.class);

    public EnderGasConduit() {
        NNList.NNIterator itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            EnumFacing dir = (EnumFacing)itr.next();
            this.outputFilterUpgrades.put(dir, ItemStack.field_190927_a);
            this.inputFilterUpgrades.put(dir, ItemStack.field_190927_a);
            this.functionUpgrades.put(dir, ItemStack.field_190927_a);
            this.roundRobin.put(dir, true);
        }
    }

    @Nonnull
    public ItemStack createItem() {
        return new ItemStack(GasConduitObject.itemGasConduit.getItemNN(), 1, 2);
    }

    @Nonnull
    public NNList<ItemStack> getDrops() {
        NNList res = super.getDrops();
        res.addAll(this.functionUpgrades.values());
        res.addAll(this.inputFilterUpgrades.values());
        res.addAll(this.outputFilterUpgrades.values());
        return res;
    }

    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        CollidableComponent component;
        if (Prep.isInvalid((ItemStack)player.func_184586_b(hand)) || !ToolUtil.isToolEquipped((EntityPlayer)player, (EnumHand)hand)) {
            return false;
        }
        if (!this.getBundle().getEntity().func_145831_w().field_72995_K && (component = res.component) != null) {
            EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
            if (component.isCore()) {
                if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                    this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                    return true;
                }
                return ConduitUtil.connectConduits((IServerConduit)this, (EnumFacing)faceHit);
            }
            EnumFacing connDir = component.getDirection();
            if (this.containsExternalConnection(connDir)) {
                this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
            } else if (this.containsConduitConnection(connDir)) {
                ConduitUtil.disconnectConduits((IServerConduit)this, (EnumFacing)connDir);
            }
        }
        return true;
    }

    @Nullable
    public IConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    public IGasFilter getFilter(@Nonnull EnumFacing dir, boolean isInput) {
        return isInput ? this.inputFilters.get(dir) : this.outputFilters.get(dir);
    }

    public void setFilter(@Nonnull EnumFacing dir, @Nonnull IGasFilter filter, boolean isInput) {
        if (isInput) {
            this.inputFilters.put(dir, filter);
        } else {
            this.outputFilters.put(dir, filter);
        }
        this.setClientStateDirty();
    }

    @Nonnull
    public ItemStack getFilterStack(@Nonnull EnumFacing dir, boolean isInput) {
        return (ItemStack)NullHelper.first((Object[])new ItemStack[]{isInput ? this.inputFilterUpgrades.get(dir) : this.outputFilterUpgrades.get(dir), Prep.getEmpty()});
    }

    public void setFilterStack(@Nonnull EnumFacing dir, @Nonnull ItemStack stack, boolean isInput) {
        if (isInput) {
            this.inputFilterUpgrades.put(dir, stack);
        } else {
            this.outputFilterUpgrades.put(dir, stack);
        }
        IGasFilter filter = (IGasFilter)FilterRegistry.getFilterForUpgrade((ItemStack)stack);
        if (filter != null) {
            this.setFilter(dir, filter, isInput);
        }
        this.setClientStateDirty();
    }

    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        if (network instanceof EnderGasConduitNetwork) {
            this.network = (EnderGasConduitNetwork)network;
            this.externalConnections.forEach(dir -> this.network.connectionChanged(this, (EnumFacing)dir));
            return super.setNetwork(network);
        }
        return false;
    }

    public void clearNetwork() {
        this.network = null;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IConduitTexture getTextureForState(@Nonnull CollidableComponent component) {
        if (component.isCore()) {
            return ICON_CORE_KEY;
        }
        if ("ColorController".equals(component.data)) {
            return new ConduitTextureWrapper(IconUtil.instance.whiteTexture);
        }
        return ICON_KEY;
    }

    @Nonnull
    public IConduitTexture getTransmitionTextureForState(@Nonnull CollidableComponent component) {
        return ItemConduit.ICON_KEY_ENDER;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Vector4f getTransmitionTextureColorForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(hashCodes);
        hashCodes.addEnum(this.outputColors);
        hashCodes.addEnum(this.inputColors);
        hashCodes.addEnum((Map)this.extractionColors);
        hashCodes.addEnum((Map)this.extractionModes);
    }

    public boolean canConnectToConduit(@Nonnull EnumFacing direction, @Nonnull IConduit con) {
        return super.canConnectToConduit(direction, con) && con instanceof EnderGasConduit;
    }

    public void setConnectionMode(@Nonnull EnumFacing dir, @Nonnull ConnectionMode mode) {
        super.setConnectionMode(dir, mode);
        this.refreshConnection(dir);
    }

    @Override
    public void setExtractionRedstoneMode(@Nonnull RedstoneControlMode mode, @Nonnull EnumFacing dir) {
        super.setExtractionRedstoneMode(mode, dir);
        this.refreshConnection(dir);
    }

    public void externalConnectionAdded(@Nonnull EnumFacing fromDirection) {
        super.externalConnectionAdded(fromDirection);
        this.refreshConnection(fromDirection);
    }

    public void externalConnectionRemoved(@Nonnull EnumFacing fromDirection) {
        super.externalConnectionRemoved(fromDirection);
        this.refreshConnection(fromDirection);
    }

    public void updateEntity(@Nonnull World world) {
        super.updateEntity(world);
        if (world.field_72995_K) {
            return;
        }
        this.doExtract();
    }

    private void doExtract() {
        if (!this.hasExtractableMode() || this.network == null) {
            return;
        }
        ++this.ticksSinceFailedExtract;
        if (this.ticksSinceFailedExtract > 25 && this.ticksSinceFailedExtract % 10 != 0) {
            return;
        }
        for (EnumFacing dir : this.externalConnections) {
            if (!this.autoExtractForDir(dir) || !this.network.extractFrom(this, dir)) continue;
            this.ticksSinceFailedExtract = 0;
        }
    }

    public int receiveGas(EnumFacing side, GasStack resource, boolean doFill) {
        return 0;
    }

    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[0];
    }

    @Nullable
    public GasStack drawGas(EnumFacing side, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canReceiveGas(EnumFacing from, Gas gas) {
        return this.network != null && this.getConnectionMode(from).acceptsInput();
    }

    public boolean canDrawGas(EnumFacing from, Gas gas) {
        return false;
    }

    @Override
    protected void readTypeSettings(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        super.readTypeSettings(dir, dataRoot);
        this.setConnectionMode(dir, (ConnectionMode)EnumReader.get(ConnectionMode.class, (int)dataRoot.func_74765_d("connectionMode")));
        this.setExtractionSignalColor(dir, (DyeColor)EnumReader.get(DyeColor.class, (int)dataRoot.func_74765_d("extractionSignalColor")));
        this.setExtractionRedstoneMode((RedstoneControlMode)EnumReader.get(RedstoneControlMode.class, (int)dataRoot.func_74765_d("extractionRedstoneMode")), dir);
        this.setInputColor(dir, (DyeColor)EnumReader.get(DyeColor.class, (int)dataRoot.func_74765_d("inputColor")));
        this.setOutputColor(dir, (DyeColor)EnumReader.get(DyeColor.class, (int)dataRoot.func_74765_d("outputColor")));
        this.setSelfFeedEnabled(dir, dataRoot.func_74767_n("selfFeed"));
        this.setRoundRobinEnabled(dir, dataRoot.func_74767_n("roundRobin"));
        this.setOutputPriority(dir, dataRoot.func_74762_e("outputPriority"));
    }

    @Override
    protected void writeTypeSettingsToNbt(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        super.writeTypeSettingsToNbt(dir, dataRoot);
        dataRoot.func_74777_a("connectionMode", (short)this.getConnectionMode(dir).ordinal());
        dataRoot.func_74777_a("extractionSignalColor", (short)this.getExtractionSignalColor(dir).ordinal());
        dataRoot.func_74777_a("extractionRedstoneMode", (short)this.getExtractionRedstoneMode(dir).ordinal());
        dataRoot.func_74777_a("inputColor", (short)this.getInputColor(dir).ordinal());
        dataRoot.func_74777_a("outputColor", (short)this.getOutputColor(dir).ordinal());
        dataRoot.func_74757_a("selfFeed", this.isSelfFeedEnabled(dir));
        dataRoot.func_74757_a("roundRobin", this.isRoundRobinEnabled(dir));
        dataRoot.func_74768_a("outputPriority", this.getOutputPriority(dir));
    }

    private boolean isDefault(IGasFilter f) {
        return f instanceof GasFilter && f.isDefault();
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        NBTTagCompound itemRoot;
        IGasFilter filter;
        ItemStack up;
        NBTTagCompound itemRoot2;
        IGasFilter g;
        super.writeToNBT(nbtRoot);
        for (Map.Entry<EnumFacing, IGasFilter> entry : this.inputFilters.entrySet()) {
            if (entry.getValue() == null || this.isDefault(g = entry.getValue())) continue;
            NBTTagCompound itemRoot22 = new NBTTagCompound();
            FilterRegistry.writeFilterToNbt((IFilter)g, (NBTTagCompound)itemRoot22);
            nbtRoot.func_74782_a("inGasFilts." + entry.getKey().name(), (NBTBase)itemRoot22);
        }
        for (Map.Entry<EnumFacing, IGasFilter> entry : this.outputFilters.entrySet()) {
            if (entry.getValue() == null || this.isDefault(g = entry.getValue())) continue;
            itemRoot2 = new NBTTagCompound();
            FilterRegistry.writeFilterToNbt((IFilter)g, (NBTTagCompound)itemRoot2);
            nbtRoot.func_74782_a("outGasFilts." + entry.getKey().name(), (NBTBase)itemRoot2);
        }
        for (Map.Entry<EnumFacing, IGasFilter> entry : this.inputFilterUpgrades.entrySet()) {
            up = (ItemStack)entry.getValue();
            if (up == null || !Prep.isValid((ItemStack)up)) continue;
            filter = this.getFilter(entry.getKey(), true);
            FilterRegistry.writeFilterToStack((IFilter)filter, (ItemStack)up);
            itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("inputGasFilterUpgrades." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, IGasFilter> entry : this.outputFilterUpgrades.entrySet()) {
            up = (ItemStack)entry.getValue();
            if (up == null || !Prep.isValid((ItemStack)up)) continue;
            filter = this.getFilter(entry.getKey(), false);
            FilterRegistry.writeFilterToStack((IFilter)filter, (ItemStack)up);
            itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("outputGasFilterUpgrades." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, IGasFilter> entry : this.inputColors.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("inSC." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, IGasFilter> entry : this.outputColors.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("outSC." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.priorities.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74768_a("priority." + entry.getKey().name(), ((Integer)entry.getValue()).intValue());
        }
        for (Map.Entry<EnumFacing, Object> entry : this.roundRobin.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74757_a("roundRobin." + entry.getKey().name(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (Map.Entry<EnumFacing, Object> entry : this.selfFeed.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74757_a("selfFeed." + entry.getKey().name(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (Map.Entry<EnumFacing, Object> entry : this.functionUpgrades.entrySet()) {
            ItemStack up2 = (ItemStack)entry.getValue();
            if (up2 == null || !Prep.isValid((ItemStack)up2)) continue;
            itemRoot2 = new NBTTagCompound();
            up2.func_77955_b(itemRoot2);
            nbtRoot.func_74782_a("functionUpgrades." + entry.getKey().name(), (NBTBase)itemRoot2);
        }
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            short ord;
            ItemStack ups;
            NBTTagCompound upTag;
            IGasFilter filter;
            NBTTagCompound filterTag;
            String key = "inGasFilts." + dir.name();
            if (nbtRoot.func_74764_b(key)) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                filter = (IGasFilter)FilterRegistry.loadFilterFromNbt((NBTTagCompound)filterTag);
                this.inputFilters.put(dir, filter);
            }
            if (nbtRoot.func_74764_b(key = "inputGasFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.inputFilterUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "outputGasFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.outputFilterUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "outGasFilts." + dir.name())) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                filter = (IGasFilter)FilterRegistry.loadFilterFromNbt((NBTTagCompound)filterTag);
                this.outputFilters.put(dir, filter);
            }
            if (nbtRoot.func_74764_b(key = "inSC." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < DyeColor.values().length) {
                this.inputColors.put(dir, (DyeColor)EnumReader.get(DyeColor.class, (int)ord));
            }
            if (nbtRoot.func_74764_b(key = "outSC." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < DyeColor.values().length) {
                this.outputColors.put(dir, (DyeColor)EnumReader.get(DyeColor.class, (int)ord));
            }
            if (nbtRoot.func_74764_b(key = "priority." + dir.name())) {
                int val = nbtRoot.func_74762_e(key);
                this.priorities.put(dir, val);
            }
            if (nbtRoot.func_74764_b(key = "roundRobin." + dir.name())) {
                boolean val = nbtRoot.func_74767_n(key);
                this.roundRobin.put(dir, val);
            } else {
                this.roundRobin.remove(dir);
            }
            key = "selfFeed." + dir.name();
            if (nbtRoot.func_74764_b(key)) {
                boolean val = nbtRoot.func_74767_n(key);
                this.selfFeed.put(dir, val);
            }
            if (!nbtRoot.func_74764_b(key = "functionUpgrades." + dir.name())) continue;
            NBTTagCompound upTag2 = (NBTTagCompound)nbtRoot.func_74781_a(key);
            ups = new ItemStack(upTag2);
            this.functionUpgrades.put(dir, ups);
        }
        this.connectionsDirty = true;
    }

    @Nonnull
    public EnderGasConduitNetwork createNetworkForType() {
        return new EnderGasConduitNetwork();
    }

    public boolean hasInternalCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY || capability == CapabilityUpgradeHolder.UPGRADE_HOLDER_CAPABILITY && facing != null && this.containsExternalConnection(facing);
    }

    @Nonnull
    public ItemStack getFilterStack(int filterIndex, int param1) {
        if (filterIndex == this.getInputFilterIndex()) {
            return this.getFilterStack(EnumFacing.func_82600_a((int)param1), true);
        }
        if (filterIndex == this.getOutputFilterIndex()) {
            return this.getFilterStack(EnumFacing.func_82600_a((int)param1), false);
        }
        return ItemStack.field_190927_a;
    }

    public IGasFilter getFilter(int filterIndex, int param1) {
        if (filterIndex == this.getInputFilterIndex()) {
            return this.getFilter(EnumFacing.func_82600_a((int)param1), true);
        }
        if (filterIndex == this.getOutputFilterIndex()) {
            return this.getFilter(EnumFacing.func_82600_a((int)param1), false);
        }
        return null;
    }

    public void setFilter(int filterIndex, int param1, @Nonnull IGasFilter filter) {
        if (filterIndex == this.getInputFilterIndex()) {
            this.setFilter(EnumFacing.func_82600_a((int)param1), filter, true);
        } else if (filterIndex == this.getOutputFilterIndex()) {
            this.setFilter(EnumFacing.func_82600_a((int)param1), filter, false);
        }
    }

    public void setFilterStack(int filterIndex, int param1, @Nonnull ItemStack stack) {
        if (filterIndex == this.getInputFilterIndex()) {
            this.setFilterStack(EnumFacing.func_82600_a((int)param1), stack, true);
        } else if (filterIndex == this.getOutputFilterIndex()) {
            this.setFilterStack(EnumFacing.func_82600_a((int)param1), stack, false);
        }
    }

    public int getInputFilterIndex() {
        return 101;
    }

    public int getOutputFilterIndex() {
        return 102;
    }

    public boolean isFilterUpgradeAccepted(@Nonnull ItemStack stack, boolean isInput) {
        return stack.func_77973_b() instanceof IItemFilterGasUpgrade;
    }

    @Nonnull
    public Map<EnumFacing, DyeColor> getInputColors() {
        return this.inputColors;
    }

    @Nonnull
    public Map<EnumFacing, DyeColor> getOutputColors() {
        return this.outputColors;
    }

    @Nonnull
    public Map<EnumFacing, Boolean> getSelfFeed() {
        return this.selfFeed;
    }

    @Nonnull
    public Map<EnumFacing, Boolean> getRoundRobin() {
        return this.roundRobin;
    }

    @Nonnull
    public Map<EnumFacing, Integer> getOutputPriorities() {
        return this.priorities;
    }

    public void setClientDirty() {
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    public void refreshConnection(@Nonnull EnumFacing dir) {
        if (this.network == null) {
            return;
        }
        this.network.connectionChanged(this, dir);
    }

    @Nonnull
    public ItemStack getFunctionUpgrade(@Nonnull EnumFacing dir) {
        return (ItemStack)NullHelper.first((Object[])new ItemStack[]{this.functionUpgrades.get(dir), Prep.getEmpty()});
    }

    public void setFunctionUpgrade(@Nonnull EnumFacing dir, @Nonnull ItemStack upgrade) {
        this.functionUpgrades.put(dir, upgrade);
        this.setClientStateDirty();
    }

    @Nonnull
    public ItemStack getUpgradeStack(int param1) {
        return this.getFunctionUpgrade(EnumFacing.func_82600_a((int)param1));
    }

    public void setUpgradeStack(int param1, @Nonnull ItemStack stack) {
        this.setFunctionUpgrade(EnumFacing.func_82600_a((int)param1), stack);
    }

    public int getUpgradeSlotLimit(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof ItemFunctionUpgrade ? ((ItemFunctionUpgrade)stack.func_77973_b()).getUpgradeSlotLimit() : super.getUpgradeSlotLimit(stack);
    }

    @Nonnull
    public List<String> getFunctionUpgradeToolTipText(@Nonnull EnumFacing dir) {
        return new NNList((Object[])new String[]{Lang.GUI_LIQUID_FUNCTION_UPGRADE_DETAILS.get(), Lang.GUI_LIQUID_FUNCTION_UPGRADE_DETAILS2.get(new Object[]{(int)(100.0f * this.getExtractSpeedMultiplier(dir)), LangFluid.MB((int)((int)((float)((Integer)GasConduitConfig.tier3_extractRate.get()).intValue() * this.getExtractSpeedMultiplier(dir))))})});
    }

    @Nullable
    public <T> T getInternalCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY || capability == CapabilityUpgradeHolder.UPGRADE_HOLDER_CAPABILITY ? this : null);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(this.hasCapability(capability, facing) ? new ConnectionEnderGasSide(facing) : null);
    }

    @Nonnull
    public Collection<CollidableComponent> createCollidables(@Nonnull CollidableCache.CacheKey key) {
        Collection baseCollidables = super.createCollidables(key);
        EnumFacing keydir = key.dir;
        if (keydir == null) {
            return baseCollidables;
        }
        BoundingBox bb = ConduitGeometryUtil.getInstance().createBoundsForConnectionController(keydir, key.offset);
        CollidableComponent cc = new CollidableComponent(IGasConduit.class, bb, keydir, (Object)"ColorController");
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>(baseCollidables);
        result.add(cc);
        return result;
    }

    public float getExtractSpeedMultiplier(@Nonnull EnumFacing dir) {
        int extractSpeedMultiplier = 2;
        ItemStack upgradeStack = this.getFunctionUpgrade(dir);
        if (!upgradeStack.func_190926_b()) {
            FunctionUpgrade upgrade = ItemFunctionUpgrade.getFunctionUpgrade((ItemStack)upgradeStack);
            if (upgrade == FunctionUpgrade.EXTRACT_SPEED_UPGRADE) {
                extractSpeedMultiplier += 2 * Math.min(upgrade.getMaxStackSize(), upgradeStack.func_190916_E());
            } else if (upgrade == FunctionUpgrade.EXTRACT_SPEED_DOWNGRADE) {
                extractSpeedMultiplier = 1;
            }
        }
        return (float)extractSpeedMultiplier / 2.0f;
    }

    protected class ConnectionEnderGasSide
    extends AbstractGasConduit.ConnectionGasSide {
        public ConnectionEnderGasSide(EnumFacing side) {
            super(side);
        }

        @Override
        public int receiveGas(EnumFacing facing, GasStack resource, boolean doFill) {
            return this.canReceiveGas(facing, resource.getGas()) ? (EnderGasConduit.this.network == null ? 0 : EnderGasConduit.this.network.fillFrom(EnderGasConduit.this, facing, resource, doFill)) : 0;
        }

        @Override
        @Nonnull
        public GasTankInfo[] getTankInfo() {
            return EnderGasConduit.this.network == null ? new GasTankInfo[]{} : EnderGasConduit.this.network.getTankProperties(EnderGasConduit.this, this.side);
        }
    }
}

