/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.coremod;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import pl.asie.foamfix.coremod.patches.BlockPosPatch;
import pl.asie.foamfix.coremod.patches.EntityDataManagerPatch;
import pl.asie.foamfix.coremod.patches.FastAirLookupPatch;
import pl.asie.foamfix.coremod.patches.ReturnIfBooleanTruePatch;
import pl.asie.foamfix.coremod.patches.WorldServerRemovalPatch;
import pl.asie.foamfix.shared.FoamFixShared;
import pl.asie.patchy.Patchy;
import pl.asie.patchy.TransformerHandler;
import pl.asie.patchy.handlers.TransformerHandlerByteArray;
import pl.asie.patchy.handlers.TransformerHandlerClassNode;
import pl.asie.patchy.handlers.TransformerHandlerClassVisitor;
import pl.asie.patchy.helpers.ConstructorReplacingTransformer;

public class FoamFixTransformer
implements IClassTransformer {
    private static final Patchy patchy = new Patchy();

    private static byte[] getClassBytes(String className) throws IOException {
        ClassLoader loader = FoamFixTransformer.class.getClassLoader();
        if (loader instanceof LaunchClassLoader) {
            return ((LaunchClassLoader)FoamFixTransformer.class.getClassLoader()).getClassBytes(className);
        }
        throw new RuntimeException("Incompatible class loader for FoamFixTransformer.getClassBytes: " + loader.getClass().getName());
    }

    public static ClassNode spliceClasses(ClassNode data, String className, boolean addMethods, String ... methods) {
        try {
            byte[] dataSplice = FoamFixTransformer.getClassBytes(className);
            return FoamFixTransformer.spliceClasses(data, dataSplice, className, addMethods, methods);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassNode spliceClasses(ClassNode nodeData, byte[] dataSplice, String className, boolean addMethods, String ... methods) {
        int j;
        boolean added;
        MethodNode mn;
        int i;
        if (dataSplice == null) {
            throw new RuntimeException("Class " + className + " not found! This is a FoamFix bug!");
        }
        HashSet methodSet = Sets.newHashSet((Object[])methods);
        ArrayList methodList = Lists.newArrayList((Object[])methods);
        ClassReader readerSplice = new ClassReader(dataSplice);
        final String className2 = className.replace('.', '/');
        final String targetClassName2 = nodeData.name;
        String targetClassName = targetClassName2.replace('/', '.');
        Remapper remapper = new Remapper(){

            public String map(String name) {
                return className2.equals(name) ? targetClassName2 : name;
            }
        };
        ClassNode nodeSplice = new ClassNode();
        readerSplice.accept((ClassVisitor)new ClassRemapper((ClassVisitor)nodeSplice, remapper), 8);
        for (String s : nodeSplice.interfaces) {
            if (!s.contains("IFoamFix")) continue;
            nodeData.interfaces.add(s);
            System.out.println("Added INTERFACE: " + s);
        }
        for (i = 0; i < nodeSplice.methods.size(); ++i) {
            if (!methodSet.contains(((MethodNode)nodeSplice.methods.get((int)i)).name)) continue;
            mn = (MethodNode)nodeSplice.methods.get(i);
            added = false;
            for (j = 0; j < nodeData.methods.size(); ++j) {
                if (!((MethodNode)nodeData.methods.get((int)j)).name.equals(mn.name) || !((MethodNode)nodeData.methods.get((int)j)).desc.equals(mn.desc)) continue;
                MethodNode oldMn = (MethodNode)nodeData.methods.get(j);
                System.out.println("Spliced in METHOD: " + targetClassName + "." + mn.name);
                nodeData.methods.set(j, mn);
                if (nodeData.superName != null && nodeData.name.equals(nodeSplice.superName)) {
                    for (AbstractInsnNode node : mn.instructions) {
                        if (!(node instanceof MethodInsnNode) || node.getOpcode() != 183) continue;
                        MethodInsnNode methodNode = (MethodInsnNode)node;
                        if (!targetClassName2.equals(methodNode.owner)) continue;
                        methodNode.owner = nodeData.superName;
                    }
                }
                oldMn.name = (String)methodList.get(methodList.indexOf(oldMn.name) & 0xFFFFFFFE) + "_foamfix_old";
                nodeData.methods.add(oldMn);
                added = true;
                break;
            }
            if (added || !addMethods) continue;
            System.out.println("Added METHOD: " + targetClassName + "." + mn.name);
            nodeData.methods.add(mn);
            added = true;
        }
        for (i = 0; i < nodeSplice.fields.size(); ++i) {
            if (!methodSet.contains(((FieldNode)nodeSplice.fields.get((int)i)).name)) continue;
            mn = (FieldNode)nodeSplice.fields.get(i);
            added = false;
            for (j = 0; j < nodeData.fields.size(); ++j) {
                if (!((FieldNode)nodeData.fields.get((int)j)).name.equals(mn.name) || !((FieldNode)nodeData.fields.get((int)j)).desc.equals(mn.desc)) continue;
                System.out.println("Spliced in FIELD: " + targetClassName + "." + mn.name);
                nodeData.fields.set(j, mn);
                added = true;
                break;
            }
            if (added) continue;
            System.out.println("Added FIELD: " + targetClassName + "." + mn.name);
            nodeData.fields.add(mn);
            added = true;
        }
        return nodeData;
    }

    public static ClassNode replaceClasses(ClassNode data, String className) {
        try {
            byte[] dataSplice = FoamFixTransformer.getClassBytes(className);
            return FoamFixTransformer.replaceClasses(data, dataSplice, className);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassNode replaceClasses(ClassNode nodeData, byte[] dataSplice, String className) {
        System.out.println("replacing " + nodeData.name + " with " + className);
        if (dataSplice == null) {
            throw new RuntimeException("Class " + className + " not found! This is a FoamFix bug!");
        }
        ClassReader readerSplice = new ClassReader(dataSplice);
        final String className2 = className.replace('.', '/');
        final String targetClassName2 = nodeData.name;
        String targetClassName = targetClassName2.replace('/', '.');
        Remapper remapper = new Remapper(){

            public String map(String name) {
                return className2.equals(name) ? targetClassName2 : name;
            }
        };
        ClassNode nodeSplice = new ClassNode();
        readerSplice.accept((ClassVisitor)new ClassRemapper((ClassVisitor)nodeSplice, remapper), 8);
        return nodeSplice;
    }

    public static void init() {
        boolean compatible;
        patchy.registerHandler(byte[].class, new TransformerHandlerByteArray(patchy));
        patchy.registerHandler(ClassNode.class, new TransformerHandlerClassNode(patchy));
        patchy.registerHandler(ClassVisitor.class, new TransformerHandlerClassVisitor(patchy));
        TransformerHandler<byte[]> handler = patchy.getHandler(byte[].class);
        TransformerHandler<ClassNode> handlerCN = patchy.getHandler(ClassNode.class);
        TransformerHandler<ClassVisitor> handlerCV = patchy.getHandler(ClassVisitor.class);
        if (FoamFixShared.config.geSmallPropertyStorage && (compatible = true)) {
            patchy.addTransformerId("smallPropertyStorage_v1");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.common.FoamyBlockStateContainer", false, "createState", "createState"), "net.minecraft.block.state.BlockStateContainer");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.common.FoamyExtendedBlockStateContainer", false, "createState", "createState"), "net.minecraftforge.common.property.ExtendedBlockState");
        }
        if (FoamFixShared.config.gePatchChunkSerialization) {
            compatible = true;
            if (FoamFixShared.emitWarningIfPresent("coremod.patchChunkSerialization", FoamFixShared::hasIdPatch, "JustEnoughIDs/NotEnoughIDs")) {
                compatible = false;
            }
            if (FoamFixShared.emitWarningIfPresent("coremod.patchChunkSerialization", FoamFixShared::hasSponge, "SpongeForge")) {
                compatible = false;
            }
            if (compatible) {
                patchy.addTransformerId("patchChunkSerialization_v1");
                handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.BlockStateContainerSpongeInject", false, "getSerializedSize", "func_186018_a"), "net.minecraft.world.chunk.BlockStateContainer");
            }
        }
        if (FoamFixShared.config.twImmediateLightingUpdates) {
            patchy.addTransformerId("immediateLightingUpdates_v1");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.client.RenderGlobalImmediateInject", false, "notifyLightSet", "func_174959_b"), "net.minecraft.client.renderer.RenderGlobal");
        }
        if (FoamFixShared.config.clDynamicItemModels) {
            patchy.addTransformerId("dynamicItemModels_v1");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.client.FoamFixDynamicItemModels", false, "bake", "bake"), "net.minecraftforge.client.model.ItemLayerModel");
        }
        if (FoamFixShared.config.clCheapMinimumLighter) {
            patchy.addTransformerId("cheapMinimumLighter_v1");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.client.BlockInfoInject", true, "getRawB", "getRawB", "getRawS", "getRawS", "updateAO", "updateAO"), "net.minecraftforge.client.model.pipeline.BlockInfo");
        }
        if (FoamFixShared.config.geBlockPosPatch) {
            compatible = true;
            if (FoamFixShared.emitWarningIfPresent("coremod.optimizedBlockPos", FoamFixShared::hasSponge, "SpongeForge")) {
                compatible = false;
            }
            if (compatible) {
                patchy.addTransformerId("blockPosPatch_v1");
                handlerCN.add(BlockPosPatch::patchVec3i, "net.minecraft.util.math.Vec3i");
                handlerCV.add(BlockPosPatch::patchOtherClass, new String[0]);
            }
        }
        if (FoamFixShared.config.geFasterEntityLookup) {
            patchy.addTransformerId("fasterClassInheritanceMultiMap_v1");
            handlerCV.add(new ConstructorReplacingTransformer("net.minecraft.util.ClassInheritanceMultiMap", "pl.asie.foamfix.coremod.common.FoamyClassInheritanceMultiMap", "<init>"), "net.minecraft.world.chunk.Chunk");
        }
        if (FoamFixShared.config.geFasterAirLookup) {
            patchy.addTransformerId("fasterAirLookup_v1");
            handlerCN.add(new FastAirLookupPatch(), "net.minecraft.item.ItemStack");
        }
        if (FoamFixShared.config.geFasterPropertyComparisons) {
            patchy.addTransformerId("fasterPropertyComparisons_v2");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.PropertyFasterComparisonsInject$Bool", true, "equals", "equals", "hashCode", "hashCode"), "net.minecraft.block.properties.PropertyBool");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.PropertyFasterComparisonsInject$Enum", false, "equals", "equals"), "net.minecraft.block.properties.PropertyEnum");
            for (String s : new String[]{"net.minecraft.block.properties.PropertyInteger", "net.minecraft.block.properties.PropertyEnum"}) {
                handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.CachingHashCodeInject", true, "hashCode", "hashCode", "foamfix_hashCode", "foamfix_hashCode", "foamfix_hashCode_calced", "foamfix_hashCode_calced"), s);
            }
        }
        if (FoamFixShared.config.geFasterEntityDataManager) {
            patchy.addTransformerId("fasterEntityDataManager_v1");
            handlerCN.add(new EntityDataManagerPatch(), "net.minecraft.network.datasync.EntityDataManager");
        }
        patchy.addTransformerId("disableTextureAnimations_v1");
        handlerCN.add(new ReturnIfBooleanTruePatch("clDisableTextureAnimations", "updateAnimations", "func_94248_c"), "net.minecraft.client.renderer.texture.TextureMap");
        if (FoamFixShared.config.geFasterHopper) {
            patchy.addTransformerId("fasterHopper_v1");
            handlerCV.add(new ConstructorReplacingTransformer("net.minecraft.tileentity.TileEntityHopper", "pl.asie.foamfix.common.TileEntityFasterHopper", "createNewTileEntity", "func_149915_a"), "net.minecraft.block.BlockHopper");
            patchy.addTransformerId("tileEntityGetKeyWrap_v1");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.TileEntityGetKeyWrapInject", false, "getKey", "func_190559_a"), "net.minecraft.tileentity.TileEntity");
        }
        if (FoamFixShared.config.geFixWorldEntityCleanup) {
            patchy.addTransformerId("fixWorldEntityCleanup_v1");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.WorldRemovalInject", true, "foamfix_removeUnloadedEntities", "foamfix_removeUnloadedEntities"), "net.minecraft.world.World");
            handlerCN.add(new WorldServerRemovalPatch(), "net.minecraft.world.WorldServer");
        }
        if (FoamFixShared.config.txEnable) {
            patchy.addTransformerId("fastTextureAtlasSprite_v1");
            handlerCV.add(new ConstructorReplacingTransformer("net.minecraft.client.renderer.texture.TextureAtlasSprite", "pl.asie.foamfix.client.FastTextureAtlasSprite", "makeAtlasSprite", "func_176604_a"), "net.minecraft.client.renderer.texture.TextureAtlasSprite");
        }
        if (FoamFixShared.config.gbPatchBeds) {
            patchy.addTransformerId("gbPatchBeds_v1");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.BlockBedInject", false, "neighborChanged", "func_189540_a"), "net.minecraft.block.BlockBed");
        }
        if (FoamFixShared.config.geMobSpawnerCheckSpeed > 2) {
            patchy.addTransformerId("geMobSpawnerCheckSpeed_v2");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.CachingMobSpawnerLogicInject", false, "isActivated", "func_98279_f", "foamfix_activatedCache", "foamfix_activatedCache", "foamfix_activatedCachePESize", "foamfix_activatedCachePESize", "foamfix_activatedCacheTime", "foamfix_activatedCacheTime", "foamfix_forcedCache", "foamfix_forcedCache", "foamfix_forcedCacheTime", "foamfix_forcedCacheTime"), "net.minecraft.tileentity.MobSpawnerBaseLogic");
        }
        if (FoamFixShared.config.clJeiCreativeSearch) {
            patchy.addTransformerId("clJeiCreativeSearch_v1");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.patches.jei.SearchTreeJEIManagerInject", false, "onResourceManagerReload", "func_110549_a"), "net.minecraft.client.util.SearchTreeManager");
        }
        if (FoamFixShared.config.clWipeModelCache) {
            patchy.addTransformerId("wipeModelCache_v1");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.client.VanillaModelWrapperInject", false, "bakeNormal", "bakeNormal"), "net.minecraftforge.client.model.ModelLoader$VanillaModelWrapper");
        }
        if (FoamFixShared.config.clClearCachesOnUnload) {
            patchy.addTransformerId("clearCachesOnUnload_v2");
            handlerCN.add(data -> FoamFixTransformer.spliceClasses(data, "pl.asie.foamfix.coremod.injections.client.AnimationModelBaseClearCacheInject", false, "render", "render"), "net.minecraftforge.client.model.animation.AnimationModelBase");
        }
    }

    public byte[] transform(String name, String transformedName, byte[] dataOrig) {
        return FoamFixShared.isCoremod ? patchy.transform(name, transformedName, dataOrig) : dataOrig;
    }
}

