/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.util.crafting.ShapedFluidRecipeFactory;
import cofh.core.util.crafting.ShapedUpgradeRecipeFactory;
import cofh.core.util.crafting.ShapelessColorRecipeFactory;
import cofh.core.util.crafting.ShapelessColorRemoveRecipeFactory;
import cofh.core.util.crafting.ShapelessFluidRecipeFactory;
import cofh.core.util.crafting.ShapelessSecureRecipeFactory;
import cofh.core.util.crafting.ShapelessUpgradeKitRecipeFactory;
import cofh.core.util.helpers.ItemHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeHelper {
    public static void addShapedRecipe(ItemStack output, Object ... input) {
        ResourceLocation location = RecipeHelper.getNameForRecipe(output);
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])input);
        ShapedRecipes recipe = new ShapedRecipes(output.func_77973_b().getRegistryName().toString(), primer.width, primer.height, primer.input, output);
        recipe.setRegistryName(location);
        GameData.register_impl((IForgeRegistryEntry)recipe);
    }

    public static void addShapedFluidRecipe(ItemStack output, Object ... input) {
        ResourceLocation location = RecipeHelper.getNameForRecipe(output);
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])input);
        ShapedFluidRecipeFactory.ShapedFluidRecipe recipe = new ShapedFluidRecipeFactory.ShapedFluidRecipe(location, output, primer);
        recipe.setRegistryName(location);
        GameData.register_impl((IForgeRegistryEntry)recipe);
    }

    public static void addShapedUpgradeRecipe(ItemStack output, Object ... input) {
        ResourceLocation location = RecipeHelper.getNameForRecipe(output);
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])input);
        ShapedUpgradeRecipeFactory.ShapedUpgradeRecipe recipe = new ShapedUpgradeRecipeFactory.ShapedUpgradeRecipe(location, output, primer);
        recipe.setRegistryName(location);
        GameData.register_impl((IForgeRegistryEntry)recipe);
    }

    public static void addShapelessRecipe(ItemStack output, Object ... input) {
        ResourceLocation location = RecipeHelper.getNameForRecipe(output);
        ShapelessRecipes recipe = new ShapelessRecipes(location.func_110624_b(), output, RecipeHelper.buildInput(input));
        recipe.setRegistryName(location);
        GameData.register_impl((IForgeRegistryEntry)recipe);
    }

    public static void addShapelessFluidRecipe(ItemStack output, Object ... input) {
        ResourceLocation location = RecipeHelper.getNameForRecipe(output);
        ShapelessFluidRecipeFactory.ShapelessFluidRecipe recipe = new ShapelessFluidRecipeFactory.ShapelessFluidRecipe(location, output, input);
        recipe.setRegistryName(location);
        GameData.register_impl((IForgeRegistryEntry)recipe);
    }

    public static void addShapelessSecureRecipe(ItemStack output, Object ... input) {
        ResourceLocation location = RecipeHelper.getNameForRecipe(output);
        ShapelessSecureRecipeFactory.ShapelessSecureRecipe recipe = new ShapelessSecureRecipeFactory.ShapelessSecureRecipe(location, output, input);
        recipe.setRegistryName(location);
        GameData.register_impl((IForgeRegistryEntry)recipe);
    }

    public static void addShapelessUpgradeKitRecipe(ItemStack output, Object ... input) {
        ResourceLocation location = RecipeHelper.getNameForRecipe(output);
        ShapelessUpgradeKitRecipeFactory.ShapelessUpgradeKitRecipe recipe = new ShapelessUpgradeKitRecipeFactory.ShapelessUpgradeKitRecipe(location, output, input);
        recipe.setRegistryName(location);
        GameData.register_impl((IForgeRegistryEntry)recipe);
    }

    public static void addColorRecipe(ItemStack output, Object ... input) {
        ResourceLocation location = RecipeHelper.getNameForRecipe(output);
        ShapelessColorRecipeFactory.ShapelessColorRecipe recipe = new ShapelessColorRecipeFactory.ShapelessColorRecipe(location, output, input);
        recipe.setRegistryName(location);
        GameData.register_impl((IForgeRegistryEntry)recipe);
    }

    public static void addColorRemoveRecipe(ItemStack output, Object ... input) {
        ResourceLocation location = RecipeHelper.getNameForRecipe(output);
        ShapelessColorRemoveRecipeFactory.ShapelessColorRemoveRecipe recipe = new ShapelessColorRemoveRecipeFactory.ShapelessColorRemoveRecipe(location, output, input);
        recipe.setRegistryName(location);
        GameData.register_impl((IForgeRegistryEntry)recipe);
    }

    public static void addGearRecipe(ItemStack gear, String ingot) {
        RecipeHelper.addShapedRecipe(gear, " X ", "X X", " X ", Character.valueOf('X'), ingot);
    }

    public static void addGearRecipe(ItemStack gear, String ingot, String center) {
        RecipeHelper.addShapedRecipe(gear, " X ", "XIX", " X ", Character.valueOf('X'), ingot, Character.valueOf('I'), center);
    }

    public static void addGearRecipe(ItemStack gear, String ingot, ItemStack center) {
        RecipeHelper.addShapedRecipe(gear, " X ", "XIX", " X ", Character.valueOf('X'), ingot, Character.valueOf('I'), center);
    }

    public static void addGearRecipe(ItemStack gear, ItemStack ingot, String center) {
        RecipeHelper.addShapedRecipe(gear, " X ", "XIX", " X ", Character.valueOf('X'), ingot, Character.valueOf('I'), center);
    }

    public static void addGearRecipe(ItemStack gear, ItemStack ingot, ItemStack center) {
        RecipeHelper.addShapedRecipe(ItemHelper.cloneStack(gear), " X ", "XIX", " X ", Character.valueOf('X'), ItemHelper.cloneStack(ingot, 1), Character.valueOf('I'), ItemHelper.cloneStack(center, 1));
    }

    public static void addStorageRecipe(ItemStack one, String nine) {
        RecipeHelper.addShapedRecipe(one, "XXX", "XXX", "XXX", Character.valueOf('X'), nine);
    }

    public static void addStorageRecipe(ItemStack one, ItemStack nine) {
        RecipeHelper.addShapedRecipe(one, "XXX", "XXX", "XXX", Character.valueOf('X'), ItemHelper.cloneStack(nine, 1));
    }

    public static void addSmallStorageRecipe(ItemStack one, String four) {
        RecipeHelper.addShapedRecipe(one, "XX", "XX", Character.valueOf('X'), four);
    }

    public static void addSmallStorageRecipe(ItemStack one, ItemStack four) {
        RecipeHelper.addShapedRecipe(ItemHelper.cloneStack(one), "XX", "XX", Character.valueOf('X'), ItemHelper.cloneStack(four, 1));
    }

    public static void addReverseStorageRecipe(ItemStack nine, String one) {
        RecipeHelper.addShapelessRecipe(ItemHelper.cloneStack(nine, 9), one);
    }

    public static void addReverseStorageRecipe(ItemStack nine, ItemStack one) {
        RecipeHelper.addShapelessRecipe(ItemHelper.cloneStack(nine, 9), ItemHelper.cloneStack(one, 1));
    }

    public static void addSmallReverseStorageRecipe(ItemStack four, String one) {
        RecipeHelper.addShapelessRecipe(ItemHelper.cloneStack(four, 4), one);
    }

    public static void addSmallReverseStorageRecipe(ItemStack four, ItemStack one) {
        RecipeHelper.addShapelessRecipe(ItemHelper.cloneStack(four, 4), ItemHelper.cloneStack(one, 1));
    }

    public static void addTwoWayStorageRecipe(ItemStack one, ItemStack nine) {
        RecipeHelper.addStorageRecipe(one, nine);
        RecipeHelper.addReverseStorageRecipe(nine, one);
    }

    public static void addTwoWayStorageRecipe(ItemStack one, String one_ore, ItemStack nine, String nine_ore) {
        RecipeHelper.addStorageRecipe(one, nine_ore);
        RecipeHelper.addReverseStorageRecipe(nine, one_ore);
    }

    public static void addSmallTwoWayStorageRecipe(ItemStack one, ItemStack four) {
        RecipeHelper.addSmallStorageRecipe(one, four);
        RecipeHelper.addSmallReverseStorageRecipe(four, one);
    }

    public static void addSmallTwoWayStorageRecipe(ItemStack one, String one_ore, ItemStack four, String four_ore) {
        RecipeHelper.addSmallStorageRecipe(one, four_ore);
        RecipeHelper.addSmallReverseStorageRecipe(four, one_ore);
    }

    public static ResourceLocation getNameForRecipe(ItemStack output) {
        ResourceLocation baseLoc;
        ModContainer activeContainer = Loader.instance().activeModContainer();
        ResourceLocation recipeLoc = baseLoc = new ResourceLocation(activeContainer.getModId(), output.func_77973_b().getRegistryName().func_110623_a());
        int index = 0;
        while (CraftingManager.field_193380_a.func_148741_d((Object)recipeLoc)) {
            recipeLoc = new ResourceLocation(activeContainer.getModId(), baseLoc.func_110623_a() + "_" + ++index);
        }
        return recipeLoc;
    }

    public static NonNullList<Ingredient> buildInput(Object[] input) {
        NonNullList list = NonNullList.func_191196_a();
        for (Object obj : input) {
            if (obj instanceof Ingredient) {
                list.add((Object)((Ingredient)obj));
                continue;
            }
            Ingredient ingredient = CraftingHelper.getIngredient((Object)obj);
            if (ingredient == null) {
                ingredient = Ingredient.field_193370_a;
            }
            list.add((Object)ingredient);
        }
        return list;
    }

    public static void addSmelting(Block input, ItemStack output, float xp) {
        GameRegistry.addSmelting((Block)input, (ItemStack)output, (float)xp);
    }

    public static void addSmelting(Item input, ItemStack output, float xp) {
        GameRegistry.addSmelting((Item)input, (ItemStack)output, (float)xp);
    }

    public static void addSmelting(ItemStack input, ItemStack output, float xp) {
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)xp);
    }

    public static void addSmelting(ItemStack input, ItemStack output) {
        RecipeHelper.addSmelting(input, output, 0.0f);
    }

    public static void addSmelting(Item input, ItemStack output) {
        RecipeHelper.addSmelting(input, output, 0.0f);
    }

    public static void addSmelting(Block input, ItemStack output) {
        RecipeHelper.addSmelting(input, output, 0.0f);
    }
}

