/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.Util;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.tool.ITool;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.ItemEIO;
import crazypants.enderio.base.conduit.ConduitDisplayMode;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IConduitItem;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.facade.EnumFacadeType;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.geom.ConduitConnectorType;
import crazypants.enderio.base.gui.handler.IEioGuiHandler;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.item.conduitprobe.ItemConduitProbe;
import crazypants.enderio.base.machine.interfaces.IYetaAwareBlock;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.paint.YetaUtil;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.conduits.EnderIOConduits;
import crazypants.enderio.conduits.conduit.TileConduitBundle;
import crazypants.enderio.conduits.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduits.config.ConduitConfig;
import crazypants.enderio.conduits.gui.ExternalConnectionContainer;
import crazypants.enderio.conduits.gui.GuiExternalConnection;
import crazypants.enderio.conduits.gui.GuiExternalConnectionSelector;
import crazypants.enderio.conduits.lang.Lang;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.conduits.render.ConduitRenderMapper;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.BlockPosContext;
import net.minecraftforge.server.permission.context.IContext;

public class BlockConduitBundle
extends BlockEio<TileConduitBundle>
implements IEioGuiHandler.WithPos,
IPaintable.IBlockPaintableBlock,
IPaintable.IWrenchHideablePaint,
IYetaAwareBlock {
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite lastHitIcon;
    private final Random rand = new Random();
    @Nonnull
    private AxisAlignedBB bounds = this.setBlockBounds(0.334, 0.334, 0.334, 0.667, 0.667, 0.667);
    @Nonnull
    public static final IProperty<Boolean> OPAQUE = PropertyBool.func_177716_a((String)"opaque");

    public static BlockConduitBundle create(@Nonnull IModObject modObject) {
        BlockConduitBundle result = new BlockConduitBundle(modObject);
        result.init();
        return result;
    }

    protected BlockConduitBundle(@Nonnull IModObject modObject) {
        super(modObject);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149647_a(null);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(OPAQUE, (Comparable)Boolean.valueOf(false)));
        this.setShape(this.mkShape(BlockFaceShape.UNDEFINED));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{OPAQUE});
    }

    @Nonnull
    private AxisAlignedBB setBlockBounds(double f, double g, double h, double i, double j, double k) {
        this.bounds = new AxisAlignedBB(f, g, h, i, j, k);
        return this.bounds;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return this.bounds;
    }

    @Override
    protected void init() {
        super.init();
        SmartModelAttacher.registerNoProps((Block)this);
    }

    @Override
    @Nullable
    public ItemEIO createBlockItem(@Nonnull IModObject modObject) {
        return null;
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return (Boolean)state.func_177229_b(OPAQUE) != false ? 1 : 0;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(OPAQUE, (Comparable)Boolean.valueOf(meta == 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        BlockStateWrapperConduitBundle blockStateWrapper = new BlockStateWrapperConduitBundle(state, world, pos, ConduitRenderMapper.instance);
        TileConduitBundle bundle = (TileConduitBundle)this.getTileEntitySafe(world, pos);
        if (bundle != null) {
            TileConduitBundle tileConduitBundle = bundle;
            synchronized (tileConduitBundle) {
                blockStateWrapper.addCacheKey(bundle);
                blockStateWrapper.bakeModel();
            }
        } else {
            blockStateWrapper.bakeModel();
        }
        return blockStateWrapper;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(@Nonnull IBlockState state, @Nonnull World world, @Nonnull RayTraceResult target, @Nonnull ParticleManager effectRenderer) {
        TileConduitBundle cb = (TileConduitBundle)this.getTileEntity((IBlockAccess)world, target.func_178782_a());
        if (cb == null) {
            return false;
        }
        TextureAtlasSprite tex = null;
        if (YetaUtil.isSolidFacadeRendered(cb, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            IBlockState paintSource = cb.getPaintSource();
            if (paintSource != null) {
                tex = RenderUtil.getTexture((IBlockState)paintSource);
            }
        } else if (target.hitInfo instanceof CollidableComponent) {
            CollidableComponent cc = (CollidableComponent)target.hitInfo;
            IConduit con = cb.getConduit(cc.conduitType);
            if (con != null && con instanceof IClientConduit.WithDefaultRendering) {
                tex = ((IClientConduit.WithDefaultRendering)con).getTextureForState(cc).getCroppedSprite();
            }
        }
        if (tex == null) {
            tex = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(ModObject.block_machine_base.getBlockNN().func_176223_P());
        }
        this.lastHitIcon = tex;
        this.addBlockHitEffects(world, effectRenderer, target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, target.field_178784_b, tex);
        return true;
    }

    public boolean addLandingEffects(@Nonnull IBlockState state, @Nonnull WorldServer world, @Nonnull BlockPos bp, @Nonnull IBlockState iblockstate, @Nonnull EntityLivingBase entity, int numberOfParticles) {
        IBlockState ps;
        int stateId = Block.func_176210_f((IBlockState)ModObject.block_machine_base.getBlockNN().func_176223_P());
        TileConduitBundle te = (TileConduitBundle)this.getTileEntity((IBlockAccess)world, bp);
        if (te != null && (ps = te.getPaintSource()) != null) {
            stateId = Block.func_176210_f((IBlockState)ps);
        }
        world.func_175739_a(EnumParticleTypes.BLOCK_DUST, (double)bp.func_177958_n() + 0.5, (double)(bp.func_177956_o() + 1), (double)bp.func_177952_p() + 0.5, numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f, new int[]{stateId});
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleManager effectRenderer) {
        if (this.lastHitIcon == null) {
            this.lastHitIcon = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(ModObject.block_machine_base.getBlockNN().func_176223_P());
        }
        IBlockState state = world.func_180495_p(pos);
        TextureAtlasSprite tex = this.lastHitIcon;
        if (state.func_177230_c() != this || tex == null) {
            return false;
        }
        state = state.func_185899_b((IBlockAccess)world, pos);
        int i = 4;
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < i; ++k) {
                for (int l = 0; l < i; ++l) {
                    double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / (double)i;
                    double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / (double)i;
                    double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / (double)i;
                    ParticleDigging fx = (ParticleDigging)new ParticleDigging.Factory().func_178902_a(-1, world, d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, new int[]{0});
                    fx.func_174846_a(pos);
                    fx.func_187117_a(tex);
                    effectRenderer.func_78873_a((Particle)fx);
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlockHitEffects(@Nonnull World world, @Nonnull ParticleManager effectRenderer, double xCoord, double yCoord, double zCoord, @Nonnull EnumFacing sideEnum, @Nonnull TextureAtlasSprite tex) {
        ParticleDigging digFX;
        double d0 = xCoord;
        double d1 = yCoord;
        double d2 = zCoord;
        if (sideEnum.func_176740_k() != EnumFacing.Axis.X) {
            d0 += this.rand.nextDouble() * 0.4 - this.rand.nextDouble() * 0.4;
        }
        if (sideEnum.func_176740_k() != EnumFacing.Axis.Y) {
            d1 += this.rand.nextDouble() * 0.4 - this.rand.nextDouble() * 0.4;
        }
        if (sideEnum.func_176740_k() != EnumFacing.Axis.Z) {
            d2 += this.rand.nextDouble() * 0.4 - this.rand.nextDouble() * 0.4;
        }
        if ((digFX = (ParticleDigging)Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, 0.0, 0.0, 0.0, new int[]{0})) != null) {
            digFX.func_174845_l().func_70543_e(0.2f).func_70541_f(0.6f);
            digFX.func_187117_a(tex);
        }
    }

    @Override
    @Nonnull
    protected ItemStack processPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, @Nonnull ItemStack pickBlock) {
        ItemStack ret = ItemStack.field_190927_a;
        if (target.hitInfo instanceof CollidableComponent) {
            CollidableComponent cc = (CollidableComponent)target.hitInfo;
            TileConduitBundle bundle = (TileConduitBundle)this.getTileEntity((IBlockAccess)world, pos);
            if (bundle != null) {
                IConduit conduit = bundle.getConduit(cc.conduitType);
                if (conduit != null) {
                    ret = conduit.createItem();
                } else if (cc.conduitType == null && bundle.hasFacade()) {
                    bundle.getFacadeType();
                    ret = new ItemStack(ModObject.itemConduitFacade.getItemNN(), 1, EnumFacadeType.getMetaFromType(bundle.getFacadeType()));
                    PaintUtil.setSourceBlock(ret, bundle.getPaintSource());
                }
            }
        }
        return ret;
    }

    public int func_149745_a(@Nonnull Random r) {
        return 0;
    }

    @Nonnull
    public Item func_180660_a(@Nonnull IBlockState state, @Nonnull Random randParam, int fortune) {
        return Items.field_190931_a;
    }

    @Nonnull
    public ItemStack func_185473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return Prep.getEmpty();
    }

    @Nullable
    public ItemStack getNBTDrop(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune, @Nullable TileConduitBundle te) {
        return null;
    }

    public void getExtraDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune, @Nullable TileConduitBundle te) {
        if (te == null) {
            return;
        }
        if (te.hasFacade()) {
            ItemStack stack = new ItemStack(ModObject.itemConduitFacade.getItemNN(), 1, EnumFacadeType.getMetaFromType(te.getFacadeType()));
            PaintUtil.setSourceBlock(stack, te.getPaintSource());
            drops.add((Object)stack);
        }
        for (IConduit iConduit : te.getConduits()) {
            drops.addAll(iConduit.getDrops());
        }
    }

    public boolean isSideSolid(@Nonnull IBlockState bs, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        IConduitBundle te = (IConduitBundle)this.getTileEntitySafe(world, pos);
        if (te == null) {
            return false;
        }
        if (te.hasFacade()) {
            try {
                return te.getPaintSourceNN().isSideSolid(world, pos, side);
            }
            catch (Exception exception) {
                return true;
            }
        }
        return false;
    }

    public boolean canBeReplacedByLeaves(@Nonnull IBlockState bs, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState bs) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState bs) {
        return (Boolean)bs.func_177229_b(OPAQUE);
    }

    public int func_149717_k(@Nonnull IBlockState bs) {
        return (Boolean)bs.func_177229_b(OPAQUE) != false ? 255 : 0;
    }

    public int getLightOpacity(@Nonnull IBlockState bs, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        if (((Boolean)bs.func_177229_b(OPAQUE)).booleanValue()) {
            return 255;
        }
        IConduitBundle te = (IConduitBundle)this.getTileEntitySafe(world, pos);
        if (te == null) {
            return this.func_149717_k(bs);
        }
        return te.getLightOpacity();
    }

    public int getLightValue(@Nonnull IBlockState bs, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileConduitBundle te = (TileConduitBundle)this.getTileEntitySafe(world, pos);
        if (te == null) {
            return super.getLightValue(bs, world, pos);
        }
        int result = 0;
        if (te.hasFacade()) {
            IBlockState paintSource = te.getPaintSourceNN();
            result = paintSource.func_185906_d();
            if (paintSource.func_185914_p()) {
                return result;
            }
        }
        if (((Boolean)ConduitConfig.dynamicLighting.get()).booleanValue()) {
            Collection<? extends IConduit> conduits = te.getConduits();
            for (IConduit iConduit : conduits) {
                result += iConduit.getLightValue();
            }
        }
        return result > 15 ? 15 : result;
    }

    @Nonnull
    public SoundType getSoundType(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity entity) {
        IConduitBundle te = (IConduitBundle)this.getTileEntitySafe((IBlockAccess)world, pos);
        if (te != null && te.hasFacade()) {
            return te.getPaintSourceNN().func_177230_c().func_185467_w();
        }
        return super.getSoundType(state, world, pos, entity);
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(@Nonnull IBlockState bs, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        IConduitBundle te = (IConduitBundle)this.getTileEntitySafe(worldIn, pos);
        if (te != null && te.hasFacade()) {
            if (te.getFacadeRenderedAs() == IConduitBundle.FacadeRenderState.WIRE_FRAME) {
                return 255;
            }
            return this.getMixedBrightnessForFacade(bs, worldIn, pos, te.getPaintSourceNN());
        }
        return super.func_185484_c(bs, worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int getMixedBrightnessForFacade(@Nonnull IBlockState bs, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState facade) {
        if (facade.func_177230_c() instanceof BlockSlab) {
            if (((BlockSlab)facade.func_177230_c()).func_176552_j()) {
                return worldIn.func_175626_b(pos, this.getLightValue(bs, worldIn, pos));
            }
            return this.getNeightbourBrightness(worldIn, pos, facade.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? EnumFacing.UP : EnumFacing.DOWN);
        }
        if (facade.func_185916_f()) {
            return this.getNeightbourBrightness(worldIn, pos, null);
        }
        return worldIn.func_175626_b(pos, this.getLightValue(bs, worldIn, pos));
    }

    private int getNeightbourBrightness(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, @Nullable EnumFacing except) {
        int result = worldIn.func_175626_b(pos.func_177984_a(), 0);
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            int val;
            if (dir == null || dir == except || (val = worldIn.func_175626_b(pos.func_177972_a(dir), 0)) <= result) continue;
            result = val;
        }
        return result;
    }

    @Deprecated
    public float func_176195_g(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos) {
        IConduitBundle te = (IConduitBundle)this.getTileEntity((IBlockAccess)world, pos);
        if (te == null) {
            return super.func_176195_g(bs, world, pos);
        }
        return te.getFacadeType().isHardened() ? this.field_149782_v * 10.0f : this.field_149782_v;
    }

    public float getExplosionResistance(@Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity par1Entity, @Nonnull Explosion explosion) {
        float resist = super.getExplosionResistance(world, pos, par1Entity, explosion);
        IConduitBundle te = (IConduitBundle)this.getTileEntity((IBlockAccess)world, pos);
        return te != null && te.getFacadeType().isHardened() ? resist * 10.0f : resist;
    }

    public int func_176211_b(@Nonnull IBlockState bs, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        IRedstoneConduit con = this.getRedstoneConduit(world, pos);
        if (con == null) {
            return 0;
        }
        return con.isProvidingStrongPower(side);
    }

    public int func_180656_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        IRedstoneConduit con = this.getRedstoneConduit(world, pos);
        if (con == null) {
            return 0;
        }
        return con.isProvidingWeakPower(side);
    }

    public boolean canConnectRedstone(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        IRedstoneConduit con = this.getRedstoneConduit(world, pos);
        if (con == null) {
            return false;
        }
        return side == null || con.containsExternalConnection(side);
    }

    public boolean func_149744_f(@Nonnull IBlockState bs) {
        return true;
    }

    public boolean removedByPlayer(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        IConduitBundle te = (IConduitBundle)this.getTileEntity((IBlockAccess)world, pos);
        if (te == null) {
            return true;
        }
        boolean breakBlock = true;
        NNList drop = new NNList();
        if (YetaUtil.isSolidFacadeRendered(te, player)) {
            breakBlock = false;
            ItemStack fac = new ItemStack(ModObject.itemConduitFacade.getItemNN(), 1, EnumFacadeType.getMetaFromType(te.getFacadeType()));
            PaintUtil.setSourceBlock(fac, te.getPaintSource());
            drop.add((Object)fac);
            ConduitUtil.playBreakSound(te.getPaintSourceNN().func_177230_c().func_185467_w(), world, pos);
            te.setPaintSource(null);
            te.setFacadeType(EnumFacadeType.BASIC);
        }
        if (breakBlock) {
            List<RaytraceResult> results = this.doRayTraceAll(world, pos, player);
            RaytraceResult.sort(Util.getEyePosition((EntityPlayer)player), results);
            for (RaytraceResult rt : results) {
                if (this.breakConduit(te, (List<ItemStack>)drop, rt, player)) break;
            }
        }
        boolean bl = breakBlock = te.getConduits().isEmpty() && !te.hasFacade();
        if (!breakBlock) {
            world.func_184138_a(pos, bs, bs, 3);
        }
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
            for (ItemStack st : drop) {
                Util.dropItems((World)world, (ItemStack)((ItemStack)NullHelper.notnullM((Object)st, (String)"NNList#iterator.next()")), (BlockPos)pos, (boolean)false);
            }
        }
        if (breakBlock) {
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }

    private boolean breakConduit(IConduitBundle te, List<ItemStack> drop, RaytraceResult rt, EntityPlayer player) {
        if (rt == null) {
            return false;
        }
        CollidableComponent component = rt.component;
        if (component == null) {
            return false;
        }
        Class<? extends IConduit> type = component.conduitType;
        if (!YetaUtil.renderConduit(player, type)) {
            return false;
        }
        if (type == null) {
            ArrayList<? extends IConduit> cons = new ArrayList<IConduit>(te.getConduits());
            boolean droppedUnconected = false;
            for (IConduit iConduit : cons) {
                if (!iConduit.getConduitConnections().isEmpty() || !iConduit.getExternalConnections().isEmpty() || !YetaUtil.renderConduit(player, iConduit)) continue;
                te.removeConduit(iConduit);
                drop.addAll((Collection<ItemStack>)iConduit.getDrops());
                droppedUnconected = true;
            }
            if (!droppedUnconected) {
                for (IConduit iConduit : cons) {
                    if (iConduit == null || !YetaUtil.renderConduit(player, iConduit)) continue;
                    te.removeConduit(iConduit);
                    drop.addAll((Collection<ItemStack>)iConduit.getDrops());
                }
            }
        } else {
            IConduit con = te.getConduit(type);
            if (con != null) {
                te.removeConduit(con);
                drop.addAll((Collection<ItemStack>)con.getDrops());
            }
        }
        return true;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        IConduitBundle te = (IConduitBundle)this.getTileEntity((IBlockAccess)world, pos);
        if (te == null) {
            return;
        }
        te.onBlockRemoved();
        world.func_175713_t(pos);
    }

    public void func_180649_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        ItemStack equipped = player.func_184614_ca();
        if (!world.field_72995_K || !player.func_70093_af() || equipped.func_190926_b() || !ToolUtil.isToolEquipped(player, EnumHand.MAIN_HAND)) {
            return;
        }
        ConduitUtil.openConduitGui(world, pos, player);
    }

    @Override
    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        IConduitBundle bundle = (IConduitBundle)this.getTileEntity((IBlockAccess)world, pos);
        if (bundle == null) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == ModObject.itemConduitFacade.getItemNN()) {
            return bundle.handleFacadeClick(world, pos, player, side, stack, hand, hitX, hitY, hitZ);
        }
        if (ConduitUtil.isConduitEquipped(player, hand)) {
            if (player.func_70093_af()) {
                return false;
            }
            if (this.handleConduitClick(world, pos, player, bundle, stack, hand)) {
                return true;
            }
        } else if (ConduitUtil.isProbeEquipped(player, hand) ? this.handleConduitProbeClick(world, pos, player, bundle, stack) : ToolUtil.isToolEquipped(player, hand) && player.func_70093_af() && this.handleWrenchClick(world, pos, player, hand)) {
            return true;
        }
        List<RaytraceResult> all = this.doRayTraceAll(world, pos, player);
        for (RaytraceResult raytraceResult : RaytraceResult.sort(Util.getEyePosition((EntityPlayer)player), all)) {
            IConduit componentConduit;
            if (raytraceResult.component.data instanceof ConduitConnectorType) {
                if (raytraceResult.component.data == ConduitConnectorType.INTERNAL && YetaUtil.renderInternalComponent(player)) {
                    return false;
                }
                if (!raytraceResult.component.isDirectional()) continue;
                if (!world.field_72995_K) {
                    this.openGui(world, pos, player, raytraceResult.component.getDirection(), raytraceResult.component.getDirection().ordinal());
                }
                return true;
            }
            if (raytraceResult.component.conduitType == null || (componentConduit = bundle.getConduit(raytraceResult.component.conduitType)) == null || !YetaUtil.renderConduit(player, componentConduit) || !componentConduit.onBlockActivated(player, hand, raytraceResult, all)) continue;
            bundle.getEntity().func_70296_d();
            return true;
        }
        return false;
    }

    private boolean handleWrenchClick(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ITool tool = ToolUtil.getEquippedTool(player, hand);
        if (tool != null && tool.canUse(hand, player, pos)) {
            if (!world.field_72995_K) {
                IBlockState bs = world.func_180495_p(pos);
                if (!PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)this.permissionNodeWrenching, (IContext)new BlockPosContext(player, pos, bs, null))) {
                    player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("wrench.permission.denied")));
                    return false;
                }
                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, bs, player);
                event.setExpToDrop(0);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return false;
                }
                this.removedByPlayer(bs, world, pos, player, true);
                tool.used(hand, player, pos);
            }
            return true;
        }
        return false;
    }

    private boolean handleConduitProbeClick(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, @Nonnull IConduitBundle bundle, @Nonnull ItemStack stack) {
        if (stack.func_77952_i() != 1) {
            return false;
        }
        RaytraceResult rr = this.doRayTrace(world, pos, player);
        if (rr == null) {
            return false;
        }
        CollidableComponent component = rr.component;
        if (component == null) {
            return false;
        }
        if (component.isCore()) {
            return false;
        }
        return ItemConduitProbe.copyPasteSettings(player, stack, bundle, component.getDirection());
    }

    private boolean handleConduitClick(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, @Nonnull IConduitBundle bundle, @Nonnull ItemStack stack, @Nonnull EnumHand hand) {
        IConduitItem equipped = (IConduitItem)stack.func_77973_b();
        if (!bundle.hasType(equipped.getBaseConduitType())) {
            if (!world.field_72995_K) {
                if (bundle.addConduit(equipped.createConduit(stack, player))) {
                    ConduitUtil.playBreakSound(SoundType.field_185852_e, world, pos);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_184586_b(hand).func_190918_g(1);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation(Lang.GUI_CONDUIT_BUNDLE_FULL.getKey(), new Object[0]), true);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1) {
        if (facing == null) {
            return null;
        }
        TileConduitBundle te = (TileConduitBundle)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            return (Container)new ExternalConnectionContainer(player.field_71071_by, facing, te).init();
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1) {
        TileConduitBundle te = (TileConduitBundle)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            if (facing == null) {
                return new GuiExternalConnectionSelector(te);
            }
            return new GuiExternalConnection(player.field_71071_by, te, facing);
        }
        return null;
    }

    @Deprecated
    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos neighborPos) {
        TileConduitBundle conduit;
        if (neighborBlock != this && (conduit = (TileConduitBundle)this.getTileEntity((IBlockAccess)world, pos)) != null) {
            conduit.onNeighborBlockChange(neighborBlock);
        }
    }

    public void onNeighborChange(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull BlockPos neighbor) {
        TileConduitBundle conduit;
        if (world.func_180495_p(neighbor).func_177230_c() != this && (conduit = (TileConduitBundle)this.getTileEntity(world, pos)) != null) {
            conduit.onNeighborChange(world, pos, neighbor);
        }
    }

    @Deprecated
    public void func_185477_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB axisalignedbb, @Nonnull List<AxisAlignedBB> arraylist, @Nullable Entity par7Entity, boolean b) {
        IConduitBundle con = (IConduitBundle)this.getTileEntity((IBlockAccess)world, pos);
        if (con == null) {
            return;
        }
        if (con.hasFacade()) {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            super.func_185477_a(state, world, pos, axisalignedbb, arraylist, par7Entity, b);
        } else {
            List<CollidableComponent> collidableComponents = con.getCollidableComponents();
            for (CollidableComponent bnd : collidableComponents) {
                this.setBlockBounds(bnd.bound.field_72340_a, bnd.bound.field_72338_b, bnd.bound.field_72339_c, bnd.bound.field_72336_d, bnd.bound.field_72337_e, bnd.bound.field_72334_f);
                super.func_185477_a(state, world, pos, axisalignedbb, arraylist, par7Entity, b);
            }
            if (con.getConduits().isEmpty()) {
                this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                super.func_185477_a(state, world, pos, axisalignedbb, arraylist, par7Entity, b);
            }
        }
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public AxisAlignedBB func_180640_a(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos) {
        TileConduitBundle te = (TileConduitBundle)this.getTileEntity((IBlockAccess)world, pos);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (te == null) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        TileConduitBundle con = te;
        BoundingBox minBB = null;
        if (!YetaUtil.isSolidFacadeRendered(con, (EntityPlayer)player)) {
            CollidableComponent component;
            List<RaytraceResult> results = this.doRayTraceAll(world, pos, (EntityPlayer)player);
            Iterator<RaytraceResult> iter = results.iterator();
            while (iter.hasNext()) {
                CollidableComponent component2 = iter.next().component;
                if (component2 == null || component2.conduitType != null || component2.data == ConduitConnectorType.EXTERNAL) continue;
                iter.remove();
            }
            RaytraceResult hit = RaytraceResult.getClosestHit(Util.getEyePosition((EntityPlayer)player), results);
            CollidableComponent collidableComponent = component = hit == null ? null : hit.component;
            if (component != null) {
                minBB = component.bound;
                if (component.isDirectional() && component.conduitType == null) {
                    EnumFacing dir = component.getDirection();
                    dir = dir.func_176734_d();
                    float trans = 0.0125f;
                    minBB = minBB.translate((float)dir.func_82601_c() * trans, (float)dir.func_96559_d() * trans, (float)dir.func_82599_e() * trans);
                    float scale = 0.7f;
                    minBB = minBB.scale(1.0f + (float)Math.abs(dir.func_82601_c()) * scale, 1.0f + (float)Math.abs(dir.func_96559_d()) * scale, 1.0f + (float)Math.abs(dir.func_82599_e()) * scale);
                } else {
                    minBB = minBB.scale(1.09, 1.09, 1.09);
                }
            }
        } else {
            minBB = new BoundingBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (minBB == null) {
            minBB = new BoundingBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        return new AxisAlignedBB((double)pos.func_177958_n() + minBB.field_72340_a, (double)pos.func_177956_o() + minBB.field_72338_b, (double)pos.func_177952_p() + minBB.field_72339_c, (double)pos.func_177958_n() + minBB.field_72336_d, (double)pos.func_177956_o() + minBB.field_72337_e, (double)pos.func_177952_p() + minBB.field_72334_f);
    }

    public RayTraceResult func_180636_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d origin, @Nonnull Vec3d direction) {
        RaytraceResult raytraceResult = this.doRayTrace(world, pos, origin, direction, null);
        RayTraceResult ret = null;
        if (raytraceResult != null) {
            ret = raytraceResult.movingObjectPosition;
            ret.hitInfo = raytraceResult.component;
        }
        return ret;
    }

    public RaytraceResult doRayTrace(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer) {
        List<RaytraceResult> allHits = this.doRayTraceAll(world, pos, entityPlayer);
        Vec3d origin = Util.getEyePosition((EntityPlayer)entityPlayer);
        return RaytraceResult.getClosestHit(origin, allHits);
    }

    @Nonnull
    public List<RaytraceResult> doRayTraceAll(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer) {
        double reachDistance = EnderIO.proxy.getReachDistanceForPlayer(entityPlayer);
        Vec3d origin = Util.getEyePosition((EntityPlayer)entityPlayer);
        Vec3d look = entityPlayer.func_70676_i(EnderIOConduits.proxy.getPartialTicks());
        Vec3d direction = origin.func_178787_e(look.func_186678_a(reachDistance));
        return this.doRayTraceAll(world.func_180495_p(pos), world, pos, origin, direction, entityPlayer);
    }

    @Nullable
    private RaytraceResult doRayTrace(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d origin, @Nonnull Vec3d direction, EntityPlayer entityPlayer) {
        NNList<RaytraceResult> allHits = this.doRayTraceAll(world.func_180495_p(pos), world, pos, origin, direction, entityPlayer);
        return RaytraceResult.getClosestHit(origin, allHits);
    }

    @Nonnull
    protected NNList<RaytraceResult> doRayTraceAll(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d origin, @Nonnull Vec3d direction, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IConduitBundle)) {
            return NNList.emptyList();
        }
        IConduitBundle bundle = (IConduitBundle)te;
        NNList hits = new NNList();
        if (YetaUtil.isSolidFacadeRendered(bundle, player)) {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            RayTraceResult hitPos = super.func_180636_a(bs, world, pos, origin, direction);
            if (hitPos != null) {
                hits.add((Object)new RaytraceResult(new CollidableComponent(null, BoundingBox.UNIT_CUBE, hitPos.field_178784_b, null), hitPos));
            }
        } else {
            ConduitDisplayMode mode = YetaUtil.getDisplayMode(player);
            for (CollidableComponent component : new ArrayList<CollidableComponent>(bundle.getCollidableComponents())) {
                if (!mode.isAll() && component.conduitType != null && !YetaUtil.renderConduit(player, component.conduitType)) continue;
                this.setBlockBounds(component.bound.field_72340_a, component.bound.field_72338_b, component.bound.field_72339_c, component.bound.field_72336_d, component.bound.field_72337_e, component.bound.field_72334_f);
                RayTraceResult hitPos = super.func_180636_a(bs, world, pos, origin, direction);
                if (hitPos == null) continue;
                hits.add((Object)new RaytraceResult(component, hitPos));
            }
            if (bundle.getConduits().isEmpty() && !YetaUtil.isFacadeHidden(bundle, player)) {
                this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                RayTraceResult hitPos = super.func_180636_a(bs, world, pos, origin, direction);
                if (hitPos != null) {
                    hits.add((Object)new RaytraceResult(new CollidableComponent(null, BoundingBox.UNIT_CUBE, hitPos.field_178784_b, null), hitPos));
                }
            }
        }
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return hits;
    }

    private IRedstoneConduit getRedstoneConduit(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        IConduitBundle te = (IConduitBundle)this.getTileEntity(world, pos);
        if (te == null) {
            return null;
        }
        return te.getConduit(IRedstoneConduit.class);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }
}

