/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.utils;

import java.util.Collection;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import team.thegoldenhoe.cameraobscura.CSModelMetadata;

public class SoundRegistry {
    private static HashMap<String, SoundEvent> lookupStringToEvent = new HashMap();

    public static void register(String soundPath) {
        ResourceLocation resLoc = new ResourceLocation("cameraobscura", soundPath);
        SoundEvent event = new SoundEvent(resLoc);
        event.setRegistryName(resLoc);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)event);
        if (lookupStringToEvent.containsKey(soundPath)) {
            System.out.println("DECOCRAFT WARNING: duplicate sound registration for " + soundPath);
        }
        lookupStringToEvent.put(soundPath, event);
    }

    public static SoundEvent get(String soundPath) {
        return lookupStringToEvent.get(soundPath);
    }

    public static void registerAllSounds(Collection<CSModelMetadata> values) {
        lookupStringToEvent.clear();
        for (CSModelMetadata decoModelMetadata : values) {
            if (decoModelMetadata.sound == null) continue;
            SoundRegistry.register(decoModelMetadata.sound);
        }
        SoundRegistry.register("polaroid");
        SoundRegistry.register("digital");
        SoundRegistry.register("vintage");
    }
}

