/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.common.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import team.thegoldenhoe.cameraobscura.CameraObscura;
import team.thegoldenhoe.cameraobscura.common.craftstudio.TilePictureFrame;

public class MessageFrameStatusUpdate
implements IMessage {
    private int dim;
    private int x;
    private int y;
    private int z;
    private String location;
    private TilePictureFrame.Status status;

    public MessageFrameStatusUpdate() {
    }

    public MessageFrameStatusUpdate(int dim, int x, int y, int z, String location, TilePictureFrame.Status status) {
        this.dim = dim;
        this.x = x;
        this.y = y;
        this.z = z;
        this.location = location;
        this.status = status;
    }

    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.location = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.status = TilePictureFrame.Status.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.location);
        buf.writeInt(this.status.ordinal());
    }

    public static final class Handler
    implements IMessageHandler<MessageFrameStatusUpdate, IMessage> {
        public IMessage onMessage(MessageFrameStatusUpdate message, MessageContext ctx) {
            World world = CameraObscura.proxy.getClientWorld();
            if (world == null) {
                return null;
            }
            TileEntity tileEntity = world.func_175625_s(new BlockPos(message.x, message.y, message.z));
            if (tileEntity instanceof TilePictureFrame) {
                TilePictureFrame frame = (TilePictureFrame)tileEntity;
                frame.setStatus(message.status);
            }
            return null;
        }
    }
}

