/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.client;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ScreenShotHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;
import team.thegoldenhoe.cameraobscura.CSModelMetadata;
import team.thegoldenhoe.cameraobscura.Utils;
import team.thegoldenhoe.cameraobscura.client.PhotoFilter;
import team.thegoldenhoe.cameraobscura.client.PhotoFilters;
import team.thegoldenhoe.cameraobscura.common.capability.CameraCapabilities;
import team.thegoldenhoe.cameraobscura.common.capability.ICameraNBT;
import team.thegoldenhoe.cameraobscura.common.network.CONetworkHandler;
import team.thegoldenhoe.cameraobscura.common.network.CameraTypes;
import team.thegoldenhoe.cameraobscura.common.network.MessagePhotoDataToServer;
import team.thegoldenhoe.cameraobscura.common.network.PhotoDataHandler;
import team.thegoldenhoe.cameraobscura.utils.ModelHandler;

public class PhotographHelper {
    public static void capturePhotograph() {
        try {
            Minecraft mc = Minecraft.func_71410_x();
            ItemStack stack = mc.field_71439_g.func_184614_ca();
            if (!Utils.isCamera(stack)) {
                stack = mc.field_71439_g.func_184592_cb();
            }
            ArrayList<Object> filters = new ArrayList<Object>(2);
            CSModelMetadata data = ModelHandler.getModelFromStack(stack);
            CameraTypes type = data.getCameraType();
            ICameraNBT cameraCap = (ICameraNBT)stack.getCapability(CameraCapabilities.getCameraCapability(), null);
            if (cameraCap != null) {
                if (type == CameraTypes.DIGITAL) {
                    Pair<PhotoFilter, PhotoFilter> filterPair = cameraCap.getFilters();
                    if (filterPair.getLeft() != null) {
                        filters.add(filterPair.getLeft());
                    }
                    if (filterPair.getRight() != null) {
                        filters.add(filterPair.getRight());
                    }
                } else if (type == CameraTypes.VINTAGE) {
                    filters.add(PhotoFilters.BLACK_AND_WHITE);
                } else if (type == CameraTypes.POLAROID) {
                    filters.add(PhotoFilters.VINTAGE);
                }
            }
            BufferedImage screenshot = ScreenShotHelper.func_186719_a((int)mc.field_71443_c, (int)mc.field_71440_d, (Framebuffer)mc.func_147110_a());
            for (PhotoFilter photoFilter : filters) {
                screenshot = photoFilter.getFilteredImage(screenshot);
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)screenshot, "png", stream);
            byte[] byArray = stream.toByteArray();
            ByteBuffer buff = ByteBuffer.wrap(byArray);
            short order = 0;
            int bytePacketLen = 30000;
            int uuid = PhotoDataHandler.getUniqueID();
            while (buff.hasRemaining()) {
                byte[] subImageBytes = new byte[buff.remaining() > bytePacketLen ? bytePacketLen : buff.remaining()];
                buff.get(subImageBytes, 0, buff.remaining() > bytePacketLen ? bytePacketLen : buff.remaining());
                stack = mc.field_71439_g.func_184614_ca();
                if (!Utils.isCamera(stack)) {
                    stack = mc.field_71439_g.func_184592_cb();
                }
                MessagePhotoDataToServer msg = new MessagePhotoDataToServer(uuid, "test", subImageBytes, order, byArray.length, mc.field_71439_g.func_110124_au());
                CONetworkHandler.NETWORK.sendToServer((IMessage)msg);
                order = (short)(order + 1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

