/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.util;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import net.minecraft.util.ResourceLocation;

public class GCRegisterUtilities {
    public static Planet registerUnreachablePlanet(String name, SolarSystem system) {
        ArrayList cBodyList = new ArrayList();
        cBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        for (CelestialBody body : cBodyList) {
            if (!(body instanceof Planet) || !name.equals(body.getName()) || ((Planet)body).getParentSolarSystem() != system) continue;
            return null;
        }
        Planet planet = new Planet(name).setParentSolarSystem(system);
        planet.setBodyIcon(new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/" + name + ".png"));
        GalaxyRegistry.registerPlanet((Planet)planet);
        return planet;
    }

    public static Moon registerUnreachableMoon(String name, Planet parent) {
        ArrayList cBodyList = new ArrayList();
        cBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        for (CelestialBody body : cBodyList) {
            if (!(body instanceof Moon) || !name.equals(body.getName()) || ((Moon)body).getParentPlanet() != parent) continue;
            return null;
        }
        Moon moon = new Moon(name).setParentPlanet(parent);
        if (name.equalsIgnoreCase("callisto") || name.equalsIgnoreCase("europa") || name.equalsIgnoreCase("io") || name.equalsIgnoreCase("ganymede")) {
            moon.setBodyIcon(new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/" + name + ".png"));
        } else {
            moon.setBodyIcon(new ResourceLocation("extraplanets", "textures/gui/celestialbodies/" + name + ".png"));
        }
        GalaxyRegistry.registerMoon((Moon)moon);
        return moon;
    }
}

