/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.gui;

import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.UniqueItem;
import brad16840.common.gui.CraftingContainer;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ChestContainer
extends StackableContainer
implements UniqueItem.BaseInventoryProvider {
    public IInventory inventory;
    private int x;
    private int y;
    private int z;
    private static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/chest.png");
    private boolean wasClosed = true;

    public static boolean isOcelotBlockingChest(World world, BlockPos pos) {
        Entity entity;
        EntityOcelot entityocelot;
        Iterator iterator = world.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1))).iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(entityocelot = (EntityOcelot)(entity = (Entity)iterator.next())).func_70906_o());
        return true;
    }

    private static boolean checkNeighbour(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == Blocks.field_150486_ae && (world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN) || ChestContainer.isOcelotBlockingChest(world, pos));
    }

    public static IInventory getInventory(EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150486_ae) {
            ILockableContainer container = ((BlockChest)block).func_180676_d(world, pos);
            if (!container.func_70300_a(player)) {
                return null;
            }
            return container;
        }
        if (block == Blocks.field_150477_bB) {
            InventoryEnderChest inventoryenderchest = player.func_71005_bN();
            TileEntity tileentity = world.func_175625_s(pos);
            if (inventoryenderchest != null && tileentity instanceof TileEntityEnderChest) {
                if (world.func_180495_p(pos.func_177984_a()).func_177230_c().func_149721_r(world.func_180495_p(pos.func_177984_a()))) {
                    return null;
                }
                inventoryenderchest.func_146031_a((TileEntityEnderChest)tileentity);
                if (!inventoryenderchest.func_70300_a(player)) {
                    return null;
                }
                return inventoryenderchest;
            }
        } else {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof IInventory) {
                if (!((IInventory)tileEntity).func_70300_a(player)) {
                    return null;
                }
                return (IInventory)tileEntity;
            }
        }
        return null;
    }

    public ChestContainer(IInventory inventory, int x, int y, int z) {
        super(176, 18 * (inventory.func_70302_i_() / 9) + 24);
        this.x = x;
        this.y = y;
        this.z = z;
        this.inventory = inventory;
        UniqueItem.registerBaseInventoryProvider(this);
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        this.inventory = ChestContainer.getInventory(player, player.field_70170_p, this.x, this.y, this.z);
        if (this.inventory == null) {
            return false;
        }
        if (this.wasClosed && !player.field_70170_p.field_72995_K) {
            this.wasClosed = false;
            this.inventory.func_174889_b(player);
        }
        int numRows = this.inventory.func_70302_i_() / 9;
        for (int y = 0; y < numRows; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlotToContainer(ContainerStack.ContainerSection.CHEST, new StackableContainer.ContainerSlot(this, player, this.inventory, x + y * 9, 8 + x * 18, 18 + y * 18));
            }
        }
        if (this.guiHeight != 18 * (this.inventory.func_70302_i_() / 9) + 24) {
            this.guiHeight = 18 * (this.inventory.func_70302_i_() / 9) + 24;
            this.container.reupdateContainers = true;
            return true;
        }
        return true;
    }

    @Override
    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        for (StackableContainer container1 : containers) {
            ((ChestContainer)container1).inventory = ChestContainer.getInventory(player, player.field_70170_p, ((ChestContainer)container1).x, ((ChestContainer)container1).y, ((ChestContainer)container1).z);
            if (((ChestContainer)container1).inventory != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onClosed(EntityPlayer player) {
        this.wasClosed = true;
        if (this.inventory == null) {
            return;
        }
        if (!player.field_70170_p.field_72995_K) {
            TileEntity entity;
            if (this.inventory instanceof TileEntityChest) {
                if (((TileEntityChest)this.inventory).field_145987_o < 1) {
                    this.inventory.func_174889_b(player);
                }
            } else if (this.inventory instanceof InventoryLargeChest && (entity = player.field_70170_p.func_175625_s(new BlockPos(this.x, this.y, this.z))) != null && entity instanceof TileEntityChest && ((TileEntityChest)entity).field_145987_o < 1) {
                this.inventory.func_174889_b(player);
            }
            this.inventory.func_174886_c(player);
        }
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof UniqueItem.UpdatableItem)) continue;
            ((UniqueItem.UpdatableItem)stack.func_77973_b()).updateItemStack(null, stack);
        }
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, Slot slot, StackableContainer.ContainerSlotInterface containerSlot) {
        ItemStack itemstack = ItemStack.field_190927_a;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (!this.container.mergeItemStack(this, itemstack1, 0, this.inventory.func_70302_i_(), false)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75220_a(itemstack1, itemstack);
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack);
        }
        return itemstack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int mouseX, int mouseY) {
        this.gui.text(this, this.inventory.func_145818_k_() ? this.inventory.func_70005_c_() : I18n.func_135052_a((String)this.inventory.func_70005_c_(), (Object[])new Object[0])).truncateString(this.guiWidth - 16).drawString(8, 6, -12566464);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture(this, 0, 0, this.guiWidth, this.guiHeight, 0, 0);
        if (this.inventory.func_70302_i_() / 9 > 3) {
            this.gui.drawTexture(this, 0, 71, this.guiWidth, 61, 0, 17);
        }
    }

    @Override
    public String getId() {
        return "none";
    }

    @Override
    public boolean customRightClick(EntityPlayer player, int slot, boolean holdingShift) {
        ItemStack stack = this.container.func_75139_a(slot).func_75211_c();
        int openStackId = this.stackId;
        if (holdingShift && ++openStackId >= this.container.stacks.length) {
            openStackId = 0;
        }
        if (!stack.func_190926_b()) {
            this.container.saveInventories(player);
            if (stack.func_77973_b() instanceof UniqueItem.OpenableItem) {
                UniqueItem.OpenableItem item = (UniqueItem.OpenableItem)stack.func_77973_b();
                StackableContainer c = item.openContainer(player, (IInventory)player.field_71071_by, this.container.func_75139_a(slot).getSlotIndex(), stack, openStackId);
                if (c != null) {
                    this.container.addContainer(player, item.getPreferreredStack(this.container, openStackId), c);
                } else if (this.isClient()) {
                    this.gui.overrideFailed = true;
                }
                return true;
            }
            if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150462_ai) && !Common.disableCraftingGui) {
                this.container.addContainer(player, openStackId, new CraftingContainer(player));
                return true;
            }
        }
        return false;
    }

    @Override
    public int getSlotCount() {
        if (this.inventory == null) {
            return 0;
        }
        return this.inventory.func_70302_i_();
    }

    @Override
    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
    }

    @Override
    public IInventory getInventory(EntityPlayer player) {
        return this.inventory;
    }

    @Override
    public int getRowSize() {
        return 9;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        if (Common.loadKeyBinding != null && keyCode == Common.loadKeyBinding.keyBinding.func_151463_i()) {
            Common.channel.sendToServer(new PacketHandler.OpenEditorWindow("loadbackpack", Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? 1 : 0, false));
            return true;
        }
        return false;
    }
}

