/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.common.ContainerStack;
import brad16840.common.ContainerStackGui;
import brad16840.common.MessageChannel;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class StackableContainer {
    public ContainerStack container;
    @SideOnly(value=Side.CLIENT)
    public ContainerStackGui gui;
    public int stackId;
    public ArrayList<String> idChain;
    public int guiWidth = 0;
    public int guiHeight = 0;

    public StackableContainer(int width, int height) {
        this.guiWidth = width;
        this.guiHeight = height;
        this.idChain = new ArrayList();
    }

    public final boolean setAndInitContainer(EntityPlayer player, ContainerStack container) {
        this.container = container;
        return this.initContainer(player);
    }

    public abstract boolean initContainer(EntityPlayer var1);

    public abstract int getSlotCount();

    public abstract void onClosed(EntityPlayer var1);

    public void onUnload(EntityPlayer player) {
    }

    public abstract ItemStack transferStackInSlot(EntityPlayer var1, Slot var2, ContainerSlotInterface var3);

    public boolean customRightClick(EntityPlayer player, int slot, boolean holdingShift) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public final void initGui(ContainerStackGui gui) {
        this.gui = gui;
    }

    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
    }

    @SideOnly(value=Side.CLIENT)
    public void actionPerformed(ContainerButton button) {
    }

    @SideOnly(value=Side.CLIENT)
    public void confirmClicked(boolean accepted) {
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void drawBackground(int var1, int var2);

    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int x, int y) {
    }

    public void addItemStackTooltip(List list, ItemStack itemStack) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseDown(int x, int y, int button) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseDragged(int x, int y, int button) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseUp(int x, int y, int button) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseWheel(int x, int y, int wheel) {
        return false;
    }

    public boolean tryRightClickServer(EntityPlayer player, int slot, boolean holdingShift) {
        return false;
    }

    public abstract String getId();

    public void addSlotToContainer(ContainerStack.ContainerSection section, ContainerSlotInterface slot) {
        this.container.addSlotToContainer(this, section, slot);
    }

    public abstract int getRowSize();

    public abstract boolean static_refreshInventories(EntityPlayer var1, ArrayList<StackableContainer> var2);

    public abstract void static_saveInventories(EntityPlayer var1, ArrayList<StackableContainer> var2);

    @SideOnly(value=Side.CLIENT)
    public void static_addItemStackTooltip(List list, ItemStack itemStack) {
    }

    public boolean chainContains(String uuid, boolean getOther) {
        int originalStackId = this.stackId;
        if (getOther) {
            for (int i = 0; i < this.container.stacks.length; ++i) {
                if (this.container.stacks[i].isEmpty()) {
                    return false;
                }
                if (i == this.stackId) continue;
                StackableContainer c = this.container.getContainer(i);
                Iterator<String> iterator = c.idChain.iterator();
                while (iterator.hasNext()) {
                    if (!uuid.equals(iterator.next())) continue;
                    this.stackId = originalStackId;
                    return true;
                }
            }
        } else {
            if (this.container.stacks[this.stackId].isEmpty()) {
                return false;
            }
            StackableContainer c = this.container.getContainer(this.stackId);
            Iterator<String> iterator = c.idChain.iterator();
            while (iterator.hasNext()) {
                if (!uuid.equals(iterator.next())) continue;
                this.stackId = originalStackId;
                return true;
            }
        }
        this.stackId = originalStackId;
        return false;
    }

    public boolean customRightClickOnEmpty() {
        return false;
    }

    public boolean isClient() {
        return MessageChannel.getEffectiveSide() == Side.CLIENT;
    }

    public class ContainerSlot
    extends Slot
    implements ContainerSlotInterface {
        public int stackId;
        public EntityPlayer player;
        public boolean canEditInventory;

        public ContainerSlot(EntityPlayer player, IInventory inventory, int par2, int par3, int par4) {
            super(inventory, par2, par3, par4);
            this.player = player;
            this.stackId = StackableContainer.this.stackId;
            this.canEditInventory = true;
            if (inventory instanceof UniqueItemInventory) {
                String uuid = ((UniqueItemInventory)inventory).uuid;
                this.canEditInventory = UniqueItemData.get(player.field_70170_p).hasRequiredPermission(player, uuid, 2);
            }
        }

        @Override
        public Slot getSlot() {
            return this;
        }

        @Override
        public int getStackId() {
            return this.stackId;
        }

        public boolean func_82869_a(EntityPlayer player) {
            return this.canTakeStack(player, false);
        }

        @Override
        public boolean canTakeStack(EntityPlayer player, boolean forRightClick) {
            if (!this.canEditInventory) {
                return forRightClick;
            }
            String uuid = UniqueItem.getIdentifier(super.func_75211_c());
            if (uuid.equals("none") || forRightClick) {
                return true;
            }
            return !this.chainContains(uuid, true);
        }

        public boolean func_75214_a(ItemStack stack) {
            if (!this.canEditInventory) {
                return false;
            }
            String uuid = UniqueItem.getIdentifier(stack);
            if (uuid.equals("none")) {
                return true;
            }
            return !this.chainContains(uuid, false);
        }

        public ItemStack func_75211_c() {
            ItemStack stack = super.func_75211_c();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof UniqueItem.UpdatableItem) {
                ((UniqueItem.UpdatableItem)stack.func_77973_b()).updateItemStack(this, stack);
            }
            return stack;
        }

        @Override
        public boolean chainContains(String uuid, boolean getOther) {
            return StackableContainer.this.chainContains(uuid, getOther);
        }
    }

    public static interface ContainerSlotInterface {
        public boolean chainContains(String var1, boolean var2);

        public boolean canTakeStack(EntityPlayer var1, boolean var2);

        public int getStackId();

        public Slot getSlot();
    }

    @SideOnly(value=Side.CLIENT)
    public class ContainerTextField {
        public int stackId;
        public int xPos;
        public int yPos;
        public int width;
        public int height;
        public int borderX;
        public int borderY;
        public int textColor;
        public int disabledTextColor;
        public int maxLength;
        public boolean canLoseFocus;
        public boolean disabled = false;
        private GuiTextField textField;
        private FontRenderer fontRenderer;
        public boolean rightClickClear = false;
        public ContainerStack.Callback clearListener = null;
        private int lastClickX;
        private int lastClickY;
        private long lastClickTime;
        private int localId;

        public ContainerTextField(int localId, FontRenderer fontRenderer, int x, int y, int w, int h) {
            this.xPos = x;
            this.yPos = y;
            this.width = w;
            this.height = h;
            this.fontRenderer = fontRenderer;
            this.stackId = StackableContainer.this.stackId;
            this.canLoseFocus = true;
            this.textColor = -1;
            this.disabledTextColor = -1;
            this.maxLength = 32;
            this.updateTextBox();
        }

        public void mouseClicked(int x, int y, int button) {
            if (this.disabled) {
                return;
            }
            if (x < this.xPos && x >= this.xPos - this.borderX) {
                x = this.xPos;
            }
            if (x >= this.xPos + this.width && x < this.xPos + this.width + this.borderX) {
                x = this.xPos + this.width - 1;
            }
            if (y < this.yPos && y >= this.yPos - this.borderY) {
                y = this.yPos;
            }
            if (y >= this.yPos + this.height && y < this.yPos + this.height + this.borderY) {
                y = this.yPos + this.height - 1;
            }
            long time = Minecraft.func_71386_F();
            if (x == this.lastClickX && y == this.lastClickY && time - this.lastClickTime < 600L) {
                int j;
                String text = this.getText();
                int i = this.textField.func_146198_h();
                if (i > text.length()) {
                    i = text.length();
                }
                for (j = i; j > 0 && text.substring(j - 1, j).matches("[\\w]"); --j) {
                }
                while (i < text.length() && text.substring(i, i + 1).matches("[\\w]")) {
                    ++i;
                }
                this.setCursorPosition(i);
                this.setSelectionPosition(j);
                return;
            }
            this.lastClickX = x;
            this.lastClickY = y;
            this.lastClickTime = time;
            if (this.rightClickClear && button == 1) {
                this.setText("");
                this.setFocused(true);
                if (this.clearListener != null) {
                    this.clearListener.call();
                }
                return;
            }
            this.textField.func_146192_a(x, y, button);
        }

        public boolean isMouseOver(int x, int y) {
            if (this.disabled) {
                return false;
            }
            if (x < this.xPos && x >= this.xPos - this.borderX) {
                x = this.xPos;
            }
            if (x >= this.xPos + this.width && x < this.xPos + this.width + this.borderX) {
                x = this.xPos + this.width - 1;
            }
            if (y < this.yPos && y >= this.yPos - this.borderY) {
                y = this.yPos;
            }
            if (y >= this.yPos + this.height && y < this.yPos + this.height + this.borderY) {
                y = this.yPos + this.height - 1;
            }
            return x >= this.xPos && y >= this.yPos && x <= this.xPos + this.width && y <= this.yPos + this.height;
        }

        public void drawBackground() {
            this.textField.func_146194_f();
        }

        public void setCanLoseFocus(boolean canLoseFocus) {
            this.canLoseFocus = canLoseFocus;
            this.textField.func_146205_d(canLoseFocus);
        }

        public void updateTextBox() {
            GuiTextField old = this.textField;
            this.textField = new GuiTextField(this.localId, this.fontRenderer, this.xPos, this.yPos, this.width, this.height);
            this.setTextColor(this.textColor);
            this.setDisabledTextColor(this.disabledTextColor);
            this.setCanLoseFocus(this.canLoseFocus);
            this.setMaxStringLength(this.maxLength);
            this.textField.func_146185_a(false);
            if (old != null) {
                this.setFocused(old.func_146206_l());
                this.setText(old.func_146179_b());
            } else {
                this.setText("");
            }
        }

        public StackableContainer getOwner() {
            return StackableContainer.this;
        }

        public void setMaxStringLength(int length) {
            this.maxLength = length;
            this.textField.func_146203_f(length);
        }

        public void setFocused(boolean focused) {
            this.textField.func_146195_b(focused);
        }

        public void setText(String text) {
            this.textField.func_146180_a(text);
        }

        public boolean keyPressed(char key, int keyCode) {
            return this.textField.func_146201_a(key, keyCode);
        }

        public String getText() {
            return this.textField.func_146179_b();
        }

        public boolean isFocused() {
            return this.textField.func_146206_l();
        }

        public void setTextColor(int color) {
            this.textColor = color;
            this.textField.func_146193_g(color);
        }

        public void setDisabledTextColor(int color) {
            this.disabledTextColor = color;
            this.textField.func_146204_h(color);
        }

        public void resetScroll() {
            this.textField.func_146190_e(0);
        }

        public void setCursorPosition(int pos) {
            this.textField.func_146190_e(pos - this.width / this.fontRenderer.func_78256_a("  "));
            this.textField.func_146190_e(pos + this.width / this.fontRenderer.func_78256_a("  "));
            this.textField.func_146190_e(pos);
            this.textField.func_146190_e(pos);
        }

        public void setSelectionPosition(int pos) {
            this.textField.func_146199_i(pos);
        }

        public int getCursorPosition() {
            return this.textField.func_146198_h();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class ContainerButton
    extends GuiButton {
        public ContainerStack.Callback callback;
        public int stackId;
        public long hoveringTime;
        public ArrayList<String> tooltip;

        public ContainerButton(int par1, int par2, int par3, int par4, int par5, String par6Str) {
            this(par1, par2, par3, par4, par5, par6Str, null, -1);
        }

        public ContainerButton(int par1, int par2, int par3, int par4, int par5, String par6Str, ContainerStack.Callback callback) {
            this(par1, par2, par3, par4, par5, par6Str, callback, -1);
        }

        public ContainerButton(int par1, int par2, int par3, int par4, int par5, String par6Str, ContainerStack.Callback callback, int maxWidth) {
            super(par1, par2, par3, par4, par5, par6Str);
            this.hoveringTime = -1L;
            this.tooltip = null;
            if (maxWidth > 0 && this.field_146120_f > maxWidth) {
                this.field_146128_h += (this.field_146120_f - maxWidth) / 2;
                this.field_146120_f = maxWidth;
            }
            this.callback = callback;
            this.stackId = StackableContainer.this.stackId;
        }

        public void clicked() {
            if (this.callback != null) {
                this.callback.call();
            }
        }

        public ContainerButton setCallback(ContainerStack.Callback callback) {
            this.callback = callback;
            return this;
        }

        public StackableContainer getOwner() {
            return StackableContainer.this;
        }

        public boolean func_146116_c(Minecraft minecraft, int x, int y) {
            boolean isMouseOver = super.func_146116_c(minecraft, x, y);
            if (isMouseOver) {
                long time = Minecraft.func_71386_F();
                if (this.hoveringTime == -1L) {
                    this.hoveringTime = time;
                } else if (time - this.hoveringTime > 600L && StackableContainer.this.gui != null && this.tooltip != null) {
                    StackableContainer.this.gui.tooltips.clear();
                    StackableContainer.this.gui.tooltips.addAll(this.tooltip);
                }
            } else {
                this.hoveringTime = -1L;
            }
            return isMouseOver;
        }
    }

    public static abstract class SimpleContainer
    extends StackableContainer {
        public SimpleContainer(int width, int height) {
            super(width, height);
        }

        @Override
        public void onClosed(EntityPlayer player) {
        }

        @Override
        public String getId() {
            return "none";
        }

        @Override
        public int getSlotCount() {
            return 0;
        }

        @Override
        public int getRowSize() {
            return 0;
        }

        @Override
        public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
            return true;
        }

        @Override
        public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        }

        @Override
        public ItemStack transferStackInSlot(EntityPlayer player, Slot slot, ContainerSlotInterface containerSlot) {
            return ItemStack.field_190927_a;
        }
    }
}

