/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks.gui;

import brad16840.backpacks.InventoryScanner;
import brad16840.backpacks.PacketHandler;
import brad16840.backpacks.blocks.QuantumChest;
import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.gui.BackpackContainer;
import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import brad16840.common.gui.CraftingContainer;
import brad16840.common.gui.ImageButton;
import brad16840.common.permissions.PacketHandler;
import brad16840.common.permissions.gui.ClientState;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class QuantumContainer
extends StackableContainer
implements ContainerStack.LoadableContainer {
    public UniqueItemInventory inventory;
    public ArrayList<String> idChain;
    public String chestId;
    public ArrayList<EntityPlayer> players;
    public String name = "???";
    private int width;
    private int height;
    private QuantumChestTileEntity.VirtualQuantumChest chest;

    public QuantumContainer(int width, int height, String chestId, UniqueItemInventory inventory, ArrayList<String> parentsIdChain) {
        super(14 + width * 18, 24 + height * 18 + 22);
        this.width = width;
        this.height = height;
        this.inventory = inventory;
        this.chestId = chestId;
        this.idChain = new ArrayList<String>(parentsIdChain);
        this.players = new ArrayList();
    }

    private boolean refreshContainer(EntityPlayer player) {
        this.chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, this.chestId);
        if (this.chest == null) {
            new Translatable("problem.quantumbackpack404", new Object[0]).log(player);
            return false;
        }
        if (!this.chest.canPlayerUse(player)) {
            UniqueItemData.permissionError("use", QuantumChest.name).log(player);
            return false;
        }
        this.inventory.refreshInventory();
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        NBTTagCompound tag = data.getItemData(player, this.inventory.getIdentifier());
        if (tag == null) {
            new Translatable("problem.quantumproxypermission", new Object[0]).log(player);
            return false;
        }
        if (tag.func_74764_b("custom-name")) {
            this.name = tag.func_74779_i("custom-name");
        } else {
            int color = tag.func_74762_e("color");
            if (!tag.func_74764_b("color")) {
                color = 3;
            }
            this.name = new ItemStack((Item)Common.backpack, 1, color).func_82833_r();
        }
        return true;
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        if (!this.refreshContainer(player)) {
            return false;
        }
        this.onOpened(player);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.addSlotToContainer(ContainerStack.ContainerSection.CHEST, new QuantumSlot(player, this, this.inventory, x + y * this.width, 8 + x * 18, 18 + y * 18 + this.getOffset()));
            }
        }
        return true;
    }

    @Override
    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        for (StackableContainer container1 : containers) {
            if (((QuantumContainer)container1).refreshContainer(player)) continue;
            return false;
        }
        return true;
    }

    public boolean isValidSize() {
        if (this.inventory == null) {
            return false;
        }
        this.inventory.refreshInventory();
        if (this.width != this.inventory.width) {
            return false;
        }
        return this.height == this.inventory.height;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        final int cachedStackId = this.stackId;
        this.gui.addButton(new StackableContainer.ContainerButton(0, 0, this.container.layout.isTop(this.stackId) ? 0 : this.guiHeight - 20, this.guiWidth, 20, this.gui.getBackButtonText(this), new ContainerStack.Callback(){

            @Override
            public void call() {
                QuantumContainer.this.gui.closeContainer(cachedStackId);
            }
        }, 68));
        if (this.width > 5 && UniqueItemData.get(Minecraft.func_71410_x().field_71439_g.field_70170_p).hasRequiredPermission((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.getId(), 2)) {
            this.gui.addButton(new ImageButton((StackableContainer)this, 1, this.guiWidth - 24, this.container.layout.isTop(this.stackId) ? 7 : this.guiHeight - 20, 23, 13, BackpackContainer.texture, 0, 78).setCallback(new ContainerStack.Callback(){

                @Override
                public void call() {
                    Common.channel.sendToServer(new PacketHandler.SortBackpack(QuantumContainer.this.getId()));
                }
            }));
        }
    }

    public boolean inventoryHasLink(EntityPlayer player, IInventory inventory) {
        if (inventory == null) {
            return false;
        }
        if (this.container.fromChest) {
            return true;
        }
        for (int j = 0; j < inventory.func_70302_i_(); ++j) {
            ItemStack stack = inventory.func_70301_a(j);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof QuantumBackpack) {
                if (QuantumBackpack.getInfo(stack).equals(this.chestId)) {
                    return true;
                }
                return true;
            }
            if (!(stack.func_77973_b() instanceof UniqueItem.ContainerItem)) continue;
            String guid = UniqueItem.getIdentifier(stack);
            if (!this.inventoryHasLink(player, UniqueItemInventory.createInventory(stack.func_77973_b(), player, guid))) continue;
            return true;
        }
        return false;
    }

    public void checkPlayers() {
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer player = this.players.get(i);
            if (player != null && !player.field_70128_L && this.inventoryHasLink(player, (IInventory)player.field_71071_by) && player.field_71070_bA instanceof ContainerStack) continue;
            this.players.remove(i);
            --i;
        }
    }

    public void onOpened(EntityPlayer player) {
        if (this.players.contains(player)) {
            return;
        }
        this.inventory.saveInventory();
        this.players.add(player);
    }

    @Override
    public void onUnload(EntityPlayer player) {
        if (this.players.contains(player)) {
            this.players.remove(player);
        }
    }

    @Override
    public void onClosed(EntityPlayer player) {
        if (this.players.contains(player)) {
            this.inventory.saveInventory();
        }
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, Slot slot, StackableContainer.ContainerSlotInterface containerSlot) {
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        if (!data.hasRequiredPermission(player, this.inventory.getIdentifier(), 2)) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = ItemStack.field_190927_a;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            if (itemstack1.func_77973_b() instanceof Backpack) {
                return ItemStack.field_190927_a;
            }
            if (!InventoryScanner.backpackCanAccept(data.getItemData(this.getId(), false), itemstack1)) {
                return ItemStack.field_190927_a;
            }
            if (Common.disableNesting && (itemstack1.func_77973_b() instanceof Backpack || itemstack1.func_77973_b() instanceof QuantumBackpack)) {
                return ItemStack.field_190927_a;
            }
            itemstack = itemstack1.func_77946_l();
            slot.func_75215_d(ItemStack.field_190927_a);
            if (!this.container.mergeItemStack(this, itemstack1, 0, this.inventory.func_70302_i_(), false)) {
                slot.func_75215_d(itemstack1);
                return ItemStack.field_190927_a;
            }
            slot.func_75220_a(itemstack1, itemstack);
            if (itemstack1.func_190916_E() != 0) {
                slot.func_75215_d(itemstack1);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E() || !slot.func_75211_c().func_190926_b() && slot.func_75211_c().func_190916_E() == itemstack.func_190916_E() && this.container.getContainer(containerSlot.getStackId()) == this) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack);
        }
        return itemstack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int mouseX, int mouseY) {
        this.gui.text(this, this.name).truncateString(this.guiWidth - 16).drawString(8, 6 + this.getOffset(), -12566464);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(BackpackContainer.texture);
        int xCovered = 0;
        for (int x = 0; x < this.width; ++x) {
            int offsetX = x == 0 ? 0 : (x == this.width - 1 ? 43 : 25);
            int w = x == 0 || x == this.width - 1 ? 25 : 18;
            int yCovered = 0;
            for (int y = 0; y < this.height; ++y) {
                int offsetY;
                int n = y == 0 ? 0 : (offsetY = y == this.height - 1 ? 53 : 35);
                int h = y == 0 ? 35 : (y == this.height - 1 ? 25 : 18);
                this.gui.drawTexture(this, xCovered, yCovered + this.getOffset(), w, h, offsetX, offsetY);
                yCovered += h;
            }
            xCovered += w;
        }
    }

    @Override
    public String getId() {
        return this.inventory.getIdentifier();
    }

    @Override
    public boolean customRightClick(EntityPlayer player, int slot, boolean holdingShift) {
        Common.channel.sendToServer(new PacketHandler.ServerRightClick(slot, 1, holdingShift != Common.shiftOpensInSameStack, this.container.func_75136_a(player.field_71071_by)));
        if (this.isClient()) {
            this.gui.overrideFailed = true;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        if (keyCode == Common.permissionKey.func_151463_i()) {
            if ((Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) && this.stackId == 0) {
                return false;
            }
            String id = this.getId();
            Common.channel.sendToServer(new PacketHandler.OpenGroup(0, new ClientState.PermissionGroupState(id, "I_" + id, 0, true), true));
            return true;
        }
        if (Common.loaderKeyBinding != null && keyCode == Common.loaderKeyBinding.func_151463_i()) {
            Common.channel.sendToServer(new PacketHandler.OpenEditorWindow("loader", Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? 1 : 0, false));
            return true;
        }
        if (Common.pauseLoaderKeyBinding != null && keyCode == Common.pauseLoaderKeyBinding.func_151463_i()) {
            boolean wasPaused;
            String id = this.getId();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            UniqueItemData data = UniqueItemData.get(player.field_70170_p);
            if (!data.hasRequiredPermission((EntityPlayer)player, id, 2)) {
                UniqueItemData.permissionError("modify", this.name).log((EntityPlayer)player);
                return true;
            }
            NBTTagCompound tag = data.getItemData((EntityPlayer)player, id);
            if (tag == null) {
                return true;
            }
            if (!tag.func_150297_b("collect", 10)) {
                tag.func_74782_a("collect", (NBTBase)new NBTTagCompound());
            }
            tag.func_74757_a("collect-paused", !(wasPaused = (tag = tag.func_74775_l("collect")).func_74767_n("collect-paused")));
            tag.func_74757_a("autoload-paused", false);
            if (!wasPaused && (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157))) {
                tag.func_74757_a("autoload-paused", true);
                new Translatable("message.backpackautoloadpaused", new Object[0]).log((EntityPlayer)player);
            } else {
                new Translatable("message.backpackcollection" + (wasPaused ? "un" : "") + "paused", new Object[0]).log((EntityPlayer)player);
            }
            data.markItemDirty(id);
            Common.channel.sendToServer(new PacketHandler.PauseBackpackAutoCollect(id, !wasPaused, tag.func_74767_n("autoload-paused")));
            return true;
        }
        return false;
    }

    @Override
    public boolean tryRightClickServer(EntityPlayer player, int slot, boolean holdingShift) {
        ItemStack stack = this.container.func_75139_a(slot).func_75211_c();
        int openStackId = this.stackId;
        if (holdingShift && ++openStackId >= this.container.stacks.length) {
            openStackId = 0;
        }
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof Backpack) {
                this.chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, this.chestId);
                if (this.chest != null) {
                    this.inventory.saveInventory();
                    String uuid = UniqueItem.getIdentifier(stack);
                    ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
                    UniqueItemData data = UniqueItemData.get(player.field_70170_p);
                    if (uuid.equals("none") || data.isPermissionDeleted(player, uuid)) {
                        this.container.func_75142_b();
                        uuid = Common.requestInventoryIdentifier(player, this.inventory, this.container.func_75139_a(slot).getSlotIndex());
                        this.inventory.saveInventory();
                        this.container.detectAndIgnoreChanges();
                    }
                    data.subscribePlayer(player, uuid, tags, false);
                    QuantumContainer newContainer = this.chest.openPreparedContainer(player, uuid);
                    if (newContainer != null) {
                        Common.channel.sendToPlayer(player, new PacketHandler.OpenFromQuantum(slot, openStackId, 0, uuid, this.stackId, tags));
                        this.container.addContainer(player, openStackId, newContainer);
                        return true;
                    }
                    if (tags.size() > 0) {
                        ArrayList<Object> t = new ArrayList<Object>();
                        t.add(this.container.func_75139_a(slot).getSlotIndex());
                        t.add(uuid);
                        Common.channel.sendToPlayer(player, new PacketHandler.InventoryIdResponse(this.inventory.getIdentifier(), t, tags, -1, -1));
                    }
                }
                return true;
            }
            if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150462_ai) && !Common.disableCraftingGui) {
                this.container.saveInventories(player);
                Common.channel.sendToPlayer(player, new PacketHandler.OpenFromQuantum(slot, openStackId, 1, this.chestId, this.stackId, new ArrayList<NBTTagCompound>()));
                this.container.addContainer(player, openStackId, new CraftingContainer(player));
                return true;
            }
            if (stack.func_77973_b() instanceof QuantumBackpack) {
                this.inventory.saveInventory();
                String chestId = QuantumBackpack.getInfo(stack);
                this.chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, chestId);
                if (this.chest == null) {
                    QuantumBackpack.error_chestNotFound.send(player);
                    return true;
                }
                if (!this.chest.canPlayerUse(player)) {
                    UniqueItemData.permissionError("use", QuantumChest.name).send(player);
                    return true;
                }
                QuantumContainer newContainer = this.chest.openPreparedContainer(player, null);
                if (newContainer != null) {
                    ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
                    UniqueItemData.get(player.field_70170_p).subscribePlayer(player, chestId, tags, false);
                    Common.channel.sendToPlayer(player, new PacketHandler.OpenFromQuantum(slot, openStackId, 2, chestId, this.stackId, tags));
                    this.container.addContainer(player, openStackId, newContainer);
                } else {
                    QuantumBackpack.error_chestEmpty.send(player);
                }
                return true;
            }
        }
        return false;
    }

    public boolean openFromServer(EntityPlayer player, int slot, int openStackId, int type, String uuid) {
        ItemStack stack = this.container.func_75139_a(slot).func_75211_c();
        if (type == 0) {
            QuantumChestTileEntity.VirtualQuantumChest chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, this.chestId);
            if (chest != null) {
                if (!UniqueItem.getIdentifier(stack).equals(uuid)) {
                    Common.setInventoryIdentifier(player, this.inventory, this.container.func_75139_a(slot).getSlotIndex(), uuid);
                }
                this.inventory.saveInventory();
                QuantumContainer newContainer = chest.openPreparedContainer(player, uuid);
                if (newContainer != null) {
                    this.container.addContainer(player, openStackId, newContainer);
                    return true;
                }
            }
        } else {
            if (type == 1 && !Common.disableCraftingGui) {
                this.container.saveInventories(player);
                this.container.addContainer(player, openStackId, new CraftingContainer(player));
                return true;
            }
            if (type == 2) {
                this.inventory.saveInventory();
                QuantumChestTileEntity.VirtualQuantumChest chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, uuid);
                if (chest == null) {
                    QuantumBackpack.error_chestNotFound.log(player);
                    return false;
                }
                if (!chest.canPlayerUse(player)) {
                    UniqueItemData.permissionError("use", QuantumChest.name).log(player);
                    return true;
                }
                QuantumContainer newContainer = chest.openPreparedContainer(player, null);
                if (newContainer == null) {
                    QuantumBackpack.error_chestEmpty.log(player);
                    return false;
                }
                this.container.addContainer(player, openStackId, newContainer);
                return true;
            }
        }
        return false;
    }

    public int getOffset() {
        if (this.container.layout.isTop(this.stackId)) {
            return 22;
        }
        return 0;
    }

    @Override
    public int getSlotCount() {
        return this.width * this.height;
    }

    @Override
    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        for (StackableContainer container1 : containers) {
            container1.onClosed(player);
        }
    }

    @Override
    public int getRowSize() {
        return this.width;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public class QuantumSlot
    extends StackableContainer.ContainerSlot {
        public QuantumSlot(EntityPlayer player, StackableContainer container, UniqueItemInventory inventory, int par2, int par3, int par4) {
            StackableContainer stackableContainer = container;
            stackableContainer.getClass();
            super(player, inventory, par2, par3, par4);
        }

        @Override
        public boolean canTakeStack(EntityPlayer player, boolean forRightClick) {
            if (!forRightClick && QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, QuantumContainer.this.chestId).getUserCount(UniqueItem.getIdentifier(super.func_75211_c()), new HashSet<String>()) > 0) {
                QuantumContainer.this.container.theClientMayBeOutofSync = true;
                return false;
            }
            return super.canTakeStack(player, forRightClick);
        }

        @Override
        public boolean func_75214_a(ItemStack stack) {
            if (Common.disableNesting && (stack.func_77973_b() instanceof Backpack || stack.func_77973_b() instanceof QuantumBackpack)) {
                return false;
            }
            if (!InventoryScanner.backpackCanAccept(UniqueItemData.get(((UniqueItemInventory)this.field_75224_c).world).getItemData(QuantumContainer.this.getId(), false), stack)) {
                return false;
            }
            return super.func_75214_a(stack);
        }
    }
}

