/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks.blocks;

import brad16840.backpacks.PacketHandler;
import brad16840.backpacks.blocks.BackpackBlockTileEntity;
import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.BackpackCommand;
import brad16840.common.Common;
import brad16840.common.PacketHandler;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BackpackBlock
extends BlockContainer {
    public static final PropertyDirection DIRECTION = PropertyDirection.func_177714_a((String)"facing");
    public String field_149770_b;
    public static Translatable name;
    public static boolean _canDuplicate;
    public static boolean canDuplicate;
    protected static final AxisAlignedBB BACKPACK_EAST_AABB;
    protected static final AxisAlignedBB BACKPACK_WEST_AABB;
    protected static final AxisAlignedBB BACKPACK_SOUTH_AABB;
    protected static final AxisAlignedBB BACKPACK_NORTH_AABB;

    public BackpackBlock(String unlocalizedName) {
        super(Material.field_151575_d);
        this.field_149770_b = unlocalizedName;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DIRECTION, (Comparable)EnumFacing.NORTH));
        this.func_149663_c(unlocalizedName);
        this.func_149711_c(0.01f);
        name = new Translatable("tile." + unlocalizedName + ".name", new Object[0]);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)DIRECTION, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)DIRECTION)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIRECTION});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        EnumFacing l = (EnumFacing)state.func_177229_b((IProperty)DIRECTION);
        if (l == EnumFacing.SOUTH) {
            return BACKPACK_SOUTH_AABB;
        }
        if (l == EnumFacing.WEST) {
            return BACKPACK_WEST_AABB;
        }
        if (l == EnumFacing.EAST) {
            return BACKPACK_EAST_AABB;
        }
        return BACKPACK_NORTH_AABB;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean p_185477_7_) {
        BackpackBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)world, pos));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World par1World, BlockPos pos) {
        return super.func_176196_c(par1World, pos);
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        return ret;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return false;
        }
        BackpackBlockTileEntity tileEntity = (BackpackBlockTileEntity)world.func_175625_s(pos);
        if (tileEntity == null) {
            return world.func_175698_g(pos);
        }
        ItemStack backpack = tileEntity.getBackpack();
        if (!backpack.func_190926_b()) {
            if (!tileEntity.hasBackpackDropped && !backpack.func_190926_b()) {
                this.dropItem(world, backpack, pos);
            } else if (!backpack.func_190926_b()) {
                this.dropItem(world, new ItemStack(Items.field_151061_bv), pos);
            }
            tileEntity.hasBackpackDropped = false;
            tileEntity.backpack = ItemStack.field_190927_a;
            tileEntity.updateBackpackType();
        }
        return world.func_175698_g(pos);
    }

    public void dropItem(World world, ItemStack itemstack, BlockPos pos) {
        float f = world.field_73012_v.nextFloat() * 0.4f + 0.1f;
        float f1 = world.field_73012_v.nextFloat() * 0.4f + 0.1f;
        float f2 = world.field_73012_v.nextFloat() * 0.4f + 0.1f;
        while (itemstack.func_190916_E() > 0) {
            int k1 = world.field_73012_v.nextInt(21) + 10;
            if (k1 > itemstack.func_190916_E()) {
                k1 = itemstack.func_190916_E();
            }
            EntityItem entityitem = new EntityItem(world, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), new ItemStack(itemstack.func_77973_b(), k1, itemstack.func_77960_j()));
            float f3 = 0.05f;
            entityitem.func_174867_a(10);
            entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
            entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
            if (itemstack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d(itemstack.func_77978_p().func_74737_b());
            }
            itemstack.func_190917_f(-k1);
            world.func_72838_d((Entity)entityitem);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        BackpackBlockTileEntity tileEntity = (BackpackBlockTileEntity)world.func_175625_s(pos);
        if (tileEntity != null) {
            ItemStack itemstack = tileEntity.getBackpack();
            if (!itemstack.func_190926_b() && !tileEntity.hasBackpackDropped) {
                this.dropItem(world, itemstack, pos);
            } else if (!itemstack.func_190926_b()) {
                this.dropItem(world, new ItemStack(Items.field_151061_bv), pos);
            }
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        String id;
        String uuid;
        if (world.field_72995_K) {
            return true;
        }
        BackpackBlockTileEntity tileEntity = (BackpackBlockTileEntity)world.func_175625_s(pos);
        if (tileEntity == null) {
            new Translatable("problem.corrupttileentity", name).send(player);
            return true;
        }
        ItemStack backpack = tileEntity.getBackpack();
        if (!UniqueItem.hasIdentifier(backpack) && !backpack.func_190926_b() && backpack.func_77973_b() instanceof UniqueItem) {
            if (!UniqueItem.hasIdentifier(backpack) || UniqueItemData.get(player.field_70170_p).isPermissionDeleted(player, UniqueItem.getIdentifier(backpack))) {
                uuid = UUID.randomUUID().toString();
                if (Common.restrictBackpackCreation && backpack.func_77973_b() instanceof Backpack) {
                    UniqueItemData data = UniqueItemData.get(world);
                    String existingUuid = BackpackCommand.getPlayerUuid(data, player.func_70005_c_());
                    if (existingUuid == null) {
                        existingUuid = uuid;
                        data.setPlayerId(player.func_70005_c_(), uuid);
                    }
                    uuid = existingUuid;
                }
                UniqueItem.setIdentifier(player, backpack, uuid);
                Common.channel.sendToPlayer(player, new PacketHandler.SetBackpackBlockId(new brad16840.common.BlockPos(pos), UniqueItem.getIdentifier(backpack)));
            } else {
                uuid = UniqueItem.getIdentifier(backpack);
                if (((UniqueItem)backpack.func_77973_b()).hasUniqueData() && !UniqueItemData.get((World)player.field_70170_p).items.containsKey(uuid)) {
                    UniqueItem.setIdentifier(player, backpack, uuid);
                    Common.channel.sendToPlayer(player, new PacketHandler.SetBackpackBlockId(new brad16840.common.BlockPos(pos), UniqueItem.getIdentifier(backpack)));
                }
            }
        }
        uuid = UniqueItem.getIdentifier(backpack);
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            if ((stack = stack.func_77946_l()).func_77973_b() == Items.field_151061_bv) {
                if (tileEntity.hasBackpackDropped) {
                    new Translatable("problem.alreadydropped", new Object[0]).send(player);
                } else if (backpack.func_190926_b()) {
                    new Translatable("problem.backpackisempty", new Object[0]).send(player);
                } else {
                    tileEntity.hasBackpackDropped = !canDuplicate;
                    this.dropItem(world, backpack.func_77946_l(), pos);
                    stack.func_190917_f(-1);
                    if (stack.func_190916_E() < 1) {
                        stack = ItemStack.field_190927_a;
                    }
                    player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, stack);
                }
                return true;
            }
            if ((stack.func_77973_b() == Common.backpack || stack.func_77973_b() == Common.quantumBackpack) && backpack.func_190926_b()) {
                backpack = stack.func_77946_l();
                backpack.func_190920_e(1);
                tileEntity.backpack = backpack;
                tileEntity.hasBackpackDropped = false;
                stack.func_190917_f(-1);
                if (stack.func_190916_E() < 1) {
                    stack = ItemStack.field_190927_a;
                }
                player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, stack);
                tileEntity.updateBackpackType();
                return true;
            }
        }
        if (backpack.func_190926_b() || !(backpack.func_77973_b() instanceof UniqueItem.OpenableItem)) {
            new Translatable("problem.backpackisempty", new Object[0]).send(player);
            return true;
        }
        if (backpack.func_77973_b() instanceof QuantumBackpack) {
            uuid = QuantumBackpack.getInfo(backpack);
        }
        ArrayList<Object> ids = new ArrayList<Object>();
        int count = 0;
        ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        data.subscribePlayer(player, uuid, tags, true);
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack s = player.field_71071_by.func_70301_a(i);
            if (s.func_190926_b() || !(s.func_77973_b() instanceof UniqueItem)) continue;
            if (!UniqueItem.hasIdentifier(s) && (id = Common.requestInventoryIdentifier(player, (IInventory)player.field_71071_by, i)) != null) {
                ++count;
                ids.add(i);
                ids.add(id);
            }
            if (((UniqueItem)s.func_77973_b()).hasUniqueData()) {
                data.subscribePlayer(player, Common.requestInventoryIdentifier(player, (IInventory)player.field_71071_by, i), tags, true);
                continue;
            }
            if (!(s.func_77973_b() instanceof QuantumBackpack)) continue;
            data.subscribePlayer(player, QuantumBackpack.getInfo(s), tags, true);
        }
        if (!tags.isEmpty() || !ids.isEmpty()) {
            Common.channel.sendToPlayer(player, new PacketHandler.InventoryIdResponse("none", ids, tags, -1, -1));
        }
        NBTTagCompound tag = null;
        if (uuid.startsWith("@")) {
            QuantumChestTileEntity.VirtualQuantumChest t = QuantumChestTileEntity.VirtualQuantumChest.getChest(world, uuid);
            if (t != null && (id = t.getBackpackId(world, player.func_70005_c_())) != null) {
                tag = data.getItemData(id, false);
            }
        } else {
            tag = data.getItemData(uuid, false);
        }
        if (tag != null) {
            boolean changed = false;
            if (tag.func_74764_b("custom-name") && !tag.func_74779_i("custom-name").equals(backpack.func_82833_r())) {
                backpack.func_151001_c(tag.func_74779_i("custom-name"));
                changed = true;
            } else if (!tag.func_74764_b("custom-name") && backpack.func_82837_s()) {
                backpack.func_77978_p().func_82580_o("display");
                changed = true;
            }
            int color = tag.func_74762_e("color");
            if (!tag.func_74764_b("color")) {
                color = 3;
            }
            if (backpack.func_77973_b() instanceof QuantumBackpack) {
                color = backpack.func_77960_j() == 0 ? 0 : ++color;
            }
            if (backpack.func_77960_j() != color) {
                backpack.func_77964_b(color);
                changed = true;
            }
            if (changed) {
                tileEntity.updateBackpackType();
            }
        }
        Common.proxy.guiItem = backpack;
        if (tileEntity.inactivePipeEntity != null && !tileEntity.allowFrontPipe && data.strictlyHasRequiredPermission(world, player.func_70005_c_(), uuid, 2)) {
            String currentEntity = tileEntity.getFrontPipeEntityName();
            if (tileEntity.inactivePipeEntity != null && tileEntity.inactivePipeEntity.equals(currentEntity)) {
                tileEntity.allowFrontPipe = true;
                tileEntity.func_70296_d();
            }
            tileEntity.inactivePipeEntity = null;
        }
        ((UniqueItem.OpenableItem)backpack.func_77973_b()).open(player, backpack, player.field_70170_p);
        return true;
    }

    public TileEntity func_149915_a(World par1World, int var2) {
        BackpackBlockTileEntity tileEntity = new BackpackBlockTileEntity();
        return tileEntity;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block == Blocks.field_150431_aC && (Integer)iblockstate.func_177229_b((IProperty)BlockSnow.field_176315_a) < 1) {
            side = EnumFacing.UP;
        } else if (!block.func_176200_f((IBlockAccess)world, pos) && side != null) {
            pos = pos.func_177972_a(side);
        }
        if (side == null || side.func_176740_k() == EnumFacing.Axis.Y) {
            return false;
        }
        if (stack.func_190916_E() == 0) {
            return false;
        }
        if (!player.func_175151_a(pos, side, stack)) {
            return false;
        }
        if (pos.func_177956_o() >= 255) {
            return false;
        }
        if (world.func_190527_a((Block)this, pos, false, side, (Entity)null)) {
            TileEntity entity;
            IBlockState state = this.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, side.func_176745_a(), (EntityLivingBase)player, hand);
            if (!world.func_180501_a(pos, state, 3)) {
                return true;
            }
            state = world.func_180495_p(pos);
            if (state.func_177230_c() == this) {
                ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                this.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            }
            if ((entity = world.func_175625_s(pos)) != null || !(entity instanceof BackpackBlockTileEntity)) {
                BackpackBlockTileEntity tileEntity = (BackpackBlockTileEntity)entity;
                tileEntity.backpack = stack.func_77946_l();
                tileEntity.backpack.func_190920_e(1);
                tileEntity.hasBackpackDropped = false;
                tileEntity.updateBackpackType();
                SoundType soundtype = state.func_177230_c().func_185467_w();
                world.func_184133_a((EntityPlayer)null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                stack.func_190917_f(-1);
            } else {
                world.func_175698_g(pos);
            }
            return true;
        }
        return false;
    }

    static {
        _canDuplicate = true;
        BACKPACK_EAST_AABB = new AxisAlignedBB(0.0, 0.1484375, 0.265625, 0.2734375, 0.8515625, 0.734375);
        BACKPACK_WEST_AABB = new AxisAlignedBB(0.7265625, 0.1484375, 0.265625, 1.0, 0.8515625, 0.734375);
        BACKPACK_SOUTH_AABB = new AxisAlignedBB(0.265625, 0.1484375, 0.0, 0.734375, 0.8515625, 0.2734375);
        BACKPACK_NORTH_AABB = new AxisAlignedBB(0.265625, 0.1484375, 0.7265625, 0.734375, 0.8515625, 1.0);
    }
}

