/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spaceprojector;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.GuiItemScreen;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.gui.Scrollable;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.varia.BlockMeta;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.spaceprojector.PacketGetChamberInfo;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GuiChamberDetails
extends GuiItemScreen {
    private static final int CHAMBER_XSIZE = 390;
    private static final int CHAMBER_YSIZE = 210;
    private static Map<BlockMeta, Integer> items = null;
    private static Map<BlockMeta, Integer> costs = null;
    private static Map<String, Integer> entities = null;
    private static Map<String, Integer> entityCosts = null;
    private WidgetList blockList;
    private Label infoLabel;
    private Label info2Label;

    public GuiChamberDetails() {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, 390, 210, RFTools.GUI_MANUAL_MAIN, "chambercard");
        this.requestChamberInfoFromServer();
    }

    public static void setItemsWithCount(Map<BlockMeta, Integer> items, Map<BlockMeta, Integer> costs, Map<String, Integer> entities, Map<String, Integer> entityCosts) {
        GuiChamberDetails.items = new HashMap<BlockMeta, Integer>(items);
        GuiChamberDetails.costs = new HashMap<BlockMeta, Integer>(costs);
        GuiChamberDetails.entities = new HashMap<String, Integer>(entities);
        GuiChamberDetails.entityCosts = new HashMap<String, Integer>(entityCosts);
    }

    private void requestChamberInfoFromServer() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetChamberInfo());
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.blockList = new WidgetList(this.field_146297_k, (Gui)this);
        Slider listSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(10)).setVertical().setScrollable((Scrollable)this.blockList);
        Panel listPanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(3)).addChild((Widget)this.blockList)).addChild((Widget)listSlider);
        this.infoLabel = new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.infoLabel.setDesiredWidth(380).setDesiredHeight(14);
        this.info2Label = new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.info2Label.setDesiredWidth(380).setDesiredHeight(14);
        AbstractContainerWidget toplevel = ((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)((VerticalLayout)new VerticalLayout().setSpacing(1)).setVerticalMargin(3)).addChild((Widget)listPanel)).addChild((Widget)this.infoLabel)).addChild((Widget)this.info2Label);
        toplevel.setBounds(new Rectangle(this.guiLeft, this.guiTop, this.xSize, this.ySize));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private void populateLists() {
        this.blockList.removeChildren();
        if (items == null) {
            return;
        }
        int totalCost = 0;
        for (Map.Entry<BlockMeta, Integer> entry : items.entrySet()) {
            BlockMeta bm = entry.getKey();
            int count = entry.getValue();
            int cost = costs.get(bm);
            Panel panel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(16);
            ItemStack stack = new ItemStack(bm.getBlock(), 0, (int)bm.getMeta());
            BlockRender blockRender = new BlockRender(this.field_146297_k, (Gui)this).setRenderItem((Object)stack).setOffsetX(-1).setOffsetY(-1);
            Label nameLabel = new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setColor(StyleConfig.colorTextInListNormal);
            if (stack.func_77973_b() == null) {
                nameLabel.setText("?").setDesiredWidth(160);
            } else {
                nameLabel.setText(stack.func_82833_r()).setDesiredWidth(160);
            }
            Label countLabel = new Label(this.field_146297_k, (Gui)this).setText(String.valueOf(count)).setColor(StyleConfig.colorTextInListNormal);
            countLabel.setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setDesiredWidth(50);
            Label costLabel = new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal);
            costLabel.setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
            if (cost == -1) {
                costLabel.setText("NOT MOVABLE!");
            } else {
                costLabel.setText("Move Cost " + cost + " RF");
                totalCost += cost;
            }
            ((Panel)((Panel)((Panel)panel.addChild((Widget)blockRender)).addChild((Widget)nameLabel)).addChild((Widget)countLabel)).addChild((Widget)costLabel);
            this.blockList.addChild((Widget)panel);
        }
        int totalCostEntities = 0;
        RenderHelper.rot += 0.5f;
        for (Map.Entry<String, Integer> entry : entities.entrySet()) {
            String className = entry.getKey();
            Class<?> aClass = null;
            try {
                aClass = Class.forName(className);
            }
            catch (ClassNotFoundException panel) {
                // empty catch block
            }
            int count = entry.getValue();
            int cost = entityCosts.get(className);
            Panel panel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(16);
            Entity entity = null;
            try {
                entity = (Entity)aClass.getConstructor(World.class).newInstance(this.field_146297_k.field_71441_e);
            }
            catch (InstantiationException countLabel) {
            }
            catch (IllegalAccessException countLabel) {
            }
            catch (InvocationTargetException countLabel) {
            }
            catch (NoSuchMethodException countLabel) {
                // empty catch block
            }
            BlockRender blockRender = new BlockRender(this.field_146297_k, (Gui)this).setRenderItem(entity).setOffsetX(-1).setOffsetY(-1);
            Label nameLabel = new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
            nameLabel.setText(aClass.getSimpleName()).setDesiredWidth(160);
            Label countLabel = new Label(this.field_146297_k, (Gui)this).setText(String.valueOf(count));
            countLabel.setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setDesiredWidth(50);
            Label costLabel = new Label(this.field_146297_k, (Gui)this);
            costLabel.setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
            if (cost == -1) {
                costLabel.setText("NOT MOVABLE!");
            } else {
                costLabel.setText("Move Cost " + cost + " RF");
                totalCostEntities += cost;
            }
            ((Panel)((Panel)((Panel)panel.addChild((Widget)blockRender)).addChild((Widget)nameLabel)).addChild((Widget)countLabel)).addChild((Widget)costLabel);
            this.blockList.addChild((Widget)panel);
        }
        this.infoLabel.setText("Total cost blocks: " + totalCost + " RF");
        this.info2Label.setText("Total cost entities: " + totalCostEntities + " RF");
    }

    public void func_73863_a(int xSize_lo, int ySize_lo, float par3) {
        super.func_73863_a(xSize_lo, ySize_lo, par3);
        this.populateLists();
        this.drawWindow();
    }
}

