/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.FileVersion;
import hardcorequesting.QuestingData;
import hardcorequesting.SaveHelper;
import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiEditMenuReputationSetting;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestDataTask;
import hardcorequesting.quests.QuestTask;
import hardcorequesting.reputation.Reputation;
import hardcorequesting.reputation.ReputationMarker;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;

public abstract class QuestTaskReputation
extends QuestTask {
    private ReputationSetting[] settings = new ReputationSetting[0];
    private static final int OFFSET_Y = 27;
    private final int startOffsetY;

    public ReputationSetting[] getSettings() {
        return this.settings;
    }

    public void setSetting(int id, ReputationSetting setting) {
        if (id >= this.settings.length) {
            this.settings = Arrays.copyOf(this.settings, this.settings.length + 1);
            SaveHelper.add(SaveHelper.EditType.REPUTATION_TASK_CREATE);
        } else {
            SaveHelper.add(SaveHelper.EditType.REPUTATION_TASK_CHANGE);
        }
        this.settings[id] = setting;
    }

    public QuestTaskReputation(Quest parent, String description, String longDescription, int startOffsetY) {
        super(parent, description, longDescription);
        this.startOffsetY = startOffsetY;
    }

    protected boolean isPlayerInRange(EntityPlayer player) {
        if (this.settings.length > 0) {
            QuestDataTask data = this.getData(player);
            if (!data.completed && !player.field_70170_p.field_72995_K) {
                String name = QuestingData.getUserName(player);
                for (ReputationSetting setting : this.settings) {
                    if (setting.isValid(name)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void save(DataWriter dw) {
        dw.writeData(this.settings.length, DataBitHelper.REPUTATION_SETTING);
        for (ReputationSetting setting : this.settings) {
            dw.writeData(setting.getReputation().getId(), DataBitHelper.REPUTATION);
            dw.writeBoolean(setting.lower != null);
            if (setting.lower != null) {
                dw.writeData(setting.lower.getId(), DataBitHelper.REPUTATION_MARKER);
            }
            dw.writeBoolean(setting.upper != null);
            if (setting.upper != null) {
                dw.writeData(setting.upper.getId(), DataBitHelper.REPUTATION_MARKER);
            }
            dw.writeBoolean(setting.inverted);
        }
    }

    @Override
    public void load(DataReader dr, FileVersion version) {
        int count = dr.readData(DataBitHelper.REPUTATION_SETTING);
        this.settings = new ReputationSetting[count];
        for (int i = 0; i < count; ++i) {
            Reputation reputation = Reputation.getReputation(dr.readData(DataBitHelper.REPUTATION));
            ReputationMarker lower = dr.readBoolean() ? reputation.getMarker(dr.readData(DataBitHelper.REPUTATION_MARKER)) : null;
            ReputationMarker upper = dr.readBoolean() ? reputation.getMarker(dr.readData(DataBitHelper.REPUTATION_MARKER)) : null;
            boolean inverted = dr.readBoolean();
            this.settings[i] = new ReputationSetting(reputation, lower, upper, inverted);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, EntityPlayer player, int mX, int mY) {
        String info = null;
        int size = Quest.isEditing ? Math.min(this.settings.length + 1, DataBitHelper.REPUTATION_SETTING.getMaximum()) : this.settings.length;
        for (int i = 0; i < size; ++i) {
            gui.applyColor(-1);
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            if (i >= this.settings.length) {
                gui.drawRect(180, 95 + this.startOffsetY + i * 27 + 5, 0, 101, 125, 3);
                continue;
            }
            ReputationSetting setting = this.settings[i];
            info = setting.reputation.draw(gui, 180, 95 + this.startOffsetY + i * 27, mX, mY, info, this.getPlayerForRender(player), true, setting.lower, setting.upper, setting.inverted, null, null, this.getData((EntityPlayer)player).completed);
        }
        if (info != null) {
            gui.drawMouseOver(info, mX + gui.getLeft(), mY + gui.getTop());
        }
    }

    protected EntityPlayer getPlayerForRender(EntityPlayer player) {
        return player;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        if (Quest.isEditing && gui.getCurrentMode() != EditMode.NORMAL) {
            int size = Math.min(this.settings.length + 1, DataBitHelper.REPUTATION_SETTING.getMaximum());
            for (int i = 0; i < size; ++i) {
                if (!gui.inBounds(180, 95 + this.startOffsetY + i * 27, 125, 20, mX, mY)) continue;
                if (gui.getCurrentMode() == EditMode.REPUTATION_TASK) {
                    gui.setEditMenu(new GuiEditMenuReputationSetting(gui, player, this, i, i >= this.settings.length ? null : this.settings[i]));
                    break;
                }
                if (gui.getCurrentMode() != EditMode.DELETE || i >= this.settings.length) break;
                this.removeSetting(i);
                SaveHelper.add(SaveHelper.EditType.REPUTATION_TASK_REMOVE);
                break;
            }
        }
    }

    public void removeSetting(int i) {
        int id = 0;
        ReputationSetting[] settings = new ReputationSetting[this.settings.length - 1];
        for (int j = 0; j < this.settings.length; ++j) {
            if (j == i) continue;
            settings[id] = this.settings[j];
            ++id;
        }
        this.settings = settings;
    }

    @Override
    public void onUpdate(EntityPlayer player, DataReader dr) {
    }

    @Override
    public float getCompletedRatio(String playerName) {
        int count = this.settings.length;
        if (count == 0) {
            return 0.0f;
        }
        int valid = 0;
        for (ReputationSetting setting : this.settings) {
            if (!setting.isValid(playerName)) continue;
            ++valid;
        }
        return (float)valid / (float)count;
    }

    @Override
    public void mergeProgress(String playerName, QuestDataTask own, QuestDataTask other) {
        if (other.completed) {
            own.completed = true;
        }
    }

    @Override
    public void autoComplete(String playerName) {
        this.getData((String)playerName).completed = true;
    }

    public static class ReputationSetting {
        private Reputation reputation;
        private ReputationMarker lower;
        private ReputationMarker upper;
        private boolean inverted;

        public ReputationSetting(Reputation reputation, ReputationMarker lower, ReputationMarker upper, boolean inverted) {
            this.reputation = reputation;
            this.lower = lower;
            this.upper = upper;
            this.inverted = inverted;
        }

        public Reputation getReputation() {
            return this.reputation;
        }

        public ReputationMarker getLower() {
            return this.lower;
        }

        public ReputationMarker getUpper() {
            return this.upper;
        }

        public boolean isInverted() {
            return this.inverted;
        }

        public boolean isValid(String playerName) {
            if (this.getReputation() == null || !this.getReputation().isValid()) {
                return false;
            }
            ReputationMarker current = this.getReputation().getCurrentMarker(this.getReputation().getValue(playerName));
            return !(this.lower != null && this.lower.getValue() > current.getValue() || this.upper != null && current.getValue() > this.upper.getValue()) != this.inverted;
        }

        public void setLower(ReputationMarker lower) {
            this.lower = lower;
        }

        public void setUpper(ReputationMarker upper) {
            this.upper = upper;
        }
    }
}

