/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.appeng;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridHost;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.google.common.base.Preconditions;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.inventory.legacy.ItemDistribution;
import openmods.reflection.ReflectionHelper;
import openmods.utils.InventoryUtils;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.Env;
import openperipheral.api.adapter.method.Optionals;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.architecture.IArchitectureAccess;
import openperipheral.api.converter.IConverter;
import openperipheral.api.helpers.Index;
import openperipheral.integration.appeng.AdapterGridBase;
import openperipheral.integration.appeng.CraftingCallback;
import openperipheral.integration.vanilla.ItemFingerprint;

public class AdapterInterface
extends AdapterGridBase {
    private final Class<?> CLASS = ReflectionHelper.getClass((String)"appeng.tile.misc.TileInterface");

    public Class<?> getTargetClass() {
        return this.CLASS;
    }

    public String getSourceId() {
        return "me_interface";
    }

    @ScriptCallable(description="Requests the specified item to get crafted.")
    public void requestCrafting(IActionHost host, @Env(value="access") IArchitectureAccess access, @Env(value="converter") IConverter converter, @Arg(name="fingerprint", description="Details of the item you want to craft. Can be found with .getStackInSlot on inventory and .getAvailableItems on AE network") ItemFingerprint needle, @Optionals @Arg(name="qty", description="The quantity of items you want to craft") Long quantity, @Arg(name="cpu", description="The name of the CPU you want to use") String wantedCpuName) {
        ICraftingGrid craftingGrid = this.getCraftingGrid((IGridHost)host);
        if (quantity == null) {
            quantity = 1L;
        }
        ICraftingCPU wantedCpu = AdapterInterface.findCpu(craftingGrid, wantedCpuName);
        IStorageGrid storageGrid = this.getStorageGrid((IGridHost)host);
        IMEMonitor monitor = storageGrid.getItemInventory();
        IAEItemStack stack = AdapterInterface.findCraftableStack((IItemList<IAEItemStack>)storageGrid.getItemInventory().getStorageList(), needle);
        Preconditions.checkArgument((stack != null ? 1 : 0) != 0, (String)"Can't find craftable item fingerprint %s", (Object[])new Object[]{needle});
        IAEItemStack toCraft = stack.copy();
        toCraft.setStackSize(quantity.longValue());
        CraftingCallback craftingCallback = new CraftingCallback(access, converter, craftingGrid, (IMEMonitor<IAEItemStack>)monitor, host, wantedCpu, toCraft);
        TileEntity tileEntity = (TileEntity)host;
        craftingGrid.beginCraftingJob(tileEntity.func_145831_w(), this.getGrid((IGridHost)host), (BaseActionSource)new MachineSource(host), toCraft, (ICraftingCallback)craftingCallback);
    }

    @ScriptCallable(description="Returns true when the interface can export to side.", returnTypes={ReturnType.BOOLEAN})
    public boolean canExport(IGridHost tileEntityInterface, @Arg(name="direction", description="Location of target inventory") ForgeDirection direction) {
        return AdapterInterface.getNeighborInventory(tileEntityInterface, direction) != null;
    }

    @ScriptCallable(description="Exports the specified item into the target inventory.", returnTypes={ReturnType.TABLE})
    public IAEItemStack exportItem(Object tileEntityInterface, @Arg(name="fingerprint", description="Details of the item you want to export (can be result of .getStackInSlot() or .getAvailableItems())") ItemFingerprint needle, @Arg(name="direction", description="Location of target inventory") ForgeDirection direction, @Optionals @Arg(name="maxAmount", description="The maximum amount of items you want to export") Integer maxAmount, @Arg(name="intoSlot", description="The slot in the other inventory that you want to export into") Index intoSlot) {
        IStorageGrid storageGrid;
        IMEMonitor monitor;
        IAEItemStack stack;
        IActionHost host = (IActionHost)tileEntityInterface;
        IInventory neighbor = AdapterInterface.getNeighborInventory(tileEntityInterface, direction);
        Preconditions.checkArgument((neighbor != null ? 1 : 0) != 0, (Object)"No neighbour attached");
        if (intoSlot == null) {
            intoSlot = Index.fromJava((int)-1, (int)0);
        }
        Preconditions.checkArgument(((stack = AdapterInterface.findStack((IItemList<IAEItemStack>)(monitor = (storageGrid = this.getStorageGrid((IGridHost)host)).getItemInventory()).getStorageList(), needle)) != null ? 1 : 0) != 0, (String)"Can't find item fingerprint %s", (Object[])new Object[]{needle});
        IAEItemStack toExtract = stack.copy();
        if (maxAmount == null || maxAmount < 1 || maxAmount > toExtract.getItemStack().func_77976_d()) {
            toExtract.setStackSize((long)toExtract.getItemStack().func_77976_d());
        } else {
            toExtract.setStackSize((long)maxAmount.intValue());
        }
        MachineSource machineSource = new MachineSource(host);
        IAEItemStack extracted = (IAEItemStack)monitor.extractItems((IAEStack)toExtract, Actionable.MODULATE, (BaseActionSource)machineSource);
        if (extracted == null) {
            return null;
        }
        ItemStack toInsert = extracted.getItemStack().func_77946_l();
        if (ItemDistribution.insertItemIntoInventory((IInventory)neighbor, (ItemStack)toInsert, (ForgeDirection)direction.getOpposite(), (int)intoSlot.value)) {
            neighbor.func_70296_d();
        }
        if (toInsert.field_77994_a > 0) {
            IAEItemStack toReturn = AEApi.instance().storage().createItemStack(toInsert);
            monitor.injectItems((IAEStack)toReturn, Actionable.MODULATE, (BaseActionSource)machineSource);
            extracted.decStackSize((long)toInsert.field_77994_a);
        }
        return extracted;
    }

    private static ICraftingCPU findCpu(ICraftingGrid craftingGrid, String cpuName) {
        if (cpuName != null) {
            for (ICraftingCPU cpu : craftingGrid.getCpus()) {
                if (!cpu.getName().equals(cpuName)) continue;
                return cpu;
            }
        }
        return null;
    }

    private static IInventory getNeighborInventory(Object te, ForgeDirection dir) {
        TileEntity tileEntity = (TileEntity)te;
        return InventoryUtils.getInventory((World)tileEntity.func_145831_w(), (int)tileEntity.field_145851_c, (int)tileEntity.field_145848_d, (int)tileEntity.field_145849_e, (ForgeDirection)dir);
    }
}

