/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.tile;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import exnihilo.particles.ParticleSieve;
import exnihilo.registries.SieveRegistry;
import exnihilo.registries.helpers.SiftingResult;
import exnihilo.utils.ItemInfo;
import java.util.Collection;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.handler.VanillaPacketHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StringUtils;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityAutoSieve
extends TileEntity
implements ISidedInventory {
    private static final int UPDATE_INTERVAL = 20;
    private ItemStack[] inventory = new ItemStack[this.func_70302_i_()];
    private ItemStack currentStack;
    private GameProfile customSkin;
    private boolean spawnParticles;
    private int ticksSinceUpdate;
    protected boolean isDirty;
    private float progress;
    private float speedBoost = 1.0f;
    private int speedBoostTicks;

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K && this.spawnParticles) {
            this.spawnFX();
        }
        if (this.speedBoostTicks > 0) {
            --this.speedBoostTicks;
            if (this.speedBoostTicks <= 0) {
                this.speedBoost = 1.0f;
            }
        }
        ++this.ticksSinceUpdate;
        if (this.ticksSinceUpdate > 20) {
            this.spawnParticles = false;
            if (this.isDirty) {
                VanillaPacketHandler.sendTileEntityUpdate(this);
                this.isDirty = false;
            }
            this.ticksSinceUpdate = 0;
        }
        int effectiveEnergy = this.getEffectiveEnergy();
        if (this.getEnergyStored() >= effectiveEnergy) {
            if (this.currentStack == null) {
                if (this.inventory[0] != null && this.isRegistered(this.inventory[0])) {
                    boolean foundSpace = false;
                    for (int i = 1; i < this.inventory.length - 1; ++i) {
                        if (this.inventory[i] != null) continue;
                        foundSpace = true;
                    }
                    if (!foundSpace) {
                        return;
                    }
                    this.currentStack = this.inventory[0].func_77979_a(1);
                    if (this.inventory[0].field_77994_a == 0) {
                        this.inventory[0] = null;
                    }
                    this.setEnergyStored(this.getEnergyStored() - effectiveEnergy);
                    VanillaPacketHandler.sendTileEntityUpdate(this);
                    this.progress = 0.0f;
                }
            } else {
                this.setEnergyStored(this.getEnergyStored() - effectiveEnergy);
                this.progress += this.getEffectiveSpeed();
                this.isDirty = true;
                if (this.progress >= 1.0f) {
                    Collection<SiftingResult> rewards;
                    if (!this.field_145850_b.field_72995_K && (rewards = this.getSiftingOutput(this.currentStack)) != null && !rewards.isEmpty()) {
                        for (SiftingResult reward : rewards) {
                            ItemStack rewardStack;
                            if (this.field_145850_b.field_73012_v.nextInt((int)Math.max(1.0f, (float)reward.rarity / this.getEffectiveLuck())) != 0 || this.addItemToOutput(rewardStack = new ItemStack(reward.item, 1, reward.meta))) continue;
                            EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, rewardStack);
                            double motion = 0.05;
                            entityItem.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * motion;
                            entityItem.field_70181_x = 0.2;
                            entityItem.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * motion;
                            this.field_145850_b.func_72838_d((Entity)entityItem);
                        }
                        this.degradeBook();
                    }
                    this.progress = 0.0f;
                    this.currentStack = null;
                } else {
                    this.spawnParticles = true;
                }
            }
        }
    }

    private boolean addItemToOutput(ItemStack itemStack) {
        int firstEmptySlot = -1;
        for (int i = 1; i < this.func_70302_i_() - 1; ++i) {
            if (this.inventory[i] == null) {
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
                continue;
            }
            if (this.inventory[i].field_77994_a + itemStack.field_77994_a > this.inventory[i].func_77976_d() || !this.inventory[i].func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)this.inventory[i], (ItemStack)itemStack)) continue;
            this.inventory[i].field_77994_a += itemStack.field_77994_a;
            return true;
        }
        if (firstEmptySlot != -1) {
            this.inventory[firstEmptySlot] = itemStack;
            return true;
        }
        return false;
    }

    private void degradeBook() {
        NBTTagList tagList;
        if (this.inventory[21] != null && this.field_145850_b.field_73012_v.nextFloat() <= ExCompressum.autoSieveBookDecay && (tagList = TileEntityAutoSieve.getEnchantmentList(this.inventory[21])) != null) {
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                short id = tagList.func_150305_b(i).func_74765_d("id");
                if (id != Enchantment.field_77346_s.field_77352_x && id != Enchantment.field_77349_p.field_77352_x) continue;
                int level = tagList.func_150305_b(i).func_74765_d("lvl") - 1;
                if (level <= 0) {
                    tagList.func_74744_a(i);
                    break;
                }
                tagList.func_150305_b(i).func_74777_a("lvl", (short)level);
                break;
            }
            if (tagList.func_74745_c() == 0) {
                this.inventory[21] = new ItemStack(Items.field_151122_aG);
            }
        }
    }

    public int getEffectiveEnergy() {
        return ExCompressum.autoSieveEnergy;
    }

    public float getEffectiveSpeed() {
        return ExCompressum.autoSieveSpeed * this.getSpeedBoost();
    }

    public float getEffectiveLuck() {
        if (this.inventory[21] != null) {
            return 1.0f + (float)TileEntityAutoSieve.getEnchantmentLevel(Enchantment.field_77346_s, this.inventory[21]);
        }
        return 1.0f;
    }

    public boolean isRegistered(ItemStack itemStack) {
        return SieveRegistry.registered((Block)Block.func_149634_a((Item)itemStack.func_77973_b()), (int)itemStack.func_77960_j());
    }

    public boolean isValidBook(ItemStack itemStack) {
        return itemStack.func_77973_b() == Items.field_151134_bR && (TileEntityAutoSieve.getEnchantmentLevel(Enchantment.field_77346_s, itemStack) > 0 || TileEntityAutoSieve.getEnchantmentLevel(Enchantment.field_77349_p, itemStack) > 0);
    }

    private static NBTTagList getEnchantmentList(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return null;
        }
        if (itemStack.field_77990_d.func_74764_b("StoredEnchantments")) {
            return itemStack.field_77990_d.func_150295_c("StoredEnchantments", 10);
        }
        if (itemStack.field_77990_d.func_74764_b("ench")) {
            return itemStack.field_77990_d.func_150295_c("ench", 10);
        }
        return null;
    }

    private static int getEnchantmentLevel(Enchantment enchantment, ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        NBTTagList tagList = TileEntityAutoSieve.getEnchantmentList(itemStack);
        if (tagList == null) {
            return 0;
        }
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            short id = tagList.func_150305_b(i).func_74765_d("id");
            short lvl = tagList.func_150305_b(i).func_74765_d("lvl");
            if (id != enchantment.field_77352_x) continue;
            return lvl;
        }
        return 0;
    }

    public Collection<SiftingResult> getSiftingOutput(ItemStack itemStack) {
        return SieveRegistry.getSiftingOutput((ItemInfo)new ItemInfo(itemStack));
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.readFromNBTSynced(tagCompound);
        NBTTagList items = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound itemCompound = items.func_150305_b(i);
            byte slot = itemCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)itemCompound);
        }
    }

    private void readFromNBTSynced(NBTTagCompound tagCompound) {
        this.currentStack = ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("CurrentStack"));
        this.progress = tagCompound.func_74760_g("Progress");
        this.spawnParticles = tagCompound.func_74767_n("Particles");
        if (tagCompound.func_74764_b("CustomSkin")) {
            this.customSkin = NBTUtil.func_152459_a((NBTTagCompound)tagCompound.func_74775_l("CustomSkin"));
            ExCompressum.proxy.preloadSkin(this.customSkin);
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.writeToNBTSynced(tagCompound);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound itemCompound = new NBTTagCompound();
            itemCompound.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(itemCompound);
            items.func_74742_a((NBTBase)itemCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)items);
    }

    private void writeToNBTSynced(NBTTagCompound tagCompound) {
        if (this.currentStack != null) {
            tagCompound.func_74782_a("CurrentStack", (NBTBase)this.currentStack.func_77955_b(new NBTTagCompound()));
        }
        tagCompound.func_74776_a("Progress", this.progress);
        tagCompound.func_74757_a("Particles", this.spawnParticles);
        if (this.customSkin != null) {
            NBTTagCompound customSkinTag = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)customSkinTag, (GameProfile)this.customSkin);
            tagCompound.func_74782_a("CustomSkin", (NBTBase)customSkinTag);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.writeToNBTSynced(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readFromNBTSynced(pkt.func_148857_g());
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnFX() {
        if (this.currentStack != null) {
            IIcon icon = this.currentStack.func_77954_c();
            for (int i = 0; i < 4; ++i) {
                ParticleSieve particle = new ParticleSieve(this.field_145850_b, (double)this.field_145851_c + 0.8 * (double)this.field_145850_b.field_73012_v.nextFloat() + 0.15, (double)this.field_145848_d + 0.69, (double)this.field_145849_e + 0.8 * (double)this.field_145850_b.field_73012_v.nextFloat() + 0.15, 0.0, 0.0, 0.0, icon);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
            }
        }
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21};
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        return this.func_94041_b(slot, itemStack);
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return side != ForgeDirection.UP.ordinal() && side != ForgeDirection.DOWN.ordinal() && side != ForgeDirection.UNKNOWN.ordinal() && slot == 21 || slot >= 1 && slot <= 20;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return slot == 0 && this.isRegistered(itemStack) || slot == 21 && this.isValidBook(itemStack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int func_70302_i_() {
        return 22;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= amount) {
                ItemStack itemStack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemStack;
            }
            ItemStack itemStack = this.inventory[slot].func_77979_a(amount);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return itemStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public abstract void setEnergyStored(int var1);

    public abstract int getMaxEnergyStored();

    public abstract int getEnergyStored();

    public float getEnergyPercentage() {
        return (float)this.getEnergyStored() / (float)this.getMaxEnergyStored();
    }

    public boolean isProcessing() {
        return this.progress > 0.0f;
    }

    public float getProgress() {
        return this.progress;
    }

    public ItemStack getCurrentStack() {
        return this.currentStack;
    }

    public void setCustomSkin(GameProfile customSkin) {
        this.customSkin = customSkin;
        this.grabProfile();
        this.isDirty = true;
        this.func_70296_d();
    }

    public GameProfile getCustomSkin() {
        return this.customSkin;
    }

    private void grabProfile() {
        try {
            GameProfile gameProfile;
            if (!(this.field_145850_b.field_72995_K || this.customSkin == null || StringUtils.func_151246_b((String)this.customSkin.getName()) || this.customSkin.isComplete() && this.customSkin.getProperties().containsKey((Object)"textures") || (gameProfile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(this.customSkin.getName())) == null)) {
                Property property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
                if (property == null) {
                    gameProfile = MinecraftServer.func_71276_C().func_147130_as().fillProfileProperties(gameProfile, true);
                }
                this.customSkin = gameProfile;
                this.isDirty = true;
                this.func_70296_d();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public boolean isActive() {
        return this.spawnParticles;
    }

    public float getSpeedBoost() {
        float activeSpeedBost = this.speedBoost;
        if (this.inventory[21] != null) {
            activeSpeedBost += (float)TileEntityAutoSieve.getEnchantmentLevel(Enchantment.field_77349_p, this.inventory[21]);
        }
        return activeSpeedBost;
    }

    public void setSpeedBoost(int speedBoostTicks, float speedBoost) {
        this.speedBoostTicks = speedBoostTicks;
        this.speedBoost = speedBoost;
        this.isDirty = true;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }
}

