/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import exnihilo.registries.HammerRegistry;
import exnihilo.registries.helpers.Smashable;
import exnihilo.utils.ItemInfo;
import java.util.Collection;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.handler.VanillaPacketHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAutoHammer
extends TileEntity
implements ISidedInventory,
IEnergyHandler {
    private static final int UPDATE_INTERVAL = 20;
    private final EnergyStorage storage = new EnergyStorage(32000);
    private ItemStack[] inventory = new ItemStack[this.func_70302_i_()];
    private ItemStack currentStack;
    private int ticksSinceUpdate;
    private boolean isDirty;
    private float progress;

    public void func_145845_h() {
        ++this.ticksSinceUpdate;
        if (this.ticksSinceUpdate > 20) {
            if (this.isDirty) {
                VanillaPacketHandler.sendTileEntityUpdate(this);
                this.isDirty = false;
            }
            this.ticksSinceUpdate = 0;
        }
        int effectiveEnergy = this.getEffectiveEnergy();
        if (this.storage.getEnergyStored() >= effectiveEnergy) {
            if (this.currentStack == null) {
                if (this.inventory[0] != null && this.isRegistered(this.inventory[0])) {
                    boolean foundSpace = false;
                    for (int i = 1; i < this.inventory.length - 2; ++i) {
                        if (this.inventory[i] != null) continue;
                        foundSpace = true;
                    }
                    if (!foundSpace) {
                        return;
                    }
                    this.currentStack = this.inventory[0].func_77979_a(1);
                    if (this.inventory[0].field_77994_a == 0) {
                        this.inventory[0] = null;
                    }
                    this.storage.extractEnergy(effectiveEnergy, false);
                    VanillaPacketHandler.sendTileEntityUpdate(this);
                    this.progress = 0.0f;
                }
            } else {
                this.storage.extractEnergy(effectiveEnergy, false);
                this.progress += this.getEffectiveSpeed();
                this.isDirty = true;
                if (this.progress >= 1.0f) {
                    if (this.field_145850_b.field_73012_v.nextFloat() <= ExCompressum.autoHammerDecay) {
                        if (this.inventory[21] != null && this.inventory[21].func_96631_a(1, this.field_145850_b.field_73012_v)) {
                            this.inventory[21] = null;
                        }
                        if (this.inventory[22] != null && this.inventory[22].func_96631_a(1, this.field_145850_b.field_73012_v)) {
                            this.inventory[22] = null;
                        }
                    }
                    if (!this.field_145850_b.field_72995_K) {
                        Collection<Smashable> rewards = this.getSmashables(this.currentStack);
                        if (rewards != null && !rewards.isEmpty()) {
                            for (Smashable reward : rewards) {
                                ItemStack rewardStack;
                                if (!(this.field_145850_b.field_73012_v.nextFloat() <= reward.chance + reward.luckMultiplier * this.getEffectiveLuck()) || this.addItemToOutput(rewardStack = new ItemStack(reward.item, 1, reward.meta))) continue;
                                EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, rewardStack);
                                double motion = 0.05;
                                entityItem.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * motion;
                                entityItem.field_70181_x = 0.2;
                                entityItem.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * motion;
                                this.field_145850_b.func_72838_d((Entity)entityItem);
                            }
                        }
                    } else {
                        this.spawnCrushParticles();
                    }
                    this.progress = 0.0f;
                    this.currentStack = null;
                }
            }
        }
    }

    protected Collection<Smashable> getSmashables(ItemStack itemStack) {
        return HammerRegistry.getRewards((ItemInfo)new ItemInfo(itemStack));
    }

    public boolean isRegistered(ItemStack itemStack) {
        return HammerRegistry.registered((ItemStack)itemStack);
    }

    private boolean addItemToOutput(ItemStack itemStack) {
        int firstEmptySlot = -1;
        for (int i = 1; i < this.func_70302_i_() - 2; ++i) {
            if (this.inventory[i] == null) {
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
                continue;
            }
            if (this.inventory[i].field_77994_a + itemStack.field_77994_a > this.inventory[i].func_77976_d() || !this.inventory[i].func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)this.inventory[i], (ItemStack)itemStack)) continue;
            this.inventory[i].field_77994_a += itemStack.field_77994_a;
            return true;
        }
        if (firstEmptySlot != -1) {
            this.inventory[firstEmptySlot] = itemStack;
            return true;
        }
        return false;
    }

    public int getEffectiveEnergy() {
        return ExCompressum.autoHammerEnergy;
    }

    public float getSpeedBoost() {
        float boost = 1.0f;
        if (this.inventory[21] != null && this.isHammerUpgrade(this.inventory[21])) {
            boost += 1.0f;
        }
        if (this.inventory[22] != null && this.isHammerUpgrade(this.inventory[22])) {
            boost += 1.0f;
        }
        return boost;
    }

    public float getEffectiveSpeed() {
        return ExCompressum.autoHammerSpeed * this.getSpeedBoost();
    }

    public float getEffectiveLuck() {
        return 0.0f;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.storage.readFromNBT(tagCompound);
        NBTTagList items = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound itemCompound = items.func_150305_b(i);
            byte slot = itemCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)itemCompound);
        }
    }

    private void readFromNBTSynced(NBTTagCompound tagCompound) {
        this.currentStack = ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("CurrentStack"));
        this.progress = tagCompound.func_74760_g("Progress");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.writeToNBTSynced(tagCompound);
        this.storage.writeToNBT(tagCompound);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound itemCompound = new NBTTagCompound();
            itemCompound.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(itemCompound);
            items.func_74742_a((NBTBase)itemCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)items);
    }

    private void writeToNBTSynced(NBTTagCompound tagCompound) {
        if (this.currentStack != null) {
            tagCompound.func_74782_a("CurrentStack", (NBTBase)this.currentStack.func_77955_b(new NBTTagCompound()));
        }
        tagCompound.func_74776_a("Progress", this.progress);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.writeToNBTSynced(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readFromNBTSynced(pkt.func_148857_g());
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnCrushParticles() {
        if (this.currentStack != null) {
            for (int i = 0; i < 10; ++i) {
                EntityDiggingFX particle = new EntityDiggingFX(this.func_145831_w(), (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.3125, (double)this.field_145849_e + 0.5, 0.0, 0.0, 0.0, Block.func_149634_a((Item)this.currentStack.func_77973_b()), this.currentStack.func_77960_j());
                particle.func_70016_h(this.field_145850_b.field_73012_v.nextDouble() / 2.0 - 0.25, 0.0, this.field_145850_b.field_73012_v.nextDouble() / 2.0 - 0.25);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
            }
        }
    }

    @Override
    public int receiveEnergy(ForgeDirection side, int maxReceive, boolean simulate) {
        if (!simulate) {
            this.isDirty = true;
        }
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection side, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection side) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection side) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection side) {
        return true;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22};
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        return this.func_94041_b(slot, itemStack);
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return slot >= 1;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return slot == 0 && this.isRegistered(itemStack) || (slot == 21 || slot == 22) && this.isHammerUpgrade(itemStack);
    }

    public boolean isHammerUpgrade(ItemStack itemStack) {
        return itemStack.func_77973_b() == GameRegistry.findItem((String)"exnihilo", (String)"hammer_diamond");
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int func_70302_i_() {
        return 23;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= amount) {
                ItemStack itemStack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemStack;
            }
            ItemStack itemStack = this.inventory[slot].func_77979_a(amount);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return itemStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void setEnergyStored(int energyStored) {
        this.storage.setEnergyStored(energyStored);
    }

    public boolean isProcessing() {
        return this.progress > 0.0f;
    }

    public float getProgress() {
        return this.progress;
    }

    public float getEnergyPercentage() {
        return (float)this.storage.getEnergyStored() / (float)this.storage.getMaxEnergyStored();
    }

    public ItemStack getCurrentStack() {
        return this.currentStack;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }
}

