/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.registry.GameRegistry;
import exnihilo.registries.HammerRegistry;
import exnihilo.registries.helpers.Smashable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.registry.data.ItemAndMetadata;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public class CompressedHammerRegistry {
    private static final Multimap<ItemAndMetadata, Smashable> smashables = ArrayListMultimap.create();

    private static void register(Block source, int sourceMeta, Item output, int outputMeta, float chance, float luckMultiplier) {
        Smashable entry = new Smashable(source, sourceMeta, output, outputMeta, chance, luckMultiplier);
        smashables.put((Object)new ItemAndMetadata(source, sourceMeta), (Object)entry);
    }

    public static Collection<Smashable> getSmashables(Block block, int metadata) {
        return CompressedHammerRegistry.getSmashables(new ItemAndMetadata(block, metadata));
    }

    public static Collection<Smashable> getSmashables(ItemStack itemStack) {
        return CompressedHammerRegistry.getSmashables(new ItemAndMetadata(itemStack));
    }

    public static Collection<Smashable> getSmashables(ItemAndMetadata itemInfo) {
        return smashables.get((Object)itemInfo);
    }

    public static boolean isRegistered(Block block, int metadata) {
        return smashables.containsKey((Object)new ItemAndMetadata(block, metadata));
    }

    public static boolean isRegistered(ItemStack itemStack) {
        return smashables.containsKey((Object)new ItemAndMetadata(itemStack));
    }

    public static Multimap<ItemAndMetadata, Smashable> getSmashables() {
        return smashables;
    }

    private static void register(Block source, int sourceMeta, ItemStack reward, float chance, float luckMultiplier) {
        for (int i = 0; i < reward.field_77994_a; ++i) {
            CompressedHammerRegistry.register(source, sourceMeta, reward.func_77973_b(), reward.func_77960_j(), chance, luckMultiplier);
        }
    }

    public static void load(Configuration config, boolean easyMode) {
        String[] smashables;
        for (String smashable : smashables = config.getStringList("Smashables", "registries", new String[]{"ExtraUtilities:cobblestone_compressed:0=9:minecraft:gravel:0:1:0", "excompressum:compressed_dust:1=9:minecraft:gravel:0:1:0", "ExtraUtilities:cobblestone_compressed:12=9:minecraft:sand:0:1:0", "excompressum:compressed_dust:2=9:minecraft:sand:0:1:0", "ExtraUtilities:cobblestone_compressed:14=9:exnihilo:dust:0:1:0", "excompressum:compressed_dust:3=9:exnihilo:dust:0:1:0"}, "Here you can add additional smashables for the compressed hammers. Format: modid:name:meta=stackSize:modid:name:meta:chance:luckMultiplier")) {
            String[] s = smashable.split("=");
            if (s.length < 2) {
                ExCompressum.logger.error("Skipping smashable " + smashable + " due to invalid format");
                continue;
            }
            String[] source = s[0].split(":");
            if (source[0].equals("ore") && source.length >= 2) {
                String oreName = source[1];
                List ores = OreDictionary.getOres((String)oreName, (boolean)false);
                if (!ores.isEmpty()) {
                    for (ItemStack ore : ores) {
                        if (ore.func_77973_b() instanceof ItemBlock) {
                            CompressedHammerRegistry.loadSmashable(((ItemBlock)ore.func_77973_b()).field_150939_a, ore.func_77973_b().func_77647_b(ore.func_77960_j()), s[1], easyMode);
                            continue;
                        }
                        ExCompressum.logger.error("Skipping smashable " + smashable + " because the source block is not a block");
                    }
                    continue;
                }
                ExCompressum.logger.error("Skipping smashable " + smashable + " because no ore dictionary entries found");
                continue;
            }
            Block sourceBlock = source.length == 1 ? GameRegistry.findBlock((String)"minecraft", (String)source[0]) : GameRegistry.findBlock((String)source[0], (String)source[1]);
            if (sourceBlock == null) {
                ExCompressum.logger.error("Skipping smashable " + smashable + " because the source block was not found");
                continue;
            }
            int sourceMeta = 0;
            if (source.length >= 3) {
                sourceMeta = source[2].equals("*") ? Short.MAX_VALUE : Integer.parseInt(source[2]);
            }
            CompressedHammerRegistry.loadSmashable(sourceBlock, sourceMeta, s[1], easyMode);
        }
    }

    private static void loadSmashable(Block sourceBlock, int sourceMeta, String reward, boolean easyMode) {
        String[] s = reward.split(":");
        if (s.length < 6) {
            ExCompressum.logger.error("Skipping smashable " + reward + " due to invalid format");
            return;
        }
        ItemStack rewardStack = GameRegistry.findItemStack((String)s[1], (String)s[2], (int)Integer.parseInt(s[0]));
        rewardStack.func_77964_b(Integer.parseInt(s[3]));
        if (!easyMode) {
            CompressedHammerRegistry.register(sourceBlock, sourceMeta, rewardStack, Float.parseFloat(s[4]), Float.parseFloat(s[5]));
        } else {
            for (int i = 0; i < rewardStack.field_77994_a; ++i) {
                HammerRegistry.register((Block)sourceBlock, (int)sourceMeta, (Item)rewardStack.func_77973_b(), (int)rewardStack.func_77960_j(), (float)Float.parseFloat(s[4]), (float)Float.parseFloat(s[5]));
            }
        }
    }

    public static Collection<ItemAndMetadata> getSources(ItemStack reward) {
        ArrayList<ItemAndMetadata> results = new ArrayList<ItemAndMetadata>();
        for (Map.Entry entry : smashables.entries()) {
            if (((Smashable)entry.getValue()).item != reward.func_77973_b() || ((Smashable)entry.getValue()).meta != reward.func_77960_j()) continue;
            results.add((ItemAndMetadata)entry.getKey());
        }
        return results;
    }
}

