/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import exnihilo.registries.helpers.Smashable;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.excompressum.registry.CompressedHammerRegistry;
import net.blay09.mods.excompressum.registry.data.ItemAndMetadata;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class RecipeHandlerCompressedHammer
extends TemplateRecipeHandler {
    private static final int SLOTS_PER_PAGE = 9;
    private final Multiset<String> condensedTooltip = HashMultiset.create();

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)166, (int)58);
        Point highlightPoint = ((CachedHammerRecipe)((Object)this.arecipes.get(recipeIndex))).highlightPoint;
        if (highlightPoint != null) {
            GuiDraw.drawTexturedModalRect((int)highlightPoint.x, (int)highlightPoint.y, (int)166, (int)0, (int)18, (int)18);
        }
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack itemStack, List<String> list, int recipeIdx) {
        CachedHammerRecipe recipe = (CachedHammerRecipe)((Object)this.arecipes.get(recipeIdx));
        ItemStack sourceStack = ((PositionedStack)((CachedHammerRecipe)recipe).input.get((int)0)).item;
        if (itemStack != null && itemStack != sourceStack) {
            list.add("Drop Chance:");
            this.condensedTooltip.clear();
            for (Smashable smashable : CompressedHammerRegistry.getSmashables(Block.func_149634_a((Item)sourceStack.func_77973_b()), sourceStack.func_77960_j())) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)itemStack, (ItemStack)new ItemStack(smashable.item, 1, smashable.meta))) continue;
                int chance = (int)(100.0f * smashable.chance);
                int fortune = (int)(100.0f * smashable.luckMultiplier);
                if (fortune > 0) {
                    this.condensedTooltip.add((Object)(Integer.toString(chance) + "%" + EnumChatFormatting.BLUE + " (+" + Integer.toString(fortune) + "% luck bonus)" + EnumChatFormatting.RESET));
                    continue;
                }
                this.condensedTooltip.add((Object)(Integer.toString(chance) + "%"));
            }
            for (String line : this.condensedTooltip.elementSet()) {
                list.add("  * " + this.condensedTooltip.count((Object)line) + "x " + line);
            }
        }
        return list;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(75, 22, 15, 13), "excompressum.compressedHammer", new Object[0]));
    }

    public int recipiesPerPage() {
        return 2;
    }

    public String getGuiTexture() {
        return "exnihilo:textures/hammerNEI.png";
    }

    public String getRecipeName() {
        return "Compressed Hammer";
    }

    public void loadCraftingRecipes(String outputID, Object ... wat) {
        if (!outputID.equals("excompressum.hammer")) {
            super.loadCraftingRecipes(outputID, wat);
            return;
        }
        Multimap<ItemAndMetadata, Smashable> smashables = CompressedHammerRegistry.getSmashables();
        for (ItemAndMetadata sourceInfo : smashables.keySet()) {
            Collection results = smashables.get((Object)sourceInfo);
            HashMultiset countedSet = HashMultiset.create();
            for (Smashable result : results) {
                countedSet.add((Object)new ItemAndMetadata(result.item, result.meta));
            }
            ArrayList resultStacks = Lists.newArrayList();
            for (ItemAndMetadata resultInfo : countedSet.elementSet()) {
                resultStacks.add(resultInfo.createStack(countedSet.count((Object)resultInfo)));
            }
            this.addCached(resultStacks, sourceInfo.createStack(1), null);
        }
    }

    public void loadCraftingRecipes(ItemStack itemStack) {
        Multimap<ItemAndMetadata, Smashable> smashables = CompressedHammerRegistry.getSmashables();
        for (ItemAndMetadata sourceInfo : smashables.keySet()) {
            Collection results = smashables.get((Object)sourceInfo);
            HashMultiset countedSet = HashMultiset.create();
            for (Smashable result : results) {
                countedSet.add((Object)new ItemAndMetadata(result.item, result.meta));
            }
            if (!countedSet.contains((Object)new ItemAndMetadata(itemStack))) continue;
            ArrayList resultStacks = Lists.newArrayList();
            for (ItemAndMetadata resultInfo : countedSet.elementSet()) {
                resultStacks.add(resultInfo.createStack(countedSet.count((Object)resultInfo)));
            }
            this.addCached(resultStacks, sourceInfo.createStack(1), itemStack);
        }
    }

    public void loadUsageRecipes(ItemStack itemStack) {
        HashMultiset countedSet = HashMultiset.create();
        if (!CompressedHammerRegistry.isRegistered(itemStack)) {
            return;
        }
        for (Smashable result : CompressedHammerRegistry.getSmashables(itemStack)) {
            countedSet.add((Object)new ItemAndMetadata(result.item, result.meta));
        }
        ArrayList resultStacks = Lists.newArrayList();
        for (ItemAndMetadata itemInfo : countedSet.elementSet()) {
            resultStacks.add(itemInfo.createStack(countedSet.count((Object)itemInfo)));
        }
        this.addCached(resultStacks, itemStack, itemStack);
    }

    private void addCached(List<ItemStack> resultStacks, ItemStack inputStack, ItemStack highlightStack) {
        int resultCount = resultStacks.size();
        if (resultCount > 9) {
            for (int i = 0; i < resultCount; i += 9) {
                this.arecipes.add(new CachedHammerRecipe(resultStacks.subList(i, Math.min(resultCount, i + 9)), inputStack, highlightStack));
            }
        } else {
            this.arecipes.add(new CachedHammerRecipe(resultStacks, inputStack, highlightStack));
        }
    }

    public class CachedHammerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> input;
        private final List<PositionedStack> outputs;
        private Point highlightPoint;

        public CachedHammerRecipe(List<ItemStack> resultStacks, ItemStack inputStack, ItemStack highlightStack) {
            super((TemplateRecipeHandler)RecipeHandlerCompressedHammer.this);
            this.input = Lists.newArrayList();
            this.outputs = Lists.newArrayList();
            PositionedStack positionedStack = new PositionedStack(inputStack != null ? inputStack : resultStacks, 74, 4);
            positionedStack.setMaxSize(1);
            this.input.add(positionedStack);
            int row = 0;
            int column = 0;
            for (ItemStack resultStack : resultStacks) {
                this.outputs.add(new PositionedStack((Object)resultStack, 3 + 18 * column, 37 + 18 * row));
                if (highlightStack != null && NEIServerUtils.areStacksSameTypeCrafting((ItemStack)highlightStack, (ItemStack)resultStack)) {
                    this.highlightPoint = new Point(2 + 18 * column, 36 + 18 * row);
                }
                if (++column <= 8) continue;
                column = 0;
                ++row;
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(RecipeHandlerCompressedHammer.this.cycleticks / 20, this.input);
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

