/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.registries;

import exnihilo.ENBlocks;
import exnihilo.ENItems;
import exnihilo.Fluids;
import exnihilo.data.ModData;
import exnihilo.registries.helpers.EntityWithItem;
import exnihilo.registries.helpers.FluidItemCombo;
import exnihilo.utils.ItemInfo;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BarrelRecipeRegistry {
    private static HashMap<FluidItemCombo, ItemInfo> recipes = new HashMap();
    private static HashSet<ItemInfo> renderOverride = new HashSet();
    private static HashMap<FluidItemCombo, EntityWithItem> mobRecipes = new HashMap();
    private static HashMap<FluidItemCombo, Fluid> fluidTransformRecipes = new HashMap();

    public static void addFluidItemRecipe(Fluid fluid, ItemStack inputStack, ItemStack outputStack) {
        BarrelRecipeRegistry.addFluidItemRecipe(fluid, inputStack, outputStack, false);
    }

    public static void addFluidItemRecipe(Fluid fluid, ItemStack inputStack, ItemStack outputStack, boolean override) {
        recipes.put(new FluidItemCombo(fluid, inputStack), new ItemInfo(outputStack));
        if (override) {
            renderOverride.add(new ItemInfo(outputStack));
        }
    }

    public static void removeFluidItemRecipe(Fluid fluid, ItemStack inputStack, ItemStack outputStack) {
        recipes.remove(new ItemInfo(outputStack));
        renderOverride.remove(new ItemInfo(outputStack));
    }

    public static ItemInfo getOutput(FluidStack fluid_, ItemStack inputStack) {
        Fluid fluid = fluid_ == null ? null : fluid_.getFluid();
        return recipes.get(new FluidItemCombo(fluid, inputStack));
    }

    public static boolean getShouldRenderOverride(ItemStack stack) {
        return renderOverride.contains(new ItemInfo(stack));
    }

    public static void addMobRecipe(Fluid fluid, ItemStack inputStack, Class entity, String particleName, ItemStack peacefulDrop) {
        mobRecipes.put(new FluidItemCombo(fluid, inputStack), new EntityWithItem(entity, peacefulDrop, particleName));
    }

    public static void removeMobRecipe(Fluid fluid, ItemStack inputStack) {
        mobRecipes.remove(new FluidItemCombo(fluid, inputStack));
    }

    public static EntityWithItem getMobOutput(FluidStack fluid_, ItemStack inputStack) {
        Fluid fluid = fluid_ == null ? null : fluid_.getFluid();
        return mobRecipes.get(new FluidItemCombo(fluid, inputStack));
    }

    public static void addFluidTransformRecipe(Fluid inputFluid, Block inputBlock, int inputMeta, Fluid outputFluid) {
        fluidTransformRecipes.put(new FluidItemCombo(inputFluid, new ItemStack(inputBlock, 1, inputMeta)), outputFluid);
    }

    public static Fluid getFluidTransformRecipeOutput(Fluid inputFluid, Block inputBlock, int inputMeta) {
        return fluidTransformRecipes.get(new FluidItemCombo(inputFluid, new ItemStack(inputBlock, 1, inputMeta)));
    }

    public static void registerBaseRecipes() {
        if (ModData.ALLOW_BARREL_RECIPE_CLAY) {
            BarrelRecipeRegistry.addFluidItemRecipe(FluidRegistry.WATER, new ItemStack(ENBlocks.Dust), new ItemStack(Blocks.field_150435_aG));
        }
        if (ModData.ALLOW_BARREL_RECIPE_NETHERRACK) {
            BarrelRecipeRegistry.addFluidItemRecipe(FluidRegistry.LAVA, new ItemStack(Items.field_151137_ax), new ItemStack(Blocks.field_150424_aL));
        }
        if (ModData.ALLOW_BARREL_RECIPE_ENDSTONE) {
            BarrelRecipeRegistry.addFluidItemRecipe(FluidRegistry.LAVA, new ItemStack(Items.field_151114_aO), new ItemStack(Blocks.field_150377_bs));
        }
        if (ModData.ALLOW_BARREL_RECIPE_SOULSAND) {
            BarrelRecipeRegistry.addFluidItemRecipe(Fluids.fluidWitchWater, new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Blocks.field_150425_aM));
        }
        if (ModData.ALLOW_BARREL_RECIPE_DARK_OAK) {
            BarrelRecipeRegistry.addFluidItemRecipe(Fluids.fluidWitchWater, new ItemStack(Blocks.field_150345_g), new ItemStack(Blocks.field_150345_g, 1, 5), true);
        }
        if (ModData.ALLOW_BARREL_RECIPE_DOUBLE_FLOWERS) {
            BarrelRecipeRegistry.addFluidItemRecipe(Fluids.fluidWitchWater, new ItemStack((Block)Blocks.field_150327_N), new ItemStack((Block)Blocks.field_150398_cm), true);
            BarrelRecipeRegistry.addFluidItemRecipe(Fluids.fluidWitchWater, new ItemStack((Block)Blocks.field_150328_O, 1, 2), new ItemStack((Block)Blocks.field_150398_cm, 1, 1), true);
            BarrelRecipeRegistry.addFluidItemRecipe(Fluids.fluidWitchWater, new ItemStack((Block)Blocks.field_150329_H, 1, 1), new ItemStack((Block)Blocks.field_150398_cm, 1, 2), true);
            BarrelRecipeRegistry.addFluidItemRecipe(Fluids.fluidWitchWater, new ItemStack((Block)Blocks.field_150329_H, 1, 2), new ItemStack((Block)Blocks.field_150398_cm, 1, 3), true);
            BarrelRecipeRegistry.addFluidItemRecipe(Fluids.fluidWitchWater, new ItemStack((Block)Blocks.field_150328_O), new ItemStack((Block)Blocks.field_150398_cm, 1, 4), true);
            BarrelRecipeRegistry.addFluidItemRecipe(Fluids.fluidWitchWater, new ItemStack((Block)Blocks.field_150328_O, 1, 3), new ItemStack((Block)Blocks.field_150398_cm, 1, 5), true);
        }
        BarrelRecipeRegistry.addFluidTransformRecipe(FluidRegistry.WATER, (Block)Blocks.field_150391_bh, 0, Fluids.fluidWitchWater);
        Fluid seedOil = FluidRegistry.getFluid((String)"seedoil");
        if (seedOil != null) {
            BarrelRecipeRegistry.addFluidItemRecipe(seedOil, new ItemStack(ENBlocks.BeeTrap), new ItemStack(ENBlocks.BeeTrapTreated));
        }
        if (ModData.ALLOW_BARREL_RECIPE_BLAZE_RODS) {
            BarrelRecipeRegistry.addMobRecipe(FluidRegistry.LAVA, new ItemStack(ENItems.DollAngry), EntityBlaze.class, "lava", new ItemStack(Items.field_151072_bj));
        }
        if (ModData.ALLOW_BARREL_RECIPE_ENDER_PEARLS) {
            BarrelRecipeRegistry.addMobRecipe(Fluids.fluidWitchWater, new ItemStack(ENItems.DollCreepy), EntityEnderman.class, "portal", new ItemStack(Items.field_151079_bi));
        }
    }
}

