/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.world;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import ftb.lib.FTBLib;
import ftb.lib.LMNBTUtils;
import ftb.lib.api.config.ConfigGroup;
import ftb.utils.api.EventLMPlayerServer;
import ftb.utils.mod.handlers.FTBUChunkEventHandler;
import ftb.utils.net.MessageLMWorldUpdate;
import ftb.utils.world.LMFakeServerPlayer;
import ftb.utils.world.LMPlayer;
import ftb.utils.world.LMPlayerServer;
import ftb.utils.world.LMWorld;
import ftb.utils.world.Warps;
import ftb.utils.world.claims.ClaimedChunks;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import latmod.lib.ByteCount;
import latmod.lib.ByteIOStream;
import latmod.lib.IntList;
import latmod.lib.LMListUtils;
import latmod.lib.LMMapUtils;
import latmod.lib.LMUtils;
import latmod.lib.util.Phase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class LMWorldServer
extends LMWorld {
    public static LMWorldServer inst = null;
    public final File latmodFolder;
    public final HashMap<Integer, LMPlayerServer> playerMap;
    public final Warps warps;
    public final ClaimedChunks claimedChunks;
    public final ConfigGroup customServerData;

    public LMWorldServer(File f) {
        super(Side.SERVER);
        this.latmodFolder = f;
        this.playerMap = new HashMap();
        this.warps = new Warps();
        this.claimedChunks = new ClaimedChunks();
        this.customServerData = new ConfigGroup("custom_server_data");
    }

    @Override
    public Map<Integer, ? extends LMPlayer> playerMap() {
        return this.playerMap;
    }

    @Override
    public World getMCWorld() {
        return FTBLib.getServerWorld();
    }

    @Override
    public LMWorldServer getServerWorld() {
        return this;
    }

    public void close() {
        this.playerMap.clear();
        this.claimedChunks.chunks.clear();
        FTBUChunkEventHandler.instance.clear();
    }

    @Override
    public LMPlayerServer getPlayer(Object o) {
        if (o instanceof FakePlayer) {
            return new LMFakeServerPlayer(this, (FakePlayer)o);
        }
        LMPlayer p = super.getPlayer(o);
        return p == null ? null : p.toPlayerMP();
    }

    public void load(JsonObject group, Phase p) {
        if (p == Phase.PRE) {
            this.warps.readFromJson(group, "warps");
            this.customServerData.func_152753_a(group.get(this.customServerData.getID()));
            this.customCommonData.func_152753_a(group.get(this.customCommonData.getID()));
            this.settings.readFromJson(group.get("settings").getAsJsonObject());
        }
    }

    public void save(JsonObject group, Phase p) {
        if (p == Phase.PRE) {
            this.warps.writeToJson(group, "warps");
            group.add(this.customServerData.getID(), this.customServerData.func_151003_a());
            group.add(this.customCommonData.getID(), this.customCommonData.func_151003_a());
            JsonObject settingsGroup = new JsonObject();
            this.settings.writeToJson(settingsGroup);
            group.add("settings", (JsonElement)settingsGroup);
        }
    }

    public void writeDataToNet(ByteIOStream io, LMPlayerServer self, boolean first) {
        if (first) {
            IntList onlinePlayers = new IntList();
            io.writeInt(this.playerMap.size());
            for (LMPlayerServer p : this.playerMap.values()) {
                io.writeInt(p.getPlayerID());
                io.writeUUID(p.getProfile().getId());
                io.writeUTF(p.getProfile().getName());
                if (!p.isOnline() || p.getPlayerID() == self.getPlayerID()) continue;
                onlinePlayers.add(p.getPlayerID());
            }
            io.writeIntArray(onlinePlayers.toArray(), ByteCount.INT);
            for (int i = 0; i < onlinePlayers.size(); ++i) {
                LMPlayerServer p;
                p = this.playerMap.get(onlinePlayers.get(i));
                p.writeToNet(io, false);
            }
            self.writeToNet(io, true);
        }
        this.customCommonData.write(io);
        this.settings.writeToNet(io);
    }

    public void writePlayersToServer(NBTTagCompound tag) {
        for (LMPlayerServer p : LMMapUtils.values(this.playerMap, null)) {
            NBTTagCompound tag1 = new NBTTagCompound();
            p.writeToServer(tag1);
            new EventLMPlayerServer.DataSaved(p).post();
            tag1.func_74778_a("UUID", p.getStringUUID());
            tag1.func_74778_a("Name", p.getProfile().getName());
            tag.func_74782_a(Integer.toString(p.getPlayerID()), (NBTBase)tag1);
        }
    }

    public void readPlayersFromServer(NBTTagCompound tag) {
        this.playerMap.clear();
        Map map = LMNBTUtils.toMapWithType((NBTTagCompound)tag);
        for (Map.Entry e : map.entrySet()) {
            int id = Integer.parseInt((String)e.getKey());
            NBTTagCompound tag1 = (NBTTagCompound)e.getValue();
            LMPlayerServer p = new LMPlayerServer(this, id, new GameProfile(LMUtils.fromString((String)tag1.func_74779_i("UUID")), tag1.func_74779_i("Name")));
            p.readFromServer(tag1);
            this.playerMap.put(p.getPlayerID(), p);
        }
        for (LMPlayerServer p : this.playerMap.values()) {
            p.onPostLoaded();
        }
    }

    public void update(LMPlayerServer self) {
        new MessageLMWorldUpdate(this, self).sendTo(null);
    }

    public List<LMPlayerServer> getAllOnlinePlayers() {
        ArrayList<LMPlayerServer> l = new ArrayList<LMPlayerServer>();
        for (LMPlayerServer p : this.playerMap.values()) {
            if (!p.isOnline()) continue;
            l.add(p);
        }
        return l;
    }

    public String[] getAllPlayerNames(Boolean online) {
        if (online == null) {
            return new String[0];
        }
        List list = online == Boolean.TRUE ? this.getAllOnlinePlayers() : LMListUtils.clone(this.playerMap.values());
        Collections.sort(list, new Comparator<LMPlayerServer>(){

            @Override
            public int compare(LMPlayerServer o1, LMPlayerServer o2) {
                if (o1.isOnline() == o2.isOnline()) {
                    return o1.getProfile().getName().compareToIgnoreCase(o2.getProfile().getName());
                }
                return Boolean.compare(o2.isOnline(), o1.isOnline());
            }
        });
        return LMListUtils.toStringArray((Collection)list);
    }
}

