/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib;

import ftb.lib.EntityPos;
import ftb.lib.LMDimUtils;
import latmod.lib.LMUtils;
import latmod.lib.MathHelperLM;
import net.minecraft.util.ChunkCoordinates;

public final class BlockDimPos
implements Cloneable {
    public final int x;
    public final int y;
    public final int z;
    public final int dim;

    public BlockDimPos(int px, int py, int pz, int d) {
        this.x = px;
        this.y = py;
        this.z = pz;
        this.dim = d;
    }

    public BlockDimPos(int[] ai) {
        if (ai == null || ai.length < 4) {
            this.x = 0;
            this.y = 256;
            this.z = 0;
            this.dim = 0;
        } else {
            this.x = ai[0];
            this.y = ai[1];
            this.z = ai[2];
            this.dim = ai[3];
        }
    }

    public BlockDimPos(ChunkCoordinates pos, int dim) {
        this(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c, dim);
    }

    public boolean isValid() {
        return this.y >= 0 && this.y < 256;
    }

    public int[] toIntArray() {
        return new int[]{this.x, this.y, this.z, this.dim};
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.x);
        sb.append(',');
        sb.append(this.y);
        sb.append(',');
        sb.append(this.z);
        sb.append(',');
        sb.append(LMDimUtils.getDimName(this.dim));
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return this.equalsPos((BlockDimPos)o);
    }

    public int hashCode() {
        return LMUtils.hashCode(this.x, this.y, this.z, this.dim);
    }

    public EntityPos toEntityPos() {
        return new EntityPos((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, this.dim);
    }

    public BlockDimPos copy() {
        return new BlockDimPos(this.x, this.y, this.z, this.dim);
    }

    public ChunkCoordinates toBlockPos() {
        return new ChunkCoordinates(this.x, this.y, this.z);
    }

    public int chunkX() {
        return MathHelperLM.chunk(this.x);
    }

    public int chunkY() {
        return MathHelperLM.chunk(this.y);
    }

    public int chunkZ() {
        return MathHelperLM.chunk(this.z);
    }

    public boolean equalsPos(BlockDimPos p) {
        if (p == null) {
            return false;
        }
        if (p == this) {
            return true;
        }
        return p.dim == this.dim && p.x == this.x && p.y == this.y && p.z == this.z;
    }
}

