/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.api.AEApi;
import appeng.api.IAppEngApi;
import appeng.api.config.TunnelType;
import appeng.api.features.IP2PTunnelRegistry;
import appeng.api.parts.IPartHelper;
import appeng.integration.IIntegrationModule;
import appeng.integration.IntegrationHelper;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IIC2;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.IC2Items;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.Recipes;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;

public class IC2
implements IIC2,
IIntegrationModule {
    public static IC2 instance;

    public IC2() {
        IntegrationHelper.testClassExistence(this, IEnergyTile.class);
        IntegrationHelper.testClassExistence(this, RecipeInputItemStack.class);
    }

    @Override
    public void init() {
        IAppEngApi api = AEApi.instance();
        IPartHelper partHelper = api.partHelper();
        if (IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.IC2)) {
            partHelper.registerNewLayer("appeng.parts.layers.LayerIEnergySink", "ic2.api.energy.tile.IEnergySink");
            partHelper.registerNewLayer("appeng.parts.layers.LayerIEnergySource", "ic2.api.energy.tile.IEnergySource");
        }
    }

    @Override
    public void postInit() {
        IP2PTunnelRegistry reg = AEApi.instance().registries().p2pTunnel();
        reg.addNewAttunement(this.getItem("copperCableItem"), TunnelType.IC2_POWER);
        reg.addNewAttunement(this.getItem("insulatedCopperCableItem"), TunnelType.IC2_POWER);
        reg.addNewAttunement(this.getItem("goldCableItem"), TunnelType.IC2_POWER);
        reg.addNewAttunement(this.getItem("insulatedGoldCableItem"), TunnelType.IC2_POWER);
        reg.addNewAttunement(this.getItem("ironCableItem"), TunnelType.IC2_POWER);
        reg.addNewAttunement(this.getItem("insulatedIronCableItem"), TunnelType.IC2_POWER);
        reg.addNewAttunement(this.getItem("insulatedTinCableItem"), TunnelType.IC2_POWER);
        reg.addNewAttunement(this.getItem("glassFiberCableItem"), TunnelType.IC2_POWER);
        reg.addNewAttunement(this.getItem("tinCableItem"), TunnelType.IC2_POWER);
        reg.addNewAttunement(this.getItem("detectorCableItem"), TunnelType.IC2_POWER);
        reg.addNewAttunement(this.getItem("splitterCableItem"), TunnelType.IC2_POWER);
    }

    @Override
    public void addToEnergyNet(TileEntity appEngTile) {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)appEngTile));
    }

    @Override
    public void removeFromEnergyNet(TileEntity appEngTile) {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)appEngTile));
    }

    @Override
    public ItemStack getItem(String name) {
        return IC2Items.getItem((String)name);
    }

    @Override
    public void maceratorRecipe(ItemStack in, ItemStack out) {
        Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputItemStack(in, in.field_77994_a), null, new ItemStack[]{out});
    }
}

