/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui.widget;

import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.util.ReadableNumberConverter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.gui.IAspectSelectorGui;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.client.gui.ThEGuiHelper;
import thaumicenergistics.client.gui.widget.AspectWidgetBase;
import thaumicenergistics.client.gui.widget.ThEWidget;
import thaumicenergistics.common.utils.ThEUtils;

@SideOnly(value=Side.CLIENT)
public class WidgetAspectSelector
extends AspectWidgetBase {
    private static final int borderThickness = 1;
    private static final int GRADIENT_COUNT = 15;
    private static final int selectorBorderColor = -16711681;
    private int[] backgroundPulseGradient;
    protected boolean hideAmount = false;

    public WidgetAspectSelector(IAspectSelectorGui selectorGui, IAspectStack stack, int xPos, int yPos, EntityPlayer player) {
        super(selectorGui, stack, xPos, yPos, player);
    }

    private void drawHollowRectWithCorners(int posX, int posY, int width, int height, int color, int thickness) {
        int rightXEnd = posX + width;
        int rightXBegin = rightXEnd - thickness;
        int leftXEnd = posX + thickness;
        int topYEnd = posY + thickness;
        int bottomYEnd = posY + height;
        int bottomYBegin = bottomYEnd - thickness;
        Gui.func_73734_a((int)posX, (int)posY, (int)rightXEnd, (int)bottomYEnd, (int)color);
        Gui.func_73734_a((int)posX, (int)posY, (int)(leftXEnd + 1), (int)(topYEnd + 1), (int)-16711681);
        Gui.func_73734_a((int)rightXEnd, (int)posY, (int)(rightXBegin - 1), (int)(topYEnd + 1), (int)-16711681);
        Gui.func_73734_a((int)rightXEnd, (int)bottomYEnd, (int)(rightXBegin - 1), (int)(bottomYBegin - 1), (int)-16711681);
        Gui.func_73734_a((int)posX, (int)bottomYEnd, (int)(leftXEnd + 1), (int)(bottomYBegin - 1), (int)-16711681);
        Gui.func_73734_a((int)posX, (int)posY, (int)rightXEnd, (int)topYEnd, (int)-16711681);
        Gui.func_73734_a((int)posX, (int)bottomYBegin, (int)rightXEnd, (int)bottomYEnd, (int)-16711681);
        Gui.func_73734_a((int)posX, (int)posY, (int)leftXEnd, (int)bottomYEnd, (int)-16711681);
        Gui.func_73734_a((int)rightXBegin, (int)posY, (int)rightXEnd, (int)bottomYEnd, (int)-16711681);
    }

    private int getBackgroundColor() {
        int time = (int)(System.currentTimeMillis() / 45L);
        int index = Math.abs(Math.abs(time % 30) - 15);
        return this.backgroundPulseGradient[index];
    }

    @Override
    protected void onStackChanged() {
        super.onStackChanged();
        if (!this.hasAspect()) {
            return;
        }
        int aspectColor = this.getStack().getAspect().getColor();
        this.backgroundPulseGradient = ThEGuiHelper.INSTANCE.createColorGradient(0x70000000 | aspectColor, 0x20000000 | aspectColor, 16);
    }

    @Override
    public void drawWidget() {
        if (!this.hasAspect()) {
            return;
        }
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Aspect selectedAspect = ((IAspectSelectorGui)this.hostGUI).getSelectedAspect();
        if (selectedAspect == this.getAspect()) {
            this.drawHollowRectWithCorners(this.xPosition, this.yPosition, ThEWidget.WIDGET_SIZE, ThEWidget.WIDGET_SIZE, this.getBackgroundColor(), 1);
        }
        this.drawAspect();
        long stackSize = this.getAmount();
        if (stackSize > 0L && !this.hideAmount || this.getCraftable()) {
            FontRenderer fontRenderer = this.hostGUI.getFontRenderer();
            boolean unicodeFlag = fontRenderer.func_82883_a();
            fontRenderer.func_78264_a(false);
            boolean largeFont = AEConfig.instance.useTerminalUseLargeFont();
            float scale = largeFont ? 0.85f : 0.5f;
            float positionOffset = largeFont ? 0.0f : -1.0f;
            float posX = (float)this.xPosition + positionOffset + (float)ThEWidget.WIDGET_SIZE;
            float posY = (float)this.yPosition + positionOffset + (float)ThEWidget.WIDGET_SIZE - 1.0f;
            String text = stackSize > 0L && !this.hideAmount ? (largeFont ? ReadableNumberConverter.INSTANCE.toWideReadableForm(stackSize) : ReadableNumberConverter.INSTANCE.toSlimReadableForm(stackSize)) : (largeFont ? GuiText.LargeFontCraft.getLocal() : GuiText.SmallFontCraft.getLocal());
            ThEGuiHelper.drawScaledText(fontRenderer, text, scale, posX, posY);
            fontRenderer.func_78264_a(unicodeFlag);
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    @Override
    public void onMouseClicked() {
        Aspect widgetAspect = this.getAspect();
        Aspect selectedAspect = ((IAspectSelectorGui)this.hostGUI).getSelectedAspect();
        boolean changed = false;
        if (widgetAspect == selectedAspect) {
            if (selectedAspect != null) {
                selectedAspect = null;
                changed = true;
            }
        } else {
            selectedAspect = widgetAspect;
            changed = true;
        }
        if (changed) {
            ThEUtils.playClientSound(null, "gui.button.press");
            ((IAspectSelectorGui)this.hostGUI).getContainer().setSelectedAspect(selectedAspect);
        }
    }

    public void setHideAmount(boolean hide) {
        this.hideAmount = hide;
    }
}

