/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.server.command;

import com.google.common.primitives.Ints;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class CommandSetBiome
implements ICommand {
    private final List<String> aliases = Arrays.asList("btsetbiome", "biometweakersetbiome", "bts", "biometweakers");

    public int compareTo(Object o) {
        if (!(o instanceof ICommand)) {
            return 0;
        }
        return this.func_71517_b().compareTo(((ICommand)o).func_71517_b());
    }

    public String func_71517_b() {
        return "BTSetBiome";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return LanguageRegistry.instance().getStringLocalization("biometweaker.msg.setbiome.usage.text");
    }

    public List func_71514_a() {
        return this.aliases;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        ChunkCoordinates coord = sender.func_82114_b();
        World world = sender.func_130014_f_();
        if (coord != null && world != null) {
            if (args.length < 2 || args.length > 3) {
                sender.func_145747_a(new ChatComponentTranslation("biometweaker.msg.setbiome.invalargs.text", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                return;
            }
            BiomeGenBase gen = null;
            Integer i = Ints.tryParse((String)args[0]);
            if (i != null) {
                gen = BiomeGenBase.func_150568_d((int)i);
            } else {
                for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                    if (biome == null || !biome.field_76791_y.equals(args[0])) continue;
                    gen = biome;
                    break;
                }
            }
            if (gen == null) {
                sender.func_145747_a(new ChatComponentTranslation("biometweaker.msg.setbiome.invalargs.text", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                return;
            }
            i = Ints.tryParse((String)args[1]);
            if (i == null) {
                sender.func_145747_a(new ChatComponentTranslation("biometweaker.msg.setbiome.invalargs.text", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                return;
            }
            boolean blocks = true;
            if (args.length == 3) {
                if (args[2].equalsIgnoreCase("block")) {
                    blocks = true;
                } else if (args[2].equalsIgnoreCase("chunk")) {
                    blocks = false;
                } else {
                    sender.func_145747_a(new ChatComponentTranslation("biometweaker.msg.setbiome.invalargs.text", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                    return;
                }
            }
            int count = 0;
            if (blocks) {
                for (int x = coord.field_71574_a - i; x <= coord.field_71574_a + i; ++x) {
                    for (int z = coord.field_71573_c - i; z <= coord.field_71573_c + i; ++z) {
                        int realX = x & 0xF;
                        int realZ = z & 0xF;
                        Chunk chunk = world.func_72938_d(x, z);
                        chunk.func_76605_m()[realZ * 16 + realX] = (byte)gen.field_76756_M;
                        chunk.func_76630_e();
                        ++count;
                    }
                }
                sender.func_145747_a(new ChatComponentTranslation("biometweaker.msg.setbiome.blocksuccess.text", new Object[]{count, gen.field_76791_y}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GOLD)));
            } else {
                byte[] biomeArray = new byte[256];
                Arrays.fill(biomeArray, (byte)gen.field_76756_M);
                int chunkX = coord.field_71574_a >> 4;
                int chunkZ = coord.field_71573_c >> 4;
                for (int x = chunkX - i; x <= chunkX + i; ++x) {
                    for (int z = chunkZ - i; z <= chunkZ + i; ++z) {
                        Chunk chunk = world.func_72964_e(x, z);
                        chunk.func_76616_a(Arrays.copyOf(biomeArray, biomeArray.length));
                        chunk.func_76630_e();
                        ++count;
                    }
                }
                sender.func_145747_a(new ChatComponentTranslation("biometweaker.msg.setbiome.chunksuccess.text", new Object[]{count, gen.field_76791_y}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GOLD)));
            }
        } else {
            sender.func_145747_a(new ChatComponentTranslation("biometweaker.msg.info.invalsender.text", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
        }
    }

    public boolean func_71519_b(ICommandSender sender) {
        return sender.func_70003_b(MinecraftServer.func_71276_C().func_110455_j(), this.func_71517_b());
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        return null;
    }

    public boolean func_82358_a(String[] p_82358_1_, int p_82358_2_) {
        return false;
    }
}

