/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.superscript.util;

import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.superckl.api.superscript.ScriptHandler;
import me.superckl.api.superscript.ScriptParser;
import me.superckl.api.superscript.util.CollectionHelper;
import me.superckl.api.superscript.util.ParameterType;

public final class ParameterTypes {
    public static final ParameterType JSON_ELEMENT = new ParameterType(){

        @Override
        public Object tryParse(String parameter, ScriptHandler handler) {
            return new JsonPrimitive(parameter);
        }
    };
    public static final ParameterType NON_NEG_BYTE = new ParameterType(){

        @Override
        public Object tryParse(String parameter, ScriptHandler handler) throws Exception {
            Integer i = (Integer)NON_NEG_INTEGER.tryParse(parameter, handler);
            return i == null || i > 127 || i < -128 ? null : Byte.valueOf(i.byteValue());
        }
    };
    public static final ParameterType BYTE = new ParameterType(){

        @Override
        public Object tryParse(String parameter, ScriptHandler handler) throws Exception {
            Integer i = (Integer)INTEGER.tryParse(parameter, handler);
            return i == null || i > 127 || i < -128 ? null : Byte.valueOf(i.byteValue());
        }
    };
    public static final ParameterType FLOAT = new ParameterType(){

        @Override
        public Object tryParse(String parameter, ScriptHandler handler) {
            return Floats.tryParse((String)parameter);
        }
    };
    public static final ParameterType NON_NEG_INTEGERS = new ParameterType(){

        @Override
        public Object tryParse(String parameter, ScriptHandler handler) throws Exception {
            List ints = (List)INTEGERS.tryParse(parameter, handler);
            Iterator it = ints.iterator();
            while (it.hasNext()) {
                if ((Integer)it.next() >= 0) continue;
                it.remove();
            }
            return ints;
        }
    };
    public static final ParameterType NON_NEG_INTEGER = new ParameterType(){

        @Override
        public Object tryParse(String parameter, ScriptHandler handler) {
            Integer i = Ints.tryParse((String)parameter);
            if (i != null && i >= 0) {
                return i;
            }
            return null;
        }
    };
    public static final ParameterType INTEGERS = new ParameterType(){

        @Override
        public Object tryParse(String parameter, ScriptHandler handler) throws Exception {
            ArrayList ints = Lists.newArrayList();
            Object i = INTEGER.tryParse(parameter, handler);
            if (i == null) {
                String[] split;
                if (parameter.contains("-") && (split = parameter.split("-")).length == 2 && ScriptParser.isPositiveInteger(split[0]) && ScriptParser.isPositiveInteger(split[1])) {
                    int start = Integer.parseInt(split[0]);
                    int end = Integer.parseInt(split[1]);
                    int[] values = CollectionHelper.range(start, end);
                    CollectionHelper.addAll(ints, values);
                }
            } else {
                ints.add((Integer)i);
            }
            return ints;
        }
    };
    public static final ParameterType INTEGER = new ParameterType(){

        @Override
        public Object tryParse(String parameter, ScriptHandler handler) {
            return Ints.tryParse((String)parameter);
        }
    };
    public static final ParameterType STRING = new ParameterType(){

        @Override
        public Object tryParse(String parameter, ScriptHandler handler) {
            if (parameter.startsWith("\"") && parameter.endsWith("\"")) {
                return parameter.substring(1, parameter.length() - 1);
            }
            return null;
        }
    };
}

