/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.superscript.object;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import me.superckl.api.superscript.APIInfo;
import me.superckl.api.superscript.ScriptCommandRegistry;
import me.superckl.api.superscript.ScriptHandler;
import me.superckl.api.superscript.ScriptParser;
import me.superckl.api.superscript.command.IScriptCommand;
import me.superckl.api.superscript.command.ScriptCommandListing;
import me.superckl.api.superscript.util.CollectionHelper;
import me.superckl.api.superscript.util.ParameterWrapper;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ScriptObject {
    protected final Map<String, ScriptCommandListing> validCommands = new LinkedHashMap<String, ScriptCommandListing>();

    public ScriptObject() {
        this.validCommands.putAll(ScriptCommandRegistry.INSTANCE.getListings(this.getClass()));
    }

    public void handleCall(String call, ScriptHandler handler) throws Exception {
        String command = ScriptParser.getCommandCalled(call);
        if (!this.validCommands.containsKey(command)) {
            APIInfo.log.error("Failed to find meaning in command " + call + ". It will be ignored.");
            return;
        }
        String[] arguments = CollectionHelper.trimAll(ScriptParser.parseArguments(call));
        ScriptCommandListing listing = this.validCommands.get(command);
        block0: for (Map.Entry entry : listing.getConstructors().entrySet()) {
            ArrayList objs = Lists.newArrayList();
            ArrayList params = Lists.newArrayList((Iterable)entry.getKey());
            Iterator it = params.iterator();
            while (it.hasNext()) {
                ParameterWrapper wrap = (ParameterWrapper)it.next();
                Pair<Object[], String[]> parsed = wrap.parseArgs(handler, arguments);
                if (((Object[])parsed.getKey()).length == 0 && !wrap.canReturnNothing()) continue block0;
                Collections.addAll(objs, (Object[])parsed.getKey());
                arguments = (String[])parsed.getValue();
                it.remove();
            }
            if (!params.isEmpty() || arguments.length != 0) continue;
            IScriptCommand sCommand = (IScriptCommand)entry.getValue().newInstance(objs.toArray());
            if (listing.isPerformInst()) {
                sCommand.perform();
            } else {
                this.addCommand(sCommand);
            }
            return;
        }
        APIInfo.log.error("Failed to find meaning in command " + call + ". It will be ignored.");
    }

    public void readArgs(Object ... args) throws Exception {
    }

    public abstract void addCommand(IScriptCommand var1);

    public Map<String, ScriptCommandListing> getValidCommands() {
        return this.validCommands;
    }
}

