/*
 * Decompiled with CFR 0.152.
 */
package com.mia.ftbtrophies.events;

import com.mia.craftstudio.CSModel;
import com.mia.craftstudio.CraftStudioLib;
import com.mia.craftstudio.minecraft.CraftStudioRendererVBO;
import com.mia.craftstudio.minecraft.ModelMetadata;
import com.mia.craftstudio.minecraft.client.CSClientModelWrapperVBO;
import com.mia.craftstudio.minecraft.client.CSClientModelWrapperVariableVBO;
import com.mia.craftstudio.utils.ImageIOCS;
import com.mia.ftbtrophies.FTBTrophies;
import com.mia.ftbtrophies.TrophyModelMetadata;
import com.mia.ftbtrophies.client.fx.EntityCustomRainFX;
import com.mia.ftbtrophies.client.fx.ParticleHandler;
import com.mia.ftbtrophies.client.renderers.RendererTrophy;
import com.mia.ftbtrophies.common.TileTrophy;
import com.mia.ftbtrophies.events.ClientEventHandler;
import com.mia.ftbtrophies.events.CommonProxy;
import cpw.mods.fml.client.registry.ClientRegistry;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class ClientProxy
extends CommonProxy {
    @Override
    public void setupModelWrappers() {
        ArrayList<TrophyModelMetadata> models = new ArrayList<TrophyModelMetadata>(FTBTrophies.modelData.values());
        for (ModelMetadata modelMetadata : models) {
            if (modelMetadata instanceof TrophyModelMetadata && ((TrophyModelMetadata)modelMetadata).hasVariableRendering) {
                new CSClientModelWrapperVariableVBO(modelMetadata);
            } else {
                new CSClientModelWrapperVBO(modelMetadata);
            }
            for (CSModel.ModelNode node : modelMetadata.csmodel.getTopNodes()) {
                ((CSClientModelWrapperVBO)modelMetadata.wrapper).addRenderer(new CraftStudioRendererVBO(modelMetadata.wrapper.nodeCache.get((Object)node)));
            }
        }
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager resourcemanager) {
                CraftStudioLib.getTimer().reset("Total mipmap");
                ArrayList<TrophyModelMetadata> models = new ArrayList<TrophyModelMetadata>(FTBTrophies.modelData.values());
                for (ModelMetadata modelMetadata : models) {
                    BufferedImage modelTexture = modelMetadata.csmodel.getTexture();
                    try {
                        modelTexture = ImageIOCS.read((InputStream)Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("ftbtrophies".toLowerCase(), String.format("textures/models/%s", modelMetadata.textureOverride))).func_110527_b());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ((CSClientModelWrapperVBO)modelMetadata.wrapper).deleteGlTexture();
                    ((CSClientModelWrapperVBO)modelMetadata.wrapper).bindGlTexture();
                    int mipmapLevels = Minecraft.func_71410_x().field_71474_y.field_151442_I;
                    if (mipmapLevels > 0) {
                        GL11.glTexParameteri((int)3553, (int)33085, (int)mipmapLevels);
                        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                        GL11.glTexParameterf((int)3553, (int)33083, (float)mipmapLevels);
                        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
                    }
                    for (int lvl = 0; lvl <= mipmapLevels; ++lvl) {
                        GL11.glTexImage2D((int)3553, (int)lvl, (int)6408, (int)(modelTexture.getWidth() >> lvl), (int)(modelTexture.getHeight() >> lvl), (int)0, (int)32993, (int)33639, (IntBuffer)null);
                    }
                    int[][] imgArray = new int[1 + mipmapLevels][];
                    imgArray[0] = modelTexture.getRGB(0, 0, modelTexture.getWidth(), modelTexture.getHeight(), null, 0, modelTexture.getWidth());
                    CraftStudioLib.getTimer().start("mipmap");
                    int[][] mipdata = ImageIOCS.generateMipmapData((int)mipmapLevels, (int)modelTexture.getWidth(), (int[][])imgArray);
                    CraftStudioLib.getTimer().stop("mipmap");
                    CraftStudioLib.getTimer().add("Total mipmap", "mipmap");
                    TextureUtil.func_147955_a((int[][])mipdata, (int)modelTexture.getWidth(), (int)modelTexture.getHeight(), (int)0, (int)0, (boolean)false, (boolean)false);
                }
                CraftStudioLib.getTimer().printAcc("Total mipmap");
            }
        });
    }

    @Override
    public void init() {
        super.init();
        ClientEventHandler.register();
    }

    private void conditionallyRegisterCommand(String name) {
        try {
            ClientCommandHandler.instance.func_71560_a((ICommand)ClientProxy.class.getClassLoader().loadClass(name).newInstance());
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public void preInit() {
        RendererTrophy renderer = new RendererTrophy();
        ClientRegistry.bindTileEntitySpecialRenderer(TileTrophy.class, (TileEntitySpecialRenderer)renderer);
        MinecraftForgeClient.registerItemRenderer((Item)FTBTrophies.itemTrophies, (IItemRenderer)renderer);
        this.conditionallyRegisterCommand("com.mia.ftbtrophies.commands.client.CommandExportToCS");
        this.conditionallyRegisterCommand("com.mia.ftbtrophies.commands.client.CommandMakeResources");
    }

    @Override
    public void renderCustomRain(World world, double xp, double yp, double zp, float size) {
        ParticleHandler.INSTANCE.renderParticle(new EntityCustomRainFX(world, xp, yp, zp, size));
    }

    @Override
    public TileEntity getTileEntity(int dim, int x, int y, int z) {
        return Minecraft.func_71410_x().field_71441_e.func_147438_o(x, y, z);
    }
}

